/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.SideBorder;
import com.intellij.ui.border.NamedBorder;
import com.intellij.ui.border.NamedBorderKt;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicPanelUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationPanel
extends JPanel
implements IntentionActionProvider,
Weighted {
    private static final Supplier<EditorColorsScheme> GLOBAL_SCHEME_SUPPLIER = () -> EditorColorsManager.getInstance().getGlobalScheme();
    private static final Consumer<Class<?>> VOID_CONSUMER = __ -> {};
    private static final String BORDER_WITHOUT_STATUS = "borderWithoutStatus";
    private static final String BORDER_WITH_STATUS = "borderWithStatus";
    protected final JLabel myLabel;
    protected final JLabel myGearLabel;
    protected final JPanel myLinksPanel;
    private JPanel myLastPanel;
    private InplaceButton myCloseButton;
    private Runnable myCloseAction;
    private static Icon CLOSE_ICON;
    @NotNull
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    @Nullable
    protected final Color myBackgroundColor;
    @NotNull
    protected final ColorKey myBackgroundColorKey;
    @NotNull
    private Consumer<? super Class<?>> myClassConsumer;

    public EditorNotificationPanel(@Nullable Color backgroundColor) {
        this(null, backgroundColor);
    }

    public EditorNotificationPanel(@Nullable Color backgroundColor, @NotNull Status status) {
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(0);
        }
        this((FileEditor)null, backgroundColor, null, status);
    }

    public EditorNotificationPanel(@Nullable FileEditor fileEditor, @Nullable Color backgroundColor) {
        this(fileEditor, backgroundColor, null);
    }

    public EditorNotificationPanel(@NotNull ColorKey backgroundColorKey) {
        if (backgroundColorKey == null) {
            EditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this((FileEditor)null, null, backgroundColorKey);
    }

    public EditorNotificationPanel(@NotNull ColorKey backgroundColorKey, @NotNull Status status) {
        if (backgroundColorKey == null) {
            EditorNotificationPanel.$$$reportNull$$$0(2);
        }
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(3);
        }
        this((FileEditor)null, null, backgroundColorKey, status);
    }

    public EditorNotificationPanel() {
        this((FileEditor)null);
    }

    public EditorNotificationPanel(@Nullable FileEditor fileEditor) {
        this(fileEditor, null, null);
    }

    public EditorNotificationPanel(@Nullable FileEditor fileEditor, @Nullable Color backgroundColor, @Nullable ColorKey backgroundColorKey) {
        Editor editor;
        if (fileEditor instanceof TextEditor) {
            TextEditor te = (TextEditor)fileEditor;
            editor = te.getEditor();
        } else {
            editor = null;
        }
        this(editor, backgroundColor, backgroundColorKey);
    }

    public EditorNotificationPanel(@Nullable Editor editor, @Nullable Color backgroundColor, @Nullable ColorKey backgroundColorKey) {
        super(new BorderLayout());
        this.myLabel = new JLabel();
        this.myGearLabel = new JLabel();
        this.myLinksPanel = new NonOpaquePanel(new HorizontalLayout(16));
        this.myClassConsumer = VOID_CONSUMER;
        this.mySchemeSupplier = editor != null ? () -> editor.getColorsScheme() : GLOBAL_SCHEME_SUPPLIER;
        this.myBackgroundColor = backgroundColor;
        this.myBackgroundColorKey = backgroundColorKey != null ? backgroundColorKey : EditorColors.NOTIFICATION_BACKGROUND;
        this.putClientProperty(FileEditorManager.SEPARATOR_COLOR, JBUI.CurrentTheme.Editor.BORDER_COLOR);
        NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
        panel2.add("Center", this.myLabel);
        panel2.add("East", this.myLinksPanel);
        panel2.setMinimumSize(new Dimension(0, 0));
        Wrapper gearWrapper = new Wrapper(this.myGearLabel);
        gearWrapper.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return EditorNotificationPanel.this.myGearLabel.getIcon() == null ? super.getBorderInsets(c) : new JBInsets(0, 5, 0, 0);
            }
        });
        this.add("Center", panel2);
        this.add("East", gearWrapper);
        this.setBorder((Border)EditorNotificationPanel.borderWithoutStatus());
        this.setOpaque(true);
        this.myLabel.setForeground(this.mySchemeSupplier.get().getDefaultForeground());
        this.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, UnscaledGaps.EMPTY);
    }

    public EditorNotificationPanel(@NotNull Status status) {
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(4);
        }
        this((Editor)null, null, null, status);
    }

    public EditorNotificationPanel(@Nullable FileEditor fileEditor, @NotNull Status status) {
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(5);
        }
        this(fileEditor, null, null, status);
    }

    public EditorNotificationPanel(@Nullable FileEditor fileEditor, @Nullable Color backgroundColor, @Nullable ColorKey backgroundColorKey, @NotNull Status status) {
        Editor editor;
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(6);
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor te = (TextEditor)fileEditor;
            editor = te.getEditor();
        } else {
            editor = null;
        }
        this(editor, backgroundColor, backgroundColorKey, status);
    }

    public EditorNotificationPanel(@Nullable Editor editor, @Nullable Color backgroundColor, @Nullable ColorKey backgroundColorKey, @NotNull Status status) {
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(7);
        }
        this(editor, ExperimentalUI.isNewUI() ? status.background : backgroundColor, backgroundColorKey);
        if (!ExperimentalUI.isNewUI()) {
            return;
        }
        final Icon icon = status.getIcon();
        this.myLabel.setIconTextGap(JBUI.scale((int)8));
        this.myLabel.setIcon(new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int x, int y) {
                if (!StringUtil.isEmpty((String)EditorNotificationPanel.this.myLabel.getText())) {
                    icon.paintIcon(component, graphics, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        });
        this.myLabel.setForeground(JBUI.CurrentTheme.Banner.FOREGROUND);
        this.myLabel.setBorder((Border)JBUI.Borders.emptyRight((int)20));
        this.setBorder((Border)EditorNotificationPanel.borderWithStatus());
        this.putClientProperty(FileEditorManager.SEPARATOR_BORDER, new SideBorder(status.border, 10));
        Container parent = this.myGearLabel.getParent();
        parent.remove(this.myGearLabel);
        this.remove(parent);
        this.myLastPanel = new NonOpaquePanel(new HorizontalLayout(16)){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (!(EditorNotificationPanel.this.myGearLabel.getIcon() != null || EditorNotificationPanel.this.myCloseButton != null && EditorNotificationPanel.this.myCloseButton.isVisible())) {
                    size.width = 0;
                }
                return size;
            }
        };
        this.myLastPanel.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return EditorNotificationPanel.this.myGearLabel.getIcon() == null && (EditorNotificationPanel.this.myCloseButton == null || !EditorNotificationPanel.this.myCloseButton.isVisible()) ? super.getBorderInsets(c) : new JBInsets(0, 16, 0, 0);
            }
        });
        this.myLastPanel.add(this.myGearLabel);
        this.add("East", this.myLastPanel);
    }

    public static void wrapPanels(@NotNull List<EditorNotificationPanel> panels, @NotNull JPanel panel2, @NotNull Status status) {
        if (panels == null) {
            EditorNotificationPanel.$$$reportNull$$$0(8);
        }
        if (panel2 == null) {
            EditorNotificationPanel.$$$reportNull$$$0(9);
        }
        if (status == null) {
            EditorNotificationPanel.$$$reportNull$$$0(10);
        }
        if (panels.isEmpty()) {
            return;
        }
        Border border = (Border)ClientProperty.get((Component)panels.get(0), (Key)FileEditorManager.SEPARATOR_BORDER);
        if (border == null) {
            for (EditorNotificationPanel editorPanel : panels) {
                panel2.add(editorPanel);
            }
        } else {
            panel2.putClientProperty(FileEditorManager.SEPARATOR_BORDER, border);
            int size = panels.size();
            for (int i = 0; i < size; ++i) {
                EditorNotificationPanel editorPanel = panels.get(i);
                if (i == size - 1) {
                    panel2.add(editorPanel);
                    continue;
                }
                NonOpaquePanel wrapper = new NonOpaquePanel(editorPanel);
                wrapper.setBorder((Border)new SideBorder(status.border, 8));
                panel2.add(wrapper);
            }
        }
    }

    @NotNull
    private static NamedBorder borderWithoutStatus() {
        NamedBorder namedBorder = NamedBorderKt.withName((Border)JBUI.Borders.empty((Insets)JBUI.CurrentTheme.Editor.Notification.borderInsetsWithoutStatus()), (String)BORDER_WITHOUT_STATUS);
        if (namedBorder == null) {
            EditorNotificationPanel.$$$reportNull$$$0(11);
        }
        return namedBorder;
    }

    @NotNull
    private static NamedBorder borderWithStatus() {
        NamedBorder namedBorder = NamedBorderKt.withName((Border)JBUI.Borders.empty((Insets)JBUI.CurrentTheme.Editor.Notification.borderInsets()), (String)BORDER_WITH_STATUS);
        if (namedBorder == null) {
            EditorNotificationPanel.$$$reportNull$$$0(12);
        }
        return namedBorder;
    }

    @Override
    public void updateUI() {
        String borderName = null;
        Object object = this.getBorder();
        if (object instanceof NamedBorder) {
            NamedBorder border = (NamedBorder)object;
            borderName = border.getName();
        }
        this.setUI(new BasicPanelUI(this){

            @Override
            protected void installDefaults(JPanel p) {
            }
        });
        NamedBorder updatedBorder = null;
        if (borderName != null) {
            switch (borderName) {
                case "borderWithoutStatus": {
                    NamedBorder namedBorder = EditorNotificationPanel.borderWithoutStatus();
                    break;
                }
                case "borderWithStatus": {
                    NamedBorder namedBorder = EditorNotificationPanel.borderWithStatus();
                    break;
                }
                default: {
                    NamedBorder namedBorder = updatedBorder = null;
                }
            }
        }
        if (updatedBorder != null) {
            this.setBorder((Border)updatedBorder);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public ColorKey getBackgroundColorKey() {
        return this.myBackgroundColor == null ? this.myBackgroundColorKey : null;
    }

    @ApiStatus.Internal
    @Nullable
    public Color getOverriddenBackgroundColor() {
        return this.myBackgroundColor;
    }

    @Override
    public Color getBackground() {
        return (Color)ObjectUtils.notNull((Object)this.getOverriddenBackgroundColor(), (Object)((Color)ObjectUtils.notNull((Object)this.mySchemeSupplier.get().getColor(this.getBackgroundColorKey()), (Object)this.getFallbackBackgroundColor())));
    }

    @ApiStatus.Internal
    @NotNull
    public Color getFallbackBackgroundColor() {
        Color color = UIUtil.getToolTipBackground();
        if (color == null) {
            EditorNotificationPanel.$$$reportNull$$$0(13);
        }
        return color;
    }

    @ApiStatus.Internal
    public void setClassConsumer(@NotNull Consumer<? super Class<?>> classConsumer) {
        if (classConsumer == null) {
            EditorNotificationPanel.$$$reportNull$$$0(14);
        }
        this.myClassConsumer = classConsumer;
    }

    public static Color getToolbarBackground() {
        return UIUtil.getPanelBackground();
    }

    public void setText(@NlsContexts.Label @NotNull String text) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(15);
        }
        this.myLabel.setText(text);
    }

    @Nullable
    public HyperlinkLabel findLabelByName(@NlsContexts.Label @NotNull String text) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(16);
        }
        Optional<Component> found = Arrays.stream(this.myLinksPanel.getComponents()).filter(it -> {
            if (!(it instanceof HyperlinkLabel)) {
                return false;
            }
            return ((HyperlinkLabel)it).myText.equals(text);
        }).findFirst();
        return found.orElse(null);
    }

    public EditorNotificationPanel text(@NlsContexts.Label @NotNull String text) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(17);
        }
        this.myLabel.setText(text);
        return this;
    }

    @NlsContexts.Label
    @NotNull
    public String getText() {
        String string = this.myLabel.getText();
        if (string == null) {
            EditorNotificationPanel.$$$reportNull$$$0(18);
        }
        return string;
    }

    public EditorNotificationPanel icon(@NotNull Icon icon) {
        if (icon == null) {
            EditorNotificationPanel.$$$reportNull$$$0(19);
        }
        this.myLabel.setIcon(icon);
        return this;
    }

    public EditorNotificationPanel noIcon() {
        this.myLabel.setIcon(null);
        return this;
    }

    @NotNull
    public final HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text, @NotNull @NonNls String actionId) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(20);
        }
        if (actionId == null) {
            EditorNotificationPanel.$$$reportNull$$$0(21);
        }
        return this.createActionLabel(text, actionId, true);
    }

    @NotNull
    public final HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text, final @NotNull @NonNls String actionId, boolean showInIntentionMenu) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(22);
        }
        if (actionId == null) {
            EditorNotificationPanel.$$$reportNull$$$0(23);
        }
        HyperlinkLabel hyperlinkLabel = this.createActionLabel(text, new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent event) {
                if (panel2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    6.$$$reportNull$$$0(1);
                }
                EditorNotificationPanel.this.executeAction(actionId, event);
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile psiFile) {
                if (editor == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (psiFile == null) {
                    6.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, showInIntentionMenu);
        if (hyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(24);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public final HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text, @NotNull Runnable action) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(25);
        }
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(26);
        }
        HyperlinkLabel hyperlinkLabel = this.createActionLabel(text, action, true);
        if (hyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(27);
        }
        return hyperlinkLabel;
    }

    @NotNull
    private static Icon getCloseIcon() {
        if (CLOSE_ICON == null) {
            CLOSE_ICON = AllIcons.General.Close;
        }
        Icon icon = CLOSE_ICON;
        if (icon == null) {
            EditorNotificationPanel.$$$reportNull$$$0(28);
        }
        return icon;
    }

    @NotNull
    public final InplaceButton setCloseAction(@NotNull Runnable action) {
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(29);
        }
        this.myCloseAction = action;
        if (this.myCloseButton == null) {
            this.myCloseButton = new InplaceButton(IdeBundle.message("editor.banner.close.tooltip", new Object[0]), EditorNotificationPanel.getCloseIcon(), e -> this.myCloseAction.run());
            this.myCloseButton.setCursor(Cursor.getPredefinedCursor(12));
            if (this.myLastPanel == null) {
                this.myLinksPanel.add(this.myCloseButton);
            } else {
                this.myLastPanel.add(this.myCloseButton);
            }
        }
        InplaceButton inplaceButton = this.myCloseButton;
        if (inplaceButton == null) {
            EditorNotificationPanel.$$$reportNull$$$0(30);
        }
        return inplaceButton;
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text, @NotNull Runnable action, boolean showInIntentionMenu) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(31);
        }
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(32);
        }
        return new ActionHyperlinkLabel(text, this.withLogNotifications(action), showInIntentionMenu);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel @NotNull String text, @NotNull ActionHandler handler, boolean showInIntentionMenu) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(33);
        }
        if (handler == null) {
            EditorNotificationPanel.$$$reportNull$$$0(34);
        }
        return new ActionHyperlinkLabel(text, this.withNotifications(handler), showInIntentionMenu);
    }

    public void clear() {
        this.myLabel.setText("");
        this.myLinksPanel.removeAll();
    }

    protected void executeAction(@NonNls String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            throw new AssertionError((Object)("'" + actionId + "' is not an found"));
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)this.getActionPlace(), (DataContext)dataContext);
        ActionUtil.performAction(action, event);
    }

    protected void executeAction(@NonNls String actionId, @NotNull HyperlinkEvent e) {
        AnAction action;
        if (e == null) {
            EditorNotificationPanel.$$$reportNull$$$0(35);
        }
        if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
            throw new AssertionError((Object)("'" + actionId + "' is not an found"));
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        AnActionEvent event = AnActionEvent.createEvent((DataContext)dataContext, null, (String)this.getActionPlace(), (ActionUiKind)ActionUiKind.TOOLBAR, (InputEvent)e.getInputEvent());
        ActionUtil.performAction(action, event);
    }

    @NotNull
    protected String getActionPlace() {
        return "unknown";
    }

    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        MyIntentionAction action = new MyIntentionAction();
        return action.myOptions.isEmpty() ? null : action;
    }

    @Override
    public double getWeight() {
        return (double)(this.getClass().hashCode() % Integer.MAX_VALUE) / 2.147483647E9;
    }

    @Nullable
    @IntentionName
    protected String getIntentionActionText() {
        return null;
    }

    @NotNull
    protected PriorityAction.Priority getIntentionActionPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.NORMAL;
        if (priority == null) {
            EditorNotificationPanel.$$$reportNull$$$0(36);
        }
        return priority;
    }

    @NotNull
    @Nls
    protected String getIntentionActionFamilyName() {
        String string = IdeBundle.message("intention.family.editor.notification", new Object[0]);
        if (string == null) {
            EditorNotificationPanel.$$$reportNull$$$0(37);
        }
        return string;
    }

    private void logNotificationActionInvocation(@NotNull Object handlerClass) {
        if (handlerClass == null) {
            EditorNotificationPanel.$$$reportNull$$$0(38);
        }
        this.myClassConsumer.accept(handlerClass.getClass());
    }

    @NotNull
    private ActionHandler withLogNotifications(final @NotNull Runnable action) {
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(39);
        }
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                if (panel2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                    action.run();
                }
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                if (editor == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    7.$$$reportNull$$$0(3);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                    action.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private ActionHandler withNotifications(final @NotNull ActionHandler handler) {
        if (handler == null) {
            EditorNotificationPanel.$$$reportNull$$$0(40);
        }
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                if (panel2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handlePanelActionClick(panel2, e);
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                if (editor == null) {
                    8.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    8.$$$reportNull$$$0(3);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handleQuickFixClick(editor, file);
            }

            @Override
            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Editor editor, @NotNull PsiFile psiFile) {
                if (editor == null) {
                    8.$$$reportNull$$$0(4);
                }
                if (psiFile == null) {
                    8.$$$reportNull$$$0(5);
                }
                IntentionPreviewInfo intentionPreviewInfo = handler.generatePreview(editor, psiFile);
                if (intentionPreviewInfo == null) {
                    8.$$$reportNull$$$0(6);
                }
                return intentionPreviewInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$8";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generatePreview";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "handleQuickFixClick";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "generatePreview";
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static Icon getPromoIcon() {
        if (PlatformUtils.isPyCharm()) {
            Icon icon = AllIcons.Ultimate.PycharmLock;
            if (icon == null) {
                EditorNotificationPanel.$$$reportNull$$$0(41);
            }
            return icon;
        }
        Icon icon = AllIcons.Ultimate.Lock;
        if (icon == null) {
            EditorNotificationPanel.$$$reportNull$$$0(42);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 18, 24, 27, 28, 30, 36, 37, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundColorKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorNotificationPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classConsumer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = BORDER_WITHOUT_STATUS;
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = BORDER_WITH_STATUS;
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackBackgroundColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionLabel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseIcon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setCloseAction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionPriority";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionFamilyName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromoIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapPanels";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 36: 
            case 37: 
            case 41: 
            case 42: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setClassConsumer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findLabelByName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "icon";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createActionLabel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setCloseAction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvocation";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "withLogNotifications";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "withNotifications";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 18, 24, 27, 28, 30, 36, 37, 41, 42 -> new IllegalStateException(string);
        };
    }

    public static enum Status {
        Info(JBUI.CurrentTheme.Banner.INFO_BACKGROUND, JBUI.CurrentTheme.Banner.INFO_BORDER_COLOR, () -> AllIcons.General.BalloonInformation),
        Success(JBUI.CurrentTheme.Banner.SUCCESS_BACKGROUND, JBUI.CurrentTheme.Banner.SUCCESS_BORDER_COLOR, () -> AllIcons.Status.Success),
        Warning(JBUI.CurrentTheme.Banner.WARNING_BACKGROUND, JBUI.CurrentTheme.Banner.WARNING_BORDER_COLOR, () -> AllIcons.General.BalloonWarning),
        Error(JBUI.CurrentTheme.Banner.ERROR_BACKGROUND, JBUI.CurrentTheme.Banner.ERROR_BORDER_COLOR, () -> AllIcons.General.BalloonError),
        Promo(JBUI.CurrentTheme.Banner.INFO_BACKGROUND, JBUI.CurrentTheme.Banner.INFO_BORDER_COLOR, EditorNotificationPanel::getPromoIcon);

        final Color background;
        final Color border;
        private final Supplier<Icon> icon;

        private Status(@NotNull Color background, Color border, Supplier<Icon> icon) {
            if (background == null) {
                Status.$$$reportNull$$$0(0);
            }
            if (border == null) {
                Status.$$$reportNull$$$0(1);
            }
            if (icon == null) {
                Status.$$$reportNull$$$0(2);
            }
            this.background = background;
            this.border = border;
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/EditorNotificationPanel$Status";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionHandler {
        public void handlePanelActionClick(@NotNull EditorNotificationPanel var1, @NotNull HyperlinkEvent var2);

        public void handleQuickFixClick(@NotNull Editor var1, @NotNull PsiFile var2);

        @NotNull
        default public IntentionPreviewInfo generatePreview(@NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (editor == null) {
                ActionHandler.$$$reportNull$$$0(0);
            }
            if (psiFile == null) {
                ActionHandler.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ActionHandler.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$ActionHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$ActionHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ActionHyperlinkLabel
    extends HyperlinkLabel {
        private JLabel mySizeLabel;
        @NotNull
        private final ActionHandler myHandler;
        private final boolean myShowInIntentionMenu;

        private ActionHyperlinkLabel(@NotNull String text, ActionHandler handler, boolean showInIntentionMenu) {
            if (text == null) {
                ActionHyperlinkLabel.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ActionHyperlinkLabel.$$$reportNull$$$0(1);
            }
            super(text, EditorNotificationPanel.this.getBackground());
            this.myHandler = handler;
            this.myShowInIntentionMenu = showInIntentionMenu;
            EditorNotificationPanel.this.myLinksPanel.add(this);
            this.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!ActionHyperlinkLabel.this.isEnabled()) {
                        return;
                    }
                    WriteIntentReadAction.run(() -> ActionHyperlinkLabel.this.myHandler.handlePanelActionClick(EditorNotificationPanel.this, e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/EditorNotificationPanel$ActionHyperlinkLabel$1", "hyperlinkActivated"));
                }
            });
        }

        void handleIntentionActionClick(Editor editor, PsiFile file) {
            if (editor == null || file == null) {
                return;
            }
            this.myHandler.handleQuickFixClick(editor, file);
        }

        @Override
        protected int getStringWidth(@Nls String text, FontMetrics fm) {
            if (this.mySizeLabel == null) {
                this.mySizeLabel = new JLabel();
            }
            this.mySizeLabel.setText(text);
            this.mySizeLabel.setFont(fm.getFont());
            return this.mySizeLabel.getPreferredSize().width;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/EditorNotificationPanel$ActionHyperlinkLabel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyIntentionAction
    implements IntentionActionWithOptions,
    Iconable,
    PriorityAction {
        private final List<IntentionAction> myOptions = new ArrayList<IntentionAction>();

        private MyIntentionAction() {
            for (Component component : EditorNotificationPanel.this.myLinksPanel.getComponents()) {
                if (!(component instanceof HyperlinkLabel)) continue;
                HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)component;
                if (component instanceof ActionHyperlinkLabel) {
                    ActionHyperlinkLabel actionLabel = (ActionHyperlinkLabel)component;
                    if (!actionLabel.myShowInIntentionMenu) continue;
                }
                this.myOptions.add(new MyLinkOption(hyperlinkLabel));
            }
            if (EditorNotificationPanel.this.myGearLabel.getIcon() != null) {
                this.myOptions.add(new MySettingsOption(EditorNotificationPanel.this.myGearLabel));
            }
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(0);
            }
            this.myOptions.get(0).invoke(project, editor, psiFile);
        }

        public boolean startInWriteAction() {
            return this.myOptions.get(0).startInWriteAction();
        }

        @NotNull
        public List<IntentionAction> getOptions() {
            List<IntentionAction> list = this.myOptions.isEmpty() ? Collections.emptyList() : this.myOptions.subList(1, this.myOptions.size());
            if (list == null) {
                MyIntentionAction.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public String getText() {
            String textOverride = EditorNotificationPanel.this.getIntentionActionText();
            if (textOverride != null) {
                String string = textOverride;
                if (string == null) {
                    MyIntentionAction.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!this.myOptions.isEmpty()) {
                String string = this.myOptions.get(0).getText();
                if (string == null) {
                    MyIntentionAction.$$$reportNull$$$0(3);
                }
                return string;
            }
            String text = EditorNotificationPanel.this.myLabel.getText();
            String string = StringUtil.isEmpty((String)text) ? EditorBundle.message("editor.notification.default.action.name", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)text, (int)50, (int)0);
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = EditorNotificationPanel.this.getIntentionActionPriority();
            if (priority == null) {
                MyIntentionAction.$$$reportNull$$$0(5);
            }
            return priority;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = EditorNotificationPanel.this.getIntentionActionFamilyName();
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(6);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(7);
            }
            return true;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(8);
            }
            if (editor == null) {
                MyIntentionAction.$$$reportNull$$$0(9);
            }
            if (psiFile == null) {
                MyIntentionAction.$$$reportNull$$$0(10);
            }
            IntentionPreviewInfo intentionPreviewInfo = this.myOptions.get(0).generatePreview(project, editor, psiFile);
            if (intentionPreviewInfo == null) {
                MyIntentionAction.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AllIcons.Actions.IntentionBulb;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MySettingsOption
    implements IntentionAction,
    Iconable,
    LowPriorityAction {
        private final JLabel myLabel;

        private MySettingsOption(JLabel label2) {
            this.myLabel = label2;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = EditorBundle.message("editor.notification.settings.option.name", new Object[0]);
            if (string == null) {
                MySettingsOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = IdeBundle.message("intention.family.editor.notification.settings", new Object[0]);
            if (string == null) {
                MySettingsOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(3);
            }
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 501, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        public boolean startInWriteAction() {
            return false;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myLabel.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyLinkOption
    implements IntentionAction {
        private final HyperlinkLabel myLabel;

        private MyLinkOption(HyperlinkLabel label2) {
            this.myLabel = label2;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.myLabel.getText();
            if (string == null) {
                MyLinkOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = IdeBundle.message("intention.family.editor.notification.option", new Object[0]);
            if (string == null) {
                MyLinkOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
            HyperlinkLabel hyperlinkLabel;
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(3);
            }
            if ((hyperlinkLabel = this.myLabel) instanceof ActionHyperlinkLabel) {
                ActionHyperlinkLabel actionLabel = (ActionHyperlinkLabel)hyperlinkLabel;
                actionLabel.handleIntentionActionClick(editor, psiFile);
            } else {
                this.myLabel.doClick();
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            HyperlinkLabel hyperlinkLabel;
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                MyLinkOption.$$$reportNull$$$0(5);
            }
            if (psiFile == null) {
                MyLinkOption.$$$reportNull$$$0(6);
            }
            if ((hyperlinkLabel = this.myLabel) instanceof ActionHyperlinkLabel) {
                ActionHyperlinkLabel actionLabel = (ActionHyperlinkLabel)hyperlinkLabel;
                IntentionPreviewInfo intentionPreviewInfo = actionLabel.myHandler.generatePreview(editor, psiFile);
                if (intentionPreviewInfo == null) {
                    MyLinkOption.$$$reportNull$$$0(7);
                }
                return intentionPreviewInfo;
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MyLinkOption.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

