/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.IdeProxyAuthenticatorKt;
import com.intellij.util.net.ProxyAuthentication;
import com.intellij.util.net.ProxyUtils;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014JY\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u000b\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/net/IdeProxyAuthenticator;", "Ljava/net/Authenticator;", "proxyAuth", "Lcom/intellij/util/net/ProxyAuthentication;", "<init>", "(Lcom/intellij/util/net/ProxyAuthentication;)V", "getPasswordAuthentication", "Ljava/net/PasswordAuthentication;", "requestPasswordAuthenticationInstance", "host", "", "addr", "Ljava/net/InetAddress;", "port", "", "protocol", "prompt", "Lcom/intellij/openapi/util/NlsSafe;", "scheme", "url", "Ljava/net/URL;", "reqType", "Ljava/net/Authenticator$RequestorType;", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIdeProxyAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeProxyAuthenticator.kt\ncom/intellij/util/net/IdeProxyAuthenticator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n60#2,5:78\n*S KotlinDebug\n*F\n+ 1 IdeProxyAuthenticator.kt\ncom/intellij/util/net/IdeProxyAuthenticator\n*L\n53#1:78,5\n*E\n"})
public final class IdeProxyAuthenticator
extends Authenticator {
    @NotNull
    private final ProxyAuthentication proxyAuth;

    public IdeProxyAuthenticator(@NotNull ProxyAuthentication proxyAuth) {
        Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
        this.proxyAuth = proxyAuth;
    }

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        return Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme(), this.getRequestingURL(), this.getRequestorType());
    }

    @Override
    @Nullable
    public PasswordAuthentication requestPasswordAuthenticationInstance(@Nullable String host, @Nullable InetAddress addr, int port, @Nullable String protocol, @NotNull String prompt, @Nullable String scheme, @Nullable URL url, @NotNull Authenticator.RequestorType reqType) {
        block7: {
            Object object;
            String string;
            block9: {
                block8: {
                    String host2;
                    Credentials credentials;
                    boolean isProxy;
                    Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                    Intrinsics.checkNotNullParameter((Object)((Object)reqType), (String)"reqType");
                    Logger $this$debug_u24default$iv = IdeProxyAuthenticatorKt.access$getLOG$p();
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        String string2 = Integer.toString(System.identityHashCode(this), CharsKt.checkRadix((int)16));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        logger.debug("Auth@" + string2 + "{type=" + reqType + ", scheme=" + scheme + ", protocol=" + protocol + ", prompt=" + prompt + ", host=" + host + ", port=" + port + ", site=" + addr + ", url=" + url + "} on " + Thread.currentThread(), t$iv);
                    }
                    boolean bl = isProxy = Authenticator.RequestorType.PROXY == reqType || Intrinsics.areEqual((Object)"SOCKS authentication", (Object)prompt);
                    if (!isProxy) {
                        return null;
                    }
                    String string3 = ProxyUtils.getHostNameReliably(host, addr, url);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((credentials = this.proxyAuth.getKnownAuthentication(host2 = string3, port)) == null || credentials.getUserName() == null || credentials.getPassword() == null) {
                        credentials = this.proxyAuth.getPromptedAuthentication(prompt, host2, port);
                    }
                    if (credentials == null || credentials.getUserName() == null) break block7;
                    string = credentials.getUserName();
                    Intrinsics.checkNotNull((Object)string);
                    object = credentials.getPassword();
                    if (object == null) break block8;
                    char[] cArray = OneTimeString.toCharArray$default((OneTimeString)object, (boolean)false, (int)1, null);
                    object = cArray;
                    if (cArray != null) break block9;
                }
                object = new char[0];
            }
            return new PasswordAuthentication(string, (char[])object);
        }
        return null;
    }
}

