/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions.commit;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJM\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\r\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018JT\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007JH\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010 \u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/actions/commit/CheckinActionUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "updateCommonCommitAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performCommonCommitAction", "project", "Lcom/intellij/openapi/project/Project;", "initialChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "pathsToCommit", "", "Lcom/intellij/openapi/vcs/FilePath;", "actionName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "forceUpdateCommitStateFromContext", "", "performCheckInAfterUpdate", "selectedChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "selectedUnversioned", "getIncludedChanges", "", "getInitiallySelectedChangeList", "getInitiallySelectedChangeListFor", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCheckinActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,148:1\n37#2,2:149\n1#3:151\n13#4:152\n*S KotlinDebug\n*F\n+ 1 CheckinActionUtil.kt\ncom/intellij/openapi/vcs/actions/commit/CheckinActionUtil\n*L\n73#1:149,2\n27#1:152\n*E\n"})
public final class CheckinActionUtil {
    @NotNull
    public static final CheckinActionUtil INSTANCE = new CheckinActionUtil();
    @NotNull
    private static final Logger LOG;

    private CheckinActionUtil() {
    }

    public final void updateCommonCommitAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (project == null || !ProjectLevelVcsManager.Companion.getInstance(project).hasActiveVcss() || CommitModeManager.Companion.getInstance(project).getCurrentCommitMode().isDefaultCommitActionDisabled()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.Companion.getInstance(project);
        AbstractVcs singleVcs = projectLevelVcsManager.getSingleVCS();
        presentation2.setEnabled(!projectLevelVcsManager.isBackgroundVcsOperationRunning() && (singleVcs == null || !singleVcs.isCommitActionDisabled()));
        presentation2.setVisible(true);
    }

    public final void performCommonCommitAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable String actionName, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        LOG.debug("performCommonCommitAction");
        String string2 = actionName;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String operationName = AbstractCommitWorkflowKt.cleanActionText$default(actionName, false, 2, null);
            Object[] objectArray = new Object[]{operationName};
            string = VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])objectArray);
        } else {
            string = null;
        }
        String isFreezedDialogTitle = string;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.isFreezedWithNotification(isFreezedDialogTitle)) {
            LOG.debug("ChangeListManager is freezed, abort commit");
            return;
        }
        if (ProjectLevelVcsManager.Companion.getInstance(project).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running, abort commit");
            return;
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        List list = objectArray != null ? ArraysKt.asList((Object[])objectArray) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List selectedChanges = list;
        Iterable iterable = (Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY);
        List list2 = iterable != null ? CollectionsKt.toList((Iterable)iterable) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List selectedUnversioned = list2;
        Collection $this$toTypedArray$iv = pathsToCommit;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(thisCollection$iv.toArray(new FilePath[0]), project);
        Intrinsics.checkNotNullExpressionValue((Object)filePathArray, (String)"filterDescindingFiles(...)");
        List filteredPaths = ArraysKt.asList((Object[])filePathArray);
        this.performCheckInAfterUpdate(project, selectedChanges, selectedUnversioned, initialChangeList, filteredPaths, executor, forceUpdateCommitStateFromContext);
    }

    @RequiresEdt
    public final void performCheckInAfterUpdate(@NotNull Project project, @NotNull List<? extends Change> selectedChanges, @NotNull List<? extends FilePath> selectedUnversioned, @NotNull LocalChangeList initialChangeList, @NotNull List<? extends FilePath> pathsToCommit, @Nullable CommitExecutor executor, boolean forceUpdateCommitStateFromContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedChanges, (String)"selectedChanges");
        Intrinsics.checkNotNullParameter(selectedUnversioned, (String)"selectedUnversioned");
        Intrinsics.checkNotNullParameter((Object)initialChangeList, (String)"initialChangeList");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        StoreUtil.saveDocumentsAndProjectSettings((Project)project);
        ChangesViewCommitWorkflowHandler workflowHandler = ChangesViewWorkflowManager.Companion.getInstance(project).getCommitWorkflowHandler();
        if (executor == null && workflowHandler != null) {
            Collection<Object> included = this.getIncludedChanges(project, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit);
            workflowHandler.setCommitState(initialChangeList, included, forceUpdateCommitStateFromContext);
            workflowHandler.activate();
        } else {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdateWithModal(true, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), () -> CheckinActionUtil.performCheckInAfterUpdate$lambda$0(project, selectedChanges, selectedUnversioned, initialChangeList, pathsToCommit, executor));
        }
    }

    private final Collection<Object> getIncludedChanges(Project project, List<? extends Change> selectedChanges, List<? extends FilePath> selectedUnversioned, LocalChangeList initialChangeList, List<? extends FilePath> pathsToCommit) {
        List list = ChangeListManager.getInstance((Project)project).getResolvedConflictPaths();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResolvedConflictPaths(...)");
        List resolvedConflictPaths = list;
        if (selectedChanges.isEmpty() && selectedUnversioned.isEmpty()) {
            Collection collection = ChangeListManager.getInstance((Project)project).getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            Collection allChanges = collection;
            Set set2 = VcsImplUtil.filterChangesUnder(allChanges, (Collection<FilePath>)pathsToCommit).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"toSet(...)");
            Set changesToCommit = set2;
            Collection collection2 = initialChangeList.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getChanges(...)");
            List list2 = ContainerUtil.concat((List)resolvedConflictPaths, (List)CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)collection2, (Iterable)changesToCommit)));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"concat(...)");
            return list2;
        }
        List list3 = ContainerUtil.concat(selectedChanges, selectedUnversioned);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"concat(...)");
        List changesAndUnversioned = list3;
        List list4 = ContainerUtil.concat((List)resolvedConflictPaths, (List)changesAndUnversioned);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"concat(...)");
        return list4;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeList(@NotNull Project project, @NotNull AnActionEvent e) {
        ChangeList[] changeListArray;
        block7: {
            LocalChangeList localChangeList;
            Change change;
            ChangeListManager manager;
            block6: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
                manager = changeListManager;
                changeListArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
                if (changeListArray == null || (changeListArray = (ChangeList[])ArraysKt.firstOrNull((Object[])changeListArray)) == null) break block6;
                ChangeList[] it = changeListArray;
                boolean bl = false;
                LocalChangeList localChangeList2 = manager.findChangeList(it.getName());
                changeListArray = localChangeList2;
                if (localChangeList2 != null) break block7;
            }
            if ((change = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && (change = (Change)ArraysKt.firstOrNull((Object[])change)) != null) {
                Change it = change;
                boolean bl = false;
                localChangeList = manager.getChangeList(it);
            } else {
                localChangeList = changeListArray = null;
            }
            if (localChangeList == null) {
                LocalChangeList localChangeList3 = manager.getDefaultChangeList();
                changeListArray = localChangeList3;
                Intrinsics.checkNotNullExpressionValue((Object)localChangeList3, (String)"getDefaultChangeList(...)");
            }
        }
        return changeListArray;
    }

    @NotNull
    public final LocalChangeList getInitiallySelectedChangeListFor(@NotNull Project project, @NotNull List<? extends FilePath> pathsToCommit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pathsToCommit, (String)"pathsToCommit");
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerEx), (String)"getInstanceEx(...)");
        ChangeListManagerEx manager = changeListManagerEx;
        LocalChangeList localChangeList = manager.getDefaultChangeList();
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
        LocalChangeList defaultChangeList = localChangeList;
        JBIterable<? extends Change> jBIterable = VcsImplUtil.filterChangesUnder(defaultChangeList.getChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedInDefault = jBIterable;
        if (selectedInDefault.isNotEmpty()) {
            return defaultChangeList;
        }
        JBIterable<? extends Change> jBIterable2 = VcsImplUtil.filterChangesUnder(manager.getAllChanges(), (Collection<FilePath>)pathsToCommit);
        Intrinsics.checkNotNullExpressionValue(jBIterable2, (String)"filterChangesUnder(...)");
        JBIterable<? extends Change> selectedChanges = jBIterable2;
        Collection<LocalChangeList> collection = manager.getAffectedLists(selectedChanges.toList());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAffectedLists(...)");
        Collection<LocalChangeList> changeLists2 = collection;
        LocalChangeList localChangeList2 = (LocalChangeList)CollectionsKt.singleOrNull((Iterable)changeLists2);
        if (localChangeList2 == null) {
            localChangeList2 = defaultChangeList;
        }
        return localChangeList2;
    }

    private static final void performCheckInAfterUpdate$lambda$0(Project $project, List $selectedChanges, List $selectedUnversioned, LocalChangeList $initialChangeList, List $pathsToCommit, CommitExecutor $executor) {
        Collection<Object> included = INSTANCE.getIncludedChanges($project, $selectedChanges, $selectedUnversioned, $initialChangeList, $pathsToCommit);
        boolean bl = $executor != null ? CommitChangeListDialog.commitWithExecutor($project, included, $initialChangeList, $executor, null, null) : CommitChangeListDialog.commitVcsChanges($project, included, $initialChangeList, null, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CheckinActionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

