/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.combined.CombinedBlockProducer;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.tools.combined.CombinedDiffManager;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.actions.diff.WrapperCombinedBlockProducer;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerChangesTreeTracker;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerDiffRequestProcessor;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 -2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\u0006\u0010\u001e\u001a\u00020\u0010J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0004J\u0018\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0010H\u0004J\u0014\u0010(\u001a\u0004\u0018\u00010#2\b\u0010)\u001a\u0004\u0018\u00010 H\u0004J\u0014\u0010(\u001a\u0004\u0018\u00010#2\b\u0010*\u001a\u0004\u0018\u00010+H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "targetComponent", "Ljavax/swing/JComponent;", "handler", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljavax/swing/JComponent;Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;)V", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "getHandler", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "isPreviewOnDoubleClick", "", "handleDoubleClick", "e", "Ljava/awt/event/MouseEvent;", "isPreviewOnEnter", "handleEnterKey", "isOpenPreviewWithSingleClickEnabled", "isOpenPreviewWithSingleClick", "handleSingleClick", "", "isOpenPreviewWithNextDiffShortcut", "handleNextDiffShortcut", "handleEscapeKey", "returnFocusToTree", "hasContent", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "createDefaultViewer", "place", "", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "getEditorTabName", "processor", "wrapper", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "PreviewOnNextDiffAction", "Companion", "intellij.platform.vcs.impl"})
public abstract class TreeHandlerEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final ChangesTreeDiffPreviewHandler handler;

    public TreeHandlerEditorDiffPreview(@NotNull ChangesTree tree, @NotNull JComponent targetComponent, @NotNull ChangesTreeDiffPreviewHandler handler) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Project project = tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.tree = tree;
        this.handler = handler;
        this.tree.setDoubleClickHandler(arg_0 -> TreeHandlerEditorDiffPreview._init_$lambda$0(this, arg_0));
        this.tree.setEnterKeyHandler(arg_0 -> TreeHandlerEditorDiffPreview._init_$lambda$1(this, arg_0));
        this.tree.addSelectionListener(() -> TreeHandlerEditorDiffPreview._init_$lambda$2(this));
        new PreviewOnNextDiffAction().registerCustomShortcutSet(targetComponent, (Disposable)this);
        UIUtil.putClientProperty((JComponent)((JComponent)this.tree), (Key)ExpandableItemsHandler.IGNORE_ITEM_SELECTION, (Object)true);
    }

    public /* synthetic */ TreeHandlerEditorDiffPreview(ChangesTree changesTree, JComponent jComponent, ChangesTreeDiffPreviewHandler changesTreeDiffPreviewHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jComponent = (JComponent)changesTree;
        }
        this(changesTree, jComponent, changesTreeDiffPreviewHandler);
    }

    @NotNull
    protected final ChangesTree getTree() {
        return this.tree;
    }

    @NotNull
    protected final ChangesTreeDiffPreviewHandler getHandler() {
        return this.handler;
    }

    public TreeHandlerEditorDiffPreview(@NotNull ChangesTree tree, @NotNull ChangesTreeDiffPreviewHandler handler) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this(tree, (JComponent)tree, handler);
    }

    protected boolean isPreviewOnDoubleClick() {
        return true;
    }

    public boolean handleDoubleClick(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isPreviewOnDoubleClick()) {
            return false;
        }
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)this.tree), (MouseEvent)e)) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isPreviewOnEnter() {
        return true;
    }

    public boolean handleEnterKey() {
        if (!this.isPreviewOnEnter()) {
            return false;
        }
        return this.performDiffAction();
    }

    protected boolean isOpenPreviewWithSingleClickEnabled() {
        return false;
    }

    protected boolean isOpenPreviewWithSingleClick() {
        if (!this.isOpenPreviewWithSingleClickEnabled()) {
            return false;
        }
        return VcsConfiguration.getInstance((Project)this.getProject()).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
    }

    protected void handleSingleClick() {
        if (!this.isOpenPreviewWithSingleClick()) {
            return;
        }
        boolean opened = this.openPreview(false);
        if (!opened) {
            this.closePreview();
        }
    }

    protected boolean isOpenPreviewWithNextDiffShortcut() {
        return true;
    }

    protected void handleNextDiffShortcut() {
        if (!this.isOpenPreviewWithNextDiffShortcut()) {
            return;
        }
        this.openPreview(true);
    }

    protected void handleEscapeKey() {
        this.closePreview();
        ApplicationManager.getApplication().invokeLater(() -> TreeHandlerEditorDiffPreview.handleEscapeKey$lambda$0(this));
    }

    protected void returnFocusToTree() {
    }

    public final boolean hasContent() {
        return this.handler.hasContent(this.tree);
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        return this.createDefaultViewer("ChangesTreeDiffPreview");
    }

    @NotNull
    protected final DiffEditorViewer createDefaultViewer(@NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return Companion.createDefaultViewer(this.tree, this.handler, place);
    }

    @NotNull
    protected final ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        return this.handler.collectDiffProducers(this.tree, selectedOnly);
    }

    @Nullable
    protected final String getEditorTabName(@Nullable DiffEditorViewer processor2) {
        ChangeViewDiffRequestProcessor.Wrapper wrapper2;
        DiffEditorViewer diffEditorViewer = processor2;
        if (diffEditorViewer instanceof ChangeViewDiffRequestProcessor) {
            wrapper2 = ((ChangeViewDiffRequestProcessor)processor2).getCurrentChange();
        } else if (diffEditorViewer instanceof CombinedDiffComponentProcessor) {
            CombinedBlockProducer combinedBlockProducer = ((CombinedDiffComponentProcessor)processor2).getCurrentBlock();
            WrapperCombinedBlockProducer wrapperCombinedBlockProducer = combinedBlockProducer instanceof WrapperCombinedBlockProducer ? (WrapperCombinedBlockProducer)combinedBlockProducer : null;
            wrapper2 = wrapperCombinedBlockProducer != null ? wrapperCombinedBlockProducer.getWrapper() : null;
        } else {
            wrapper2 = null;
        }
        ChangeViewDiffRequestProcessor.Wrapper wrapper3 = wrapper2;
        return this.getEditorTabName(wrapper3);
    }

    @Nullable
    public abstract String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper var1);

    private static final boolean _init_$lambda$0(TreeHandlerEditorDiffPreview this$0, MouseEvent e) {
        Intrinsics.checkNotNull((Object)e);
        return this$0.handleDoubleClick(e);
    }

    private static final boolean _init_$lambda$1(TreeHandlerEditorDiffPreview this$0, KeyEvent keyEvent) {
        return this$0.handleEnterKey();
    }

    private static final void _init_$lambda$2(TreeHandlerEditorDiffPreview this$0) {
        this$0.handleSingleClick();
    }

    private static final void handleEscapeKey$lambda$0(TreeHandlerEditorDiffPreview this$0) {
        this$0.returnFocusToTree();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview$Companion;", "", "<init>", "()V", "createDefaultViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "changesTree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "previewHandler", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "place", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiffEditorViewer createDefaultViewer(@NotNull ChangesTree changesTree, @NotNull ChangesTreeDiffPreviewHandler previewHandler, @NotNull String place) {
            DiffEditorViewer diffEditorViewer;
            Intrinsics.checkNotNullParameter((Object)changesTree, (String)"changesTree");
            Intrinsics.checkNotNullParameter((Object)previewHandler, (String)"previewHandler");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            if (CombinedDiffRegistry.INSTANCE.isEnabled()) {
                Project project = changesTree.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                diffEditorViewer = (DiffEditorViewer)CombinedDiffManager.Companion.getInstance(project).createProcessor(place);
            } else {
                diffEditorViewer = (DiffEditorViewer)new TreeHandlerDiffRequestProcessor(place, changesTree, previewHandler);
            }
            DiffEditorViewer processor2 = diffEditorViewer;
            new TreeHandlerChangesTreeTracker(changesTree, processor2, previewHandler, false, 8, null).track();
            return processor2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview$PreviewOnNextDiffAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.vcs.impl"})
    private final class PreviewOnNextDiffAction
    extends DumbAwareAction {
        public PreviewOnNextDiffAction() {
            this.copyShortcutFrom(ActionManager.getInstance().getAction("NextDiff"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(TreeHandlerEditorDiffPreview.this.isOpenPreviewWithNextDiffShortcut());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeHandlerEditorDiffPreview.this.handleNextDiffShortcut();
        }
    }
}

