/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.externalProcessAuthHelper.ScriptGenerator;
import com.intellij.externalProcessAuthHelper.ScriptGeneratorUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import externalApp.ExternalApp;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScriptGeneratorImpl
implements ScriptGenerator {
    private final List<String> myInternalParameters = new ArrayList<String>();

    @NotNull
    public ScriptGeneratorImpl addParameters(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        ScriptGeneratorImpl scriptGeneratorImpl = this;
        if (scriptGeneratorImpl == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(0);
        }
        return scriptGeneratorImpl;
    }

    @Override
    @NotNull
    public String commandLine(@NotNull Class<? extends ExternalApp> mainClass, boolean useBatchFile) {
        if (mainClass == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(1);
        }
        LinkedHashSet jarPaths = new LinkedHashSet();
        ScriptGeneratorImpl.addClasses(jarPaths, mainClass);
        ScriptGeneratorImpl.addClasses(jarPaths, ExternalApp.class);
        @NonNls StringBuilder cmd = new StringBuilder();
        cmd.append('\"');
        cmd.append(this.getJavaExecutablePath());
        cmd.append('\"');
        cmd.append(" -cp ");
        cmd.append('\"');
        String classpathSeparator = String.valueOf(File.pathSeparatorChar);
        cmd.append(StringUtil.join(jarPaths, file -> file.getPath(), (String)classpathSeparator));
        cmd.append('\"');
        cmd.append(' ');
        cmd.append(mainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        String string = line;
        if (string == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getJavaExecutablePath() {
        String string = String.format("%s/bin/java", System.getProperty("java.home"));
        if (string == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void addClasses(@NotNull Set<? super File> paths, @NotNull Class<?> clazz) {
        if (paths == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            ScriptGeneratorImpl.$$$reportNull$$$0(5);
        }
        paths.add(ScriptGeneratorUtil.getJarFileFor(clazz));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalProcessAuthHelper/ScriptGeneratorImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addParameters";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalProcessAuthHelper/ScriptGeneratorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commandLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

