/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.SplitDebuggerAction;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointProxy;
import com.intellij.util.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ToggleBreakpointEnabledAction
extends DumbAwareAction
implements SplitDebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(0);
        }
        Set<XBreakpointProxy> breakpoints = ToggleBreakpointEnabledAction.findLineBreakpoints(e);
        Iterator iterator = breakpoints.iterator();
        while (iterator.hasNext()) {
            XBreakpointProxy breakpoint2;
            breakpoint2.setEnabled(!(breakpoint2 = (XBreakpointProxy)iterator.next()).isEnabled());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(!ToggleBreakpointEnabledAction.findLineBreakpoints(e).isEmpty());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static Set<XBreakpointProxy> findLineBreakpoints(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            Set<XBreakpointProxy> set = Collections.emptySet();
            if (set == null) {
                ToggleBreakpointEnabledAction.$$$reportNull$$$0(3);
            }
            return set;
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        XLineBreakpointManagerProxy lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = editor.getDocument();
        ArrayList<Range> lineRanges = new ArrayList<Range>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            lineRanges.add(new Range((Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionStart())), (Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionEnd()))));
        }
        HashSet<XBreakpointProxy> res = new HashSet<XBreakpointProxy>();
        for (XLineBreakpointProxy breakpoint2 : lineBreakpointManager.getDocumentBreakpointProxies(document)) {
            int line = breakpoint2.getLine();
            for (Range range : lineRanges) {
                if (!range.isWithin((Comparable)Integer.valueOf(line))) continue;
                res.add((XBreakpointProxy)breakpoint2);
            }
        }
        HashSet<XBreakpointProxy> hashSet = res;
        if (hashSet == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findLineBreakpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

