/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefs;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefsKt;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRootStoredRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB9\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00112\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00042\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\n\u0010\u001a\u001a\u00060\u0015j\u0002`\u0016H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/data/RefsModel;", "Lcom/intellij/vcs/log/VcsLogAggregatedStoredRefs;", "refsByRoot", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogRootStoredRefs;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "<init>", "(Ljava/util/Map;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;)V", "getRefsByRoot", "()Ljava/util/Map;", "singleRoot", "bestRefForHead", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsRef;", "rootForHead", "getRefForHeadCommit", "headIndex", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "getRootForHeadCommit", "refsToCommit", "", "index", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nRefsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n296#2,2:62\n*S KotlinDebug\n*F\n+ 1 RefsModel.kt\ncom/intellij/vcs/log/data/RefsModel\n*L\n35#1:62,2\n*E\n"})
public final class RefsModel
implements VcsLogAggregatedStoredRefs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<VirtualFile, VcsLogRootStoredRefs> refsByRoot;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> providers;
    @Nullable
    private final VirtualFile singleRoot;
    @NotNull
    private final Int2ObjectMap<VcsRef> bestRefForHead;
    @NotNull
    private final Int2ObjectMap<VirtualFile> rootForHead;

    private RefsModel(Map<VirtualFile, ? extends VcsLogRootStoredRefs> refsByRoot, VcsLogStorage storage, Map<VirtualFile, ? extends VcsLogProvider> providers) {
        this.refsByRoot = refsByRoot;
        this.storage = storage;
        this.providers = providers;
        this.singleRoot = (VirtualFile)CollectionsKt.singleOrNull((Iterable)this.getRefsByRoot().keySet());
        this.bestRefForHead = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.rootForHead = (Int2ObjectMap)new Int2ObjectOpenHashMap();
    }

    @NotNull
    public Map<VirtualFile, VcsLogRootStoredRefs> getRefsByRoot() {
        return this.refsByRoot;
    }

    @Nullable
    public VcsRef getRefForHeadCommit(int headIndex) {
        return (VcsRef)this.bestRefForHead.computeIfAbsent(headIndex, arg_0 -> RefsModel.getRefForHeadCommit$lambda$0(this, headIndex, arg_0));
    }

    @Nullable
    public VirtualFile getRootForHeadCommit(int headIndex) {
        VirtualFile virtualFile = this.singleRoot;
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.rootForHead.computeIfAbsent(headIndex, arg_0 -> RefsModel.getRootForHeadCommit$lambda$0(this, headIndex, arg_0));
        }
        return virtualFile;
    }

    @NotNull
    public List<VcsRef> refsToCommit(int index) {
        List list;
        if (this.singleRoot != null) {
            list = ((VcsLogRootStoredRefs)MapsKt.getValue(this.getRefsByRoot(), (Object)this.singleRoot)).refsToCommit(index);
        } else if (this.getRefsByRoot().size() <= 10) {
            VcsLogRootStoredRefs refs;
            Object v1;
            block8: {
                Iterable $this$firstOrNull$iv = this.getRefsByRoot().values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VcsLogRootStoredRefs it = (VcsLogRootStoredRefs)element$iv;
                    boolean bl = false;
                    if (!it.contains(index)) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            if ((list = (refs = (VcsLogRootStoredRefs)v1)) == null || (list = list.refsToCommit(index)) == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            CommitId id = this.storage.getCommitId(index);
            if (id != null) {
                VcsLogAggregatedStoredRefs vcsLogAggregatedStoredRefs = this;
                VirtualFile virtualFile = id.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                list = VcsLogAggregatedStoredRefsKt.refsToCommit((VcsLogAggregatedStoredRefs)vcsLogAggregatedStoredRefs, (VirtualFile)virtualFile, (int)index);
            } else {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    private static final VcsRef getRefForHeadCommit$lambda$0(RefsModel this$0, int $headIndex, int it) {
        CommitId commitId = this$0.storage.getCommitId($headIndex);
        if (commitId == null) {
            return null;
        }
        CommitId id = commitId;
        Iterable iterable = this$0.refsToCommit($headIndex);
        VcsLogProvider vcsLogProvider = this$0.providers.get(id.getRoot());
        Intrinsics.checkNotNull((Object)vcsLogProvider);
        Comparator comparator = vcsLogProvider.getReferenceManager().getBranchLayoutComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getBranchLayoutComparator(...)");
        return (VcsRef)CollectionsKt.minWithOrNull((Iterable)iterable, (Comparator)comparator);
    }

    private static final VirtualFile getRootForHeadCommit$lambda$0(RefsModel this$0, int $headIndex, int it) {
        CommitId commitId = this$0.storage.getCommitId($headIndex);
        return commitId != null ? commitId.getRoot() : null;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
        return Companion.createEmptyInstance(storage);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RefsModel create(@NotNull Map<VirtualFile, ? extends VcsLogRootStoredRefs> refs, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers) {
        return Companion.create(refs, storage, providers);
    }

    public /* synthetic */ RefsModel(Map refsByRoot, VcsLogStorage storage, Map providers, DefaultConstructorMarker $constructor_marker) {
        this(refsByRoot, storage, providers);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J8\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/data/RefsModel$Companion;", "", "<init>", "()V", "createEmptyInstance", "Lcom/intellij/vcs/log/data/RefsModel;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "create", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogRootStoredRefs;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            return this.create(MapsKt.emptyMap(), storage, MapsKt.emptyMap());
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RefsModel create(@NotNull Map<VirtualFile, ? extends VcsLogRootStoredRefs> refs, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers) {
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            return new RefsModel(refs, storage, providers, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

