/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.render.RootCell;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J:\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer;", "Lcom/intellij/vcs/log/ui/table/RootCellRenderer;", "properties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "<init>", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties;Lcom/intellij/vcs/log/ui/VcsLogColorManager;)V", "stripePart", "Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "paintBackground", "", "g", "Ljava/awt/Graphics2D;", "x", "", "width", "height", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "column", "getRootNameInsets", "Ljava/awt/Insets;", "Companion", "intellij.platform.vcs.log.impl"})
public final class NewUiRootCellRenderer
extends RootCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Companion.RootStripePart stripePart;

    public NewUiRootCellRenderer(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        super(properties, colorManager);
        this.stripePart = Companion.RootStripePart.SINGLE;
        this.setTextAlign(2);
    }

    @Override
    protected void paintBackground(@NotNull Graphics2D g, int x, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.myBorderColor);
        g.fillRect(x, 0, width, height);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int y = 0;
        int x2 = NewUiRootCellRenderer.Companion.getLEFT_RIGHT_GAP();
        int arc = NewUiRootCellRenderer.Companion.getARC();
        int stripeWidth = this.isNarrow ? NewUiRootCellRenderer.Companion.getNARROW_STRIPE_WIDTH() : width - 2 * NewUiRootCellRenderer.Companion.getLEFT_RIGHT_GAP();
        g.setColor(this.myColor);
        switch (WhenMappings.$EnumSwitchMapping$0[this.stripePart.ordinal()]) {
            case 1: {
                g.fillRoundRect(x2, y, stripeWidth, height + arc, arc, arc);
                break;
            }
            case 2: {
                g.fillRect(x2, y, stripeWidth, height);
                break;
            }
            case 3: {
                g.fillRoundRect(x2, y - arc, stripeWidth, height + NewUiRootCellRenderer.Companion.getBOTTOM_GAP(), arc, arc);
                break;
            }
            case 4: {
                g.fillRoundRect(x2, y, stripeWidth, height - NewUiRootCellRenderer.Companion.getBOTTOM_GAP(), arc, arc);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        config.restore();
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.stripePart = NewUiRootCellRenderer.Companion.getRootPart((RootCell)value, table, row, column);
        if (this.isNarrow) {
            Color color2 = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, false, false).getBackground();
            color = color2;
            Intrinsics.checkNotNull((Object)color2);
        } else {
            color = VcsLogGraphTable.getTableBackground();
        }
        this.myBorderColor = color;
        Intrinsics.checkNotNull((Object)renderer);
        return renderer;
    }

    @Override
    @NotNull
    protected Insets getRootNameInsets() {
        JBInsets jBInsets = JBUI.insets((int)0, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion;", "", "<init>", "()V", "LEFT_RIGHT_GAP", "", "getLEFT_RIGHT_GAP", "()I", "BOTTOM_GAP", "getBOTTOM_GAP", "ARC", "getARC", "NARROW_STRIPE_WIDTH", "getNARROW_STRIPE_WIDTH", "getRootPart", "Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "current", "Lcom/intellij/vcs/log/ui/render/RootCell;", "table", "Ljavax/swing/JTable;", "row", "column", "RootStripePart", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final int getLEFT_RIGHT_GAP() {
            return JBUIScale.scale((int)2);
        }

        private final int getBOTTOM_GAP() {
            return JBUIScale.scale((int)2);
        }

        private final int getARC() {
            return JBUIScale.scale((int)4);
        }

        private final int getNARROW_STRIPE_WIDTH() {
            return JBUIScale.scale((int)4);
        }

        private final RootStripePart getRootPart(RootCell current, JTable table, int row, int column) {
            if (current == null) {
                return RootStripePart.SINGLE;
            }
            Object prev = row > 0 ? table.getValueAt(row - 1, column) : null;
            Object next = row <= table.getRowCount() - 2 ? table.getValueAt(row + 1, column) : null;
            boolean isPrevSame = prev != null && Intrinsics.areEqual((Object)prev, (Object)current);
            boolean isNextSame = next != null && Intrinsics.areEqual((Object)next, (Object)current);
            return isPrevSame && isNextSame ? RootStripePart.MIDDLE : (!isPrevSame && !isNextSame ? RootStripePart.SINGLE : (isPrevSame ? RootStripePart.END : RootStripePart.START));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/ui/table/NewUiRootCellRenderer$Companion$RootStripePart;", "", "<init>", "(Ljava/lang/String;I)V", "START", "MIDDLE", "END", "SINGLE", "intellij.platform.vcs.log.impl"})
        private static final class RootStripePart
        extends Enum<RootStripePart> {
            public static final /* enum */ RootStripePart START = new RootStripePart();
            public static final /* enum */ RootStripePart MIDDLE = new RootStripePart();
            public static final /* enum */ RootStripePart END = new RootStripePart();
            public static final /* enum */ RootStripePart SINGLE = new RootStripePart();
            private static final /* synthetic */ RootStripePart[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static RootStripePart[] values() {
                return (RootStripePart[])$VALUES.clone();
            }

            public static RootStripePart valueOf(String value) {
                return Enum.valueOf(RootStripePart.class, value);
            }

            @NotNull
            public static EnumEntries<RootStripePart> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = rootStripePartArray = new RootStripePart[]{RootStripePart.START, RootStripePart.MIDDLE, RootStripePart.END, RootStripePart.SINGLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.RootStripePart.values().length];
            try {
                nArray[Companion.RootStripePart.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.RootStripePart.SINGLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

