/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterSettingsKt;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureTreeCellRenderer;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewModel;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u000fH\u0014J\b\u0010\u001c\u001a\u00020\u000fH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewComponent;", "Lcom/intellij/ide/structureView/newStructureView/StructureViewComponent;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "treeModel", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;Lcom/intellij/openapi/project/Project;)V", "getTreeModel", "getHeaderActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "addGroupByActions", "", "result", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "shouldUpdateStructure", "", "before", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "after", "getElementsByInterval", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "installTreePopupHandlers", "rebuild", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureViewComponent.kt\ncom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class JupyterStructureViewComponent
extends StructureViewComponent {
    public JupyterStructureViewComponent(@Nullable FileEditor fileEditor, @NotNull JupyterStructureViewModel treeModel, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)treeModel), (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(fileEditor, (StructureViewModel)treeModel, project, false);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(JupyterSettingsKt.getJUPYTER_SETTINGS_TOPIC(), (arg_0, arg_1) -> JupyterStructureViewComponent._init_$lambda$0(this, arg_0, arg_1));
        this.getTree().setCellRenderer(new JupyterStructureTreeCellRenderer());
    }

    @NotNull
    public JupyterStructureViewModel getTreeModel() {
        StructureViewModel structureViewModel = super.getTreeModel();
        Intrinsics.checkNotNull((Object)structureViewModel, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewModel");
        return (JupyterStructureViewModel)structureViewModel;
    }

    @NotNull
    public List<AnAction> getHeaderActions() {
        List list = this.addExpandCollapseActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"addExpandCollapseActions(...)");
        return list;
    }

    protected void addGroupByActions(@NotNull DefaultActionGroup result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        ActionManager actionManager = ActionManager.getInstance();
        result2.add(actionManager.getAction("JupyterStructure.SortGroup"), Constraints.FIRST);
        result2.add(actionManager.getAction("JupyterStructure.SettingsGroup"), Constraints.LAST);
        super.addGroupByActions(result2);
    }

    private final boolean shouldUpdateStructure(JupyterSettings before, JupyterSettings after) {
        return before.getShowPythonCellsInStructureMode() != after.getShowPythonCellsInStructureMode() || before.getShowHeadingNumbersInStructureMode() != after.getShowHeadingNumbersInStructureMode();
    }

    @Nullable
    public final List<JupyterStructureViewCellElement> getElementsByInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.getTreeModel().getComponentsByInterval(interval);
    }

    protected void installTreePopupHandlers() {
        CustomizationUtil.installPopupHandler((JComponent)this.getTree(), (String)"JupyterStructureViewPopupMenu", (String)"StructureViewPopup");
    }

    public void rebuild() {
        block2: {
            TreeState treeState;
            Object object = this.getTree().getModel().getRoot();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                treeState = TreeState.createOn((JTree)this.getTree(), (TreePath)new TreePath(it));
            } else {
                treeState = null;
            }
            TreeState treeState2 = treeState;
            super.rebuild();
            TreeState treeState3 = treeState2;
            if (treeState3 == null) break block2;
            treeState3.applyTo(this.getTree());
        }
    }

    private static final void _init_$lambda$0(JupyterStructureViewComponent this$0, JupyterSettings before, JupyterSettings after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        if (this$0.shouldUpdateStructure(before, after)) {
            this$0.rebuild();
        }
    }
}

