/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.model;

import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewComponent;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.JupyterCellSelectionNotifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager;", "Lcom/intellij/notebooks/visualization/ui/JupyterCellSelectionNotifier;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "structureView", "Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewComponent;)V", "navigateInProgress", "", "withNavigationFlag", "", "block", "Lkotlin/Function0;", "cellSelected", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.jupyter.core"})
public final class JupyterStructureViewSelectionManager
implements JupyterCellSelectionNotifier,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterStructureViewComponent structureView;
    private boolean navigateInProgress;
    @NotNull
    private static final Key<JupyterStructureViewSelectionManager> KEY;

    public JupyterStructureViewSelectionManager(@NotNull Project project, @NotNull JupyterStructureViewComponent structureView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)structureView), (String)"structureView");
        this.structureView = structureView;
        project.getMessageBus().connect((Disposable)this).subscribe(JupyterCellSelectionNotifier.Companion.getTOPIC(), (Object)this);
        Disposer.register((Disposable)((Disposable)this.structureView), (Disposable)((Disposable)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withNavigationFlag(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.navigateInProgress = true;
        try {
            block.invoke();
        }
        finally {
            this.navigateInProgress = false;
        }
    }

    public void cellSelected(@NotNull NotebookCellLines.Interval interval, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.navigateInProgress) {
            return;
        }
        List<JupyterStructureViewCellElement> list = this.structureView.getElementsByInterval(interval);
        if (list == null) {
            return;
        }
        List<JupyterStructureViewCellElement> structureElements = list;
        JupyterStructureViewCellElement jupyterStructureViewCellElement = (JupyterStructureViewCellElement)CollectionsKt.firstOrNull(structureElements);
        if (jupyterStructureViewCellElement == null) {
            return;
        }
        JupyterStructureViewCellElement firstRelevant = jupyterStructureViewCellElement;
        this.structureView.select(firstRelevant, false);
    }

    static {
        Key key = Key.create((String)"JUPYTER_STRUCTURE_VIEW_SELECTION_MANAGER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewSelectionManager;", "get", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "install", "", "manager", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final JupyterStructureViewSelectionManager get(@NotNull JupyterFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            return (JupyterStructureViewSelectionManager)psiFile.getUserData(KEY);
        }

        public final void install(@NotNull JupyterFile psiFile, @NotNull JupyterStructureViewSelectionManager manager) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            psiFile.putUserData(KEY, (Object)manager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

