/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.intmultimaps;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Int2IntMultimap {
    public static final int NO_VALUE = 0;
    public static final float DEFAULT_LOAD_FACTOR = 0.4f;
    public static final int MIN_CAPACITY = 16;
    private final float loadFactor;
    private int @NotNull [] table;
    private int aliveValues = 0;
    private int filledSlots = 0;

    public Int2IntMultimap() {
        this(16, 0.4f);
    }

    public Int2IntMultimap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new int[capacity * 2];
        Arrays.fill(this.table, 0);
    }

    public boolean lookup(int key, IntPredicate valuesProcessor) {
        Int2IntMultimap.checkNotNoValue("key", key);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key) {
                assert (slotValue != 0) : "value(table[" + (slotIndex * 2 + 1) + "]) = 0 (NO_VALUE), while key(table[" + slotIndex * 2 + "]) = " + key;
                if (valuesProcessor.test(slotValue)) continue;
                return false;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return true;
    }

    public boolean has(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return true;
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        return false;
    }

    public boolean put(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        int firstTombstoneIndex = -1;
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                return false;
            }
            if (slotKey != 0) continue;
            if (slotValue != 0) {
                if (firstTombstoneIndex != -1) continue;
                firstTombstoneIndex = slotIndex;
                continue;
            }
            int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
            this.table[insertionIndex * 2] = key;
            this.table[insertionIndex * 2 + 1] = value;
            ++this.aliveValues;
            ++this.filledSlots;
            this.rehashIfNeeded();
            return true;
        }
        if (this.aliveValues == 0) {
            Arrays.fill(this.table, 0);
            this.filledSlots = 0;
            this.put(key, value);
        }
        if (firstTombstoneIndex != -1) {
            this.table[firstTombstoneIndex * 2] = key;
            this.table[firstTombstoneIndex * 2 + 1] = value;
            ++this.aliveValues;
            ++this.filledSlots;
            this.rehashIfNeeded();
        }
        throw new AssertionError((Object)("Table is full: all " + capacity + " items were traversed, but no free slot found table(" + this.table.length + "): .aliveEntries=" + this.aliveValues + ", filledEntries=" + this.filledSlots + ", " + (this.table.length <= 64 ? Arrays.toString(this.table) : "")));
    }

    public boolean remove(int key, int value) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("value", value);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key && slotValue == value) {
                this.table[slotIndex * 2] = 0;
                --this.aliveValues;
                this.rehashIfNeeded();
                return true;
            }
            if (slotKey != 0 || slotValue != 0) continue;
            return false;
        }
        return false;
    }

    public boolean forEach(@NotNull KeyValueProcessor processor) {
        if (processor == null) {
            Int2IntMultimap.$$$reportNull$$$0(0);
        }
        for (int i = 0; i < this.table.length; i += 2) {
            int key = this.table[i];
            int value = this.table[i + 1];
            if (key == 0) continue;
            assert (value != 0) : "value(table[" + (i + 1) + "]) = 0, while key(table[" + i + "]) = " + key;
            if (processor.process(key, value)) continue;
            return false;
        }
        return true;
    }

    public int sizeInBytes() {
        return this.table.length * 4;
    }

    public int capacity() {
        return this.table.length / 2;
    }

    public int size() {
        return this.aliveValues;
    }

    public boolean replace(int key, int oldValue, int newValue) {
        Int2IntMultimap.checkNotNoValue("key", key);
        Int2IntMultimap.checkNotNoValue("oldValue", oldValue);
        Int2IntMultimap.checkNotNoValue("newValue", newValue);
        int capacity = this.capacity();
        int startIndex = Math.abs(key % capacity);
        int oldValueSlotIndex = -1;
        int newValueSlotIndex = -1;
        for (int probe = 0; probe < capacity; ++probe) {
            int slotIndex = (startIndex + probe) % capacity;
            int slotKey = this.table[slotIndex * 2];
            int slotValue = this.table[slotIndex * 2 + 1];
            if (slotKey == key) {
                if (slotValue == oldValue) {
                    oldValueSlotIndex = slotIndex;
                } else if (slotValue == newValue) {
                    newValueSlotIndex = slotIndex;
                }
            }
            if (slotKey == 0 && slotValue == 0) break;
        }
        if (oldValueSlotIndex != -1) {
            if (newValueSlotIndex != -1) {
                this.table[oldValueSlotIndex * 2] = 0;
                --this.aliveValues;
                this.rehashIfNeeded();
            } else {
                this.table[oldValueSlotIndex * 2 + 1] = newValue;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.aliveValues = 0;
        this.filledSlots = 0;
        int[] newTable = new int[32];
        Arrays.fill(newTable, 0);
        this.table = newTable;
    }

    private void rehashIfNeeded() {
        if ((float)this.filledSlots > (float)this.capacity() * this.loadFactor) {
            int newCapacity = this.estimateOptimalCapacity(this.aliveValues);
            Int2IntMultimap newMap = new Int2IntMultimap(newCapacity, this.loadFactor);
            this.forEach((_key, _value) -> {
                newMap.put(_key, _value);
                return true;
            });
            this.table = newMap.table;
            this.aliveValues = newMap.aliveValues;
            this.filledSlots = newMap.filledSlots;
        }
    }

    private int estimateOptimalCapacity(int aliveValuesToFit) {
        int requiredCapacity = (int)((float)aliveValuesToFit / this.loadFactor + 1.0f);
        int currentCapacity = this.capacity();
        if (requiredCapacity > currentCapacity) {
            return currentCapacity * 2;
        }
        if (requiredCapacity > currentCapacity / 2) {
            return currentCapacity;
        }
        return Math.max(requiredCapacity, 16);
    }

    private static void checkNotNoValue(String paramName, int value) {
        if (value == 0) {
            throw new IllegalArgumentException(paramName + " can't be = 0 -- it is special value used as NO_VALUE");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/platform/util/io/storages/intmultimaps/Int2IntMultimap", "forEach"));
    }

    @FunctionalInterface
    public static interface KeyValueProcessor {
        public boolean process(int var1, int var2);
    }
}

