/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.commit.DvcsCommitModeProvider;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.CommitMode;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkEvent;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgDisposable;
import org.zmlx.hg4idea.HgExecutableManager;
import org.zmlx.hg4idea.HgExecutableValidator;
import org.zmlx.hg4idea.HgProjectConfigurable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVFSListener;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.provider.HgCommittedChangesProvider;
import org.zmlx.hg4idea.provider.HgDiffProvider;
import org.zmlx.hg4idea.provider.HgHistoryProvider;
import org.zmlx.hg4idea.provider.HgMergeProvider;
import org.zmlx.hg4idea.provider.HgRollbackEnvironment;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationProvider;
import org.zmlx.hg4idea.provider.commit.HgCheckinEnvironment;
import org.zmlx.hg4idea.provider.commit.HgCommitAndPushExecutor;
import org.zmlx.hg4idea.provider.commit.HgMQNewExecutor;
import org.zmlx.hg4idea.provider.update.HgUpdateEnvironment;
import org.zmlx.hg4idea.roots.HgIntegrationEnabler;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public final class HgVcs
extends AbstractVcs {
    @Topic.ProjectLevel
    public static final Topic<HgUpdater> REMOTE_TOPIC = new Topic("hg4idea.remote", HgUpdater.class);
    @Topic.ProjectLevel
    public static final Topic<HgUpdater> STATUS_TOPIC = new Topic("hg4idea.status", HgUpdater.class);
    @Topic.ProjectLevel
    public static final Topic<HgWidgetUpdater> INCOMING_OUTGOING_CHECK_TOPIC = new Topic("hg4idea.incomingcheck", HgWidgetUpdater.class);
    private static final Logger LOG = Logger.getInstance(HgVcs.class);
    @NonNls
    public static final String VCS_NAME = "hg4idea";
    public static final Supplier<@Nls String> DISPLAY_NAME = HgBundle.messagePointer("hg4idea.vcs.name", new Object[0]);
    public static final Supplier<@Nls String> SHORT_DISPLAY_NAME = HgBundle.messagePointer("hg4idea.vcs.short.name", new Object[0]);
    private static final VcsKey ourKey = HgVcs.createKey((String)"hg4idea");
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    @NonNls
    private static final String ORIG_FILE_PATTERN = "*.orig";
    @Nullable
    @NonNls
    public static final String HGENCODING = System.getenv("HGENCODING");
    private final HgChangeProvider changeProvider;
    private final HgRollbackEnvironment rollbackEnvironment;
    private final HgDiffProvider diffProvider;
    private final HgHistoryProvider historyProvider;
    private final HgCheckinEnvironment checkinEnvironment;
    private final HgAnnotationProvider annotationProvider;
    private final HgUpdateEnvironment updateEnvironment;
    private final HgCommittedChangesProvider committedChangesProvider;
    private final AtomicReference<CoroutineScope> myActiveScope;
    private final HgMergeProvider myMergeProvider;
    private HgExecutableValidator myExecutableValidator;
    private final Object myExecutableValidatorLock;
    private File myPromptHooksExtensionFile;
    private final CommitExecutor myCommitAndPushExecutor;
    private final CommitExecutor myMqNewExecutor;
    private HgRemoteStatusUpdater myHgRemoteStatusUpdater;
    @NotNull
    private HgVersion myVersion;

    public HgVcs(@NotNull Project project) {
        if (project == null) {
            HgVcs.$$$reportNull$$$0(0);
        }
        super(project, VCS_NAME);
        this.myActiveScope = new AtomicReference();
        this.myExecutableValidatorLock = new Object();
        this.myVersion = HgVersion.NULL;
        this.changeProvider = new HgChangeProvider(project, this.getKeyInstanceMethod());
        this.rollbackEnvironment = new HgRollbackEnvironment(project);
        this.diffProvider = new HgDiffProvider(project);
        this.historyProvider = new HgHistoryProvider(project);
        this.checkinEnvironment = new HgCheckinEnvironment(this);
        this.annotationProvider = new HgAnnotationProvider(project);
        this.updateEnvironment = new HgUpdateEnvironment(project);
        this.committedChangesProvider = new HgCommittedChangesProvider(project, this);
        this.myMergeProvider = new HgMergeProvider(this.myProject);
        this.myCommitAndPushExecutor = new HgCommitAndPushExecutor();
        this.myMqNewExecutor = new HgMQNewExecutor();
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME.get();
        if (string == null) {
            HgVcs.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = SHORT_DISPLAY_NAME.get();
        if (string == null) {
            HgVcs.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        String string = HgBundle.message("hg4idea.vcs.short.name.with.mnemonic", new Object[0]);
        if (string == null) {
            HgVcs.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public HgProjectSettings getProjectSettings() {
        HgProjectSettings hgProjectSettings = HgProjectSettings.getInstance(this.myProject);
        if (hgProjectSettings == null) {
            HgVcs.$$$reportNull$$$0(4);
        }
        return hgProjectSettings;
    }

    public ChangeProvider getChangeProvider() {
        return this.changeProvider;
    }

    @Nullable
    public RollbackEnvironment createRollbackEnvironment() {
        return this.rollbackEnvironment;
    }

    public DiffProvider getDiffProvider() {
        return this.diffProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return this.historyProvider;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.checkinEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public MergeProvider getMergeProvider() {
        return this.myMergeProvider;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.updateEnvironment;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{HgChangeProvider.FileStatuses.COPIED, HgChangeProvider.FileStatuses.RENAMED};
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.committedChangesProvider;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return HgUtil.getNearestHgRoot(dir) != null;
    }

    @NotNull
    public File getPromptHooksExtensionFile() {
        if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
            this.myPromptHooksExtensionFile = HgUtil.getTemporaryPythonFile("prompthooks");
            if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
                LOG.error("prompthooks.py Mercurial extension is not found. Please reinstall " + ApplicationNamesInfo.getInstance().getProductName());
            }
        }
        File file = this.myPromptHooksExtensionFile;
        if (file == null) {
            HgVcs.$$$reportNull$$$0(5);
        }
        return file;
    }

    public void activate() {
        CoroutineScope globalScope = HgDisposable.getCoroutineScope(this.myProject);
        CoroutineScope activeScope = CoroutineScopeKt.childScope((CoroutineScope)globalScope, (String)"HgVcs", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true);
        Disposable disposable = Disposer.newDisposable();
        AppJavaExecutorUtil.awaitCancellationAndDispose((CoroutineScope)activeScope, (Disposable)disposable);
        CoroutineScope oldScope = this.myActiveScope.getAndSet(activeScope);
        if (oldScope != null) {
            kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)oldScope, null);
        }
        this.checkExecutableAndVersion();
        HgRemoteStatusUpdater remoteStatusUpdater = new HgRemoteStatusUpdater(this);
        Disposer.register((Disposable)disposable, (Disposable)remoteStatusUpdater);
        this.myHgRemoteStatusUpdater = remoteStatusUpdater;
        HgVFSListener VFSListener = HgVFSListener.createInstance(this, activeScope);
        Disposer.register((Disposable)disposable, (Disposable)VFSListener);
        String ignoredPattern = FileTypeManager.getInstance().getIgnoredFilesList();
        if (!ignoredPattern.contains(ORIG_FILE_PATTERN)) {
            String newPattern = ignoredPattern + (ignoredPattern.endsWith(";") ? "" : ";") + ORIG_FILE_PATTERN;
            HgUtil.runWriteActionLater(() -> FileTypeManager.getInstance().setIgnoredFilesList(newPattern));
        }
    }

    private void checkExecutableAndVersion() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            this.checkVersion();
        }
    }

    public void deactivate() {
        CoroutineScope oldScope = this.myActiveScope.getAndSet(null);
        if (oldScope != null) {
            kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)oldScope, null);
        }
    }

    @Nullable
    public static HgVcs getInstance(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return (HgVcs)vcsManager.findVcsByName(VCS_NAME);
    }

    public void showMessageInConsole(@NotNull @Nls String message, @NotNull ConsoleViewContentType contentType) {
        if (message == null) {
            HgVcs.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            HgVcs.$$$reportNull$$$0(7);
        }
        if (message.length() > 10000) {
            message = message.substring(0, 10000);
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).addMessageToConsoleWindow(message, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgExecutableValidator getExecutableValidator() {
        Object object = this.myExecutableValidatorLock;
        synchronized (object) {
            if (this.myExecutableValidator == null) {
                this.myExecutableValidator = new HgExecutableValidator(this.myProject);
            }
            return this.myExecutableValidator;
        }
    }

    public List<CommitExecutor> getCommitExecutors() {
        if (ContainerUtil.exists(HgUtil.getRepositoryManager(this.myProject).getRepositories(), r -> r.getRepositoryConfig().isMqUsed())) {
            return List.of(this.myCommitAndPushExecutor, this.myMqNewExecutor);
        }
        return List.of(this.myCommitAndPushExecutor);
    }

    @Nullable
    public HgRemoteStatusUpdater getRemoteStatusUpdater() {
        return this.myHgRemoteStatusUpdater;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    @Nullable
    public CommitMode getForcedCommitMode(@NotNull CommitMode originalMode) {
        if (originalMode == null) {
            HgVcs.$$$reportNull$$$0(8);
        }
        return DvcsCommitModeProvider.compute();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void enableIntegration(@Nullable VirtualFile virtualFile) {
        void targetDirectory;
        ThreadingAssertions.assertEventDispatchThread();
        new Task.Backgroundable(this.myProject, HgBundle.message("progress.title.enabling.hg", new Object[0]), true, (VirtualFile)targetDirectory){
            final /* synthetic */ VirtualFile val$targetDirectory;
            {
                this.val$targetDirectory = virtualFile;
                super(arg0, arg1, arg2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                new HgIntegrationEnabler(HgVcs.this, this.val$targetDirectory).detectAndEnable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/HgVcs$1", "run"));
            }
        }.queue();
    }

    public void checkVersion() {
        block5: {
            String executable = HgExecutableManager.getInstance().getHgExecutable(this.myProject);
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
            String SETTINGS_LINK = "settings";
            String UPDATE_LINK = "update";
            NotificationListener.Adapter linkAdapter = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ("settings".equals(e.getDescription())) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(HgVcs.this.myProject, HgProjectConfigurable.class);
                    } else if ("update".equals(e.getDescription())) {
                        BrowserUtil.browse((String)"http://mercurial.selenic.com");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/zmlx/hg4idea/HgVcs$2";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            try {
                this.myVersion = HgVersion.identifyVersion(this.myProject, executable);
                if (!this.myVersion.isSupported()) {
                    LOG.info("Unsupported Hg version: " + String.valueOf(this.myVersion));
                    String message = HgBundle.message("hg4idea.version.update", "settings", this.myVersion, HgVersion.MIN, "update");
                    vcsNotifier.notifyError("hg.unsupported.version", HgBundle.message("hg4idea.version.unsupported", new Object[0]), message, (NotificationListener)linkAdapter);
                } else if (this.myVersion.hasUnsupportedExtensions()) {
                    String unsupportedExtensionsAsString = this.myVersion.getUnsupportedExtensions().toString();
                    LOG.warn("Unsupported Hg extensions: " + unsupportedExtensionsAsString);
                    String message = HgBundle.message("hg4idea.version.unsupported.ext", unsupportedExtensionsAsString);
                    vcsNotifier.notifyWarning("hg.unsupported.extensions", HgBundle.message("hg4idea.version.unsupported", new Object[0]), message);
                }
            }
            catch (Exception e) {
                if (!this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block5;
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                String message = HgBundle.message("hg4idea.unable.to.run.hg", executable);
                vcsNotifier.notifyError("hg.unable.to.run.executable", message, HgBundle.message("hg4idea.exec.not.found", reason, "settings"), (NotificationListener)linkAdapter);
            }
        }
    }

    @NotNull
    public HgVersion getVersion() {
        HgVersion hgVersion = this.myVersion;
        if (hgVersion == null) {
            HgVcs.$$$reportNull$$$0(9);
        }
        return hgVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgVcs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameWithMnemonic";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromptHooksExtensionFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showMessageInConsole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getForcedCommitMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }
}

