"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResolvedSignatureTsServer = exports.areTypesMutuallyAssignableTsServer = exports.getTypePropertyTsServer = exports.getTypePropertiesTsServer = exports.getTypeTextTsServer = exports.getSymbolTypeTsServer = exports.getElementTypeTsServer = exports.getCompletionSymbolsTsServer = exports.decorateLanguageService = void 0;
const ide_get_element_type_1 = require("./ide-get-element-type");
const utils_1 = require("./utils");
const decoratedLanguageServices = new WeakSet();
function decorateLanguageService(languageService) {
    if (decoratedLanguageServices.has(languageService)) {
        return;
    }
    decoratedLanguageServices.add(languageService);
    languageService.webStormGetCompletionSymbols = (options) => {
        const { ts, ls, fileName, position, cancellationToken, reverseMapper } = options;
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getCompletionSymbols)({
            ls,
            ts,
            program,
            sourceFileName: sourceFile.fileName,
            position,
            cancellationToken,
            reverseMapper
        });
    };
    languageService.webStormGetElementType = (options) => {
        const { fileName } = options;
        // see getQuickInfoAtPosition
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getElementTypeByOffsets)(Object.assign(Object.assign({}, options), { ideProjectId: languageService.ideProjectId, program,
            sourceFile }));
    };
    languageService.webStormGetSymbolType = (options) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getSymbolType)(Object.assign(Object.assign({}, options), { program }));
    };
    languageService.webStormGetTypeText = (options) => {
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeText)(Object.assign(Object.assign({}, options), { program }));
    };
    languageService.webStormGetTypeProperties = (options) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperties)(Object.assign(Object.assign({}, options), { program }));
    };
    languageService.webStormGetTypeProperty = (options) => {
        let program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.getTypeProperty)(Object.assign(Object.assign({}, options), { program }));
    };
    languageService.webStormAreTypesMutuallyAssignable = (options) => {
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        return (0, ide_get_element_type_1.areTypesMutuallyAssignable)(Object.assign(Object.assign({}, options), { program }));
    };
    languageService.webStormGetResolvedSignature = (options) => {
        const { ts, fileName, startOffset, endOffset, cancellationToken, reverseMapper } = options;
        const program = languageService.getProgram();
        if (!program) {
            return undefined;
        }
        const sourceFile = program.getSourceFile(fileName);
        if (!sourceFile) {
            return undefined;
        }
        // Convert offsets to Range
        const start = ts.getLineAndCharacterOfPosition(sourceFile, startOffset);
        const end = ts.getLineAndCharacterOfPosition(sourceFile, endOffset);
        const range = { start, end };
        return (0, ide_get_element_type_1.getResolvedSignature)({
            ts,
            ideProjectId: languageService.ideProjectId,
            program,
            sourceFile,
            range,
            cancellationToken,
            reverseMapper,
        });
    };
}
exports.decorateLanguageService = decorateLanguageService;
function getCompletionSymbolsTsServer(ts, projectService, requestArguments) {
    let fileName = ts.server.toNormalizedPath(requestArguments.file);
    let { project, sourceFile } = projectService.ideProjectService.getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    let { line, character } = requestArguments.position;
    let position = ts.getPositionOfLineAndCharacter(sourceFile, line, character);
    let languageService = project.getLanguageService();
    return languageService.webStormGetCompletionSymbols({
        ts,
        ls: languageService,
        fileName,
        position,
        cancellationToken: projectService.cancellationToken
    });
}
exports.getCompletionSymbolsTsServer = getCompletionSymbolsTsServer;
function getElementTypeTsServer(ts, projectService, requestArguments) {
    const fileName = ts.server.toNormalizedPath(requestArguments.file);
    const { project, sourceFile } = projectService.ideProjectService
        .getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    const range = requestArguments.range;
    const startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    const endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetElementType({
        ts,
        fileName,
        startOffset,
        endOffset,
        typeRequestKind: requestArguments.typeRequestKind,
        forceReturnType: requestArguments.forceReturnType,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.getElementTypeTsServer = getElementTypeTsServer;
function getSymbolTypeTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetSymbolType({
        ts,
        symbolId: requestArguments.symbolId,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.getSymbolTypeTsServer = getSymbolTypeTsServer;
function getTypeTextTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService)
        return undefined;
    return languageService.webStormGetTypeText({
        ts,
        typeId: requestArguments.typeId,
        symbolId: requestArguments.symbolId,
        cancellationToken: projectService.cancellationToken,
        flags: requestArguments.flags,
    });
}
exports.getTypeTextTsServer = getTypeTextTsServer;
function getTypePropertiesTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperties({
        ts,
        typeId: requestArguments.typeId,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.getTypePropertiesTsServer = getTypePropertiesTsServer;
function getTypePropertyTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormGetTypeProperty({
        ts,
        typeId: requestArguments.typeId,
        propertyName: requestArguments.propertyName,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.getTypePropertyTsServer = getTypePropertyTsServer;
function areTypesMutuallyAssignableTsServer(ts, projectService, requestArguments) {
    const languageService = findLanguageService(projectService, requestArguments.ideProjectId, requestArguments.ideTypeCheckerId);
    if (!languageService) {
        return undefined;
    }
    return languageService.webStormAreTypesMutuallyAssignable({
        ts,
        type1Id: requestArguments.type1Id,
        type2Id: requestArguments.type2Id,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.areTypesMutuallyAssignableTsServer = areTypesMutuallyAssignableTsServer;
function getResolvedSignatureTsServer(ts, projectService, requestArguments) {
    let fileName = ts.server.toNormalizedPath(requestArguments.file);
    let { project, sourceFile } = projectService.ideProjectService
        .getProjectAndSourceFile(requestArguments.file, requestArguments.projectFileName);
    if (!project || !sourceFile)
        return undefined;
    let range = requestArguments.range;
    let startOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    let endOffset = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    return project.getLanguageService().webStormGetResolvedSignature({
        ts, fileName, startOffset, endOffset,
        cancellationToken: projectService.cancellationToken,
    });
}
exports.getResolvedSignatureTsServer = getResolvedSignatureTsServer;
function findLanguageService(projectService, ideProjectId, ideTypeCheckerId) {
    for (let [, project] of projectService.configuredProjects) {
        if (project.ideProjectId === ideProjectId) {
            return getLanguageService(project);
        }
    }
    for (let inferredProject of projectService.inferredProjects) {
        if (inferredProject.ideProjectId === ideProjectId) {
            return getLanguageService(inferredProject);
        }
    }
    for (let externalProject of projectService.externalProjects) {
        if (externalProject.ideProjectId === ideProjectId) {
            return getLanguageService(externalProject);
        }
    }
    function getLanguageService(project) {
        var _a, _b;
        let program = project.getLanguageService().getProgram();
        if (((_b = (_a = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _a === void 0 ? void 0 : _a.webStormCacheInfo) === null || _b === void 0 ? void 0 : _b.ideTypeCheckerId) == ideTypeCheckerId) {
            return project.getLanguageService();
        }
        (0, utils_1.throwIdeError)("OutdatedTypeCheckerIdException");
    }
    console.error(`findLanguageService - failed to find language service for ideProjectId ${ideProjectId}`);
}
//# sourceMappingURL=get-element-type-ts-server.js.map