/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.ByteBufferOutput;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J*\u0010\u0013\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/impl/KryoOutput;", "Lcom/esotericsoftware/kryo/kryo5/io/ByteBufferOutput;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "fileChannel", "Ljava/nio/channels/FileChannel;", "writeInt", "", "value", "", "writeLong", "", "writeInts", "array", "", "offset", "count", "writeLongs", "", "optimizePositive", "", "flush", "close", "intellij.platform.workspace.storage"})
public final class KryoOutput
extends ByteBufferOutput {
    @NotNull
    private final FileChannel fileChannel;

    public KryoOutput(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(524288, Integer.MAX_VALUE);
        FileChannel fileChannel = FileChannel.open(file, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.WRITE), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(...)");
        this.fileChannel = fileChannel;
        this.setVariableLengthEncoding(false);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void writeInt(int value) {
        this.require(4);
        this.byteBuffer.putInt(value);
        this.position += 4;
    }

    public void writeLong(long value) {
        this.require(8);
        this.byteBuffer.putLong(value);
        this.position += 8;
    }

    public void writeInts(@NotNull int[] array, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (count == 0) {
            return;
        }
        int required = count << 2;
        this.require(required);
        this.byteBuffer.asIntBuffer().put(array, offset, count);
        this.byteBuffer.position(this.byteBuffer.position() + required);
        this.position = this.byteBuffer.position();
    }

    public void writeLongs(@Nullable long[] array, int offset, int count, boolean optimizePositive) {
        if (count == 0) {
            return;
        }
        int required = count << 3;
        this.require(required);
        this.byteBuffer.asLongBuffer().put(array, offset, count);
        this.byteBuffer.position(this.byteBuffer.position() + required);
        this.position = this.byteBuffer.position();
    }

    public void flush() {
        long filePosition = this.total;
        try {
            this.byteBuffer.flip();
            while (this.byteBuffer.hasRemaining()) {
                filePosition += (long)this.fileChannel.write(this.byteBuffer, filePosition);
            }
            this.byteBuffer.clear();
        }
        catch (IOException e) {
            throw new KryoException((Throwable)e);
        }
        this.total = filePosition;
        this.position = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Closeable closeable = this.fileChannel;
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)closeable;
            boolean bl = false;
            super.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

