/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.platform.vcs.impl.shared.commit.EditedCommitPresentation;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.vcs.changes.viewModel.ChangesViewProxy;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0003J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0014J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewWorkflowManagerImpl;", "Lcom/intellij/openapi/vcs/changes/ChangesViewWorkflowManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "allowExcludeFromCommit", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getAllowExcludeFromCommit", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "editedCommit", "Lcom/intellij/platform/vcs/impl/shared/commit/EditedCommitPresentation;", "getEditedCommit", "_commitWorkflowHandler", "Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowHandler;", "isInitialized", "updateCommitWorkflowHandler", "", "setCommitWorkflowHandler", "handler", "dispose", "doGetCommitWorkflowHandler", "setEditedCommit", "intellij.platform.vcs.impl"})
public final class ChangesViewWorkflowManagerImpl
extends ChangesViewWorkflowManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<Boolean> allowExcludeFromCommit;
    @NotNull
    private final MutableStateFlow<EditedCommitPresentation> editedCommit;
    @Nullable
    private ChangesViewCommitWorkflowHandler _commitWorkflowHandler;
    private boolean isInitialized;

    public ChangesViewWorkflowManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.allowExcludeFromCommit = StateFlowKt.MutableStateFlow((Object)false);
        this.editedCommit = StateFlowKt.MutableStateFlow(null);
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
        CommitModeManager.Companion.subscribeOnCommitModeChange((SimpleMessageBusConnection)busConnection, new CommitModeManager.CommitModeListener(){

            @Override
            public void commitModeChanged() {
                this.updateCommitWorkflowHandler();
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> ChangesViewWorkflowManagerImpl._init_$lambda$0(this), ModalityState.nonModal(), this.project.getDisposed());
    }

    @NotNull
    public MutableStateFlow<Boolean> getAllowExcludeFromCommit() {
        return this.allowExcludeFromCommit;
    }

    @NotNull
    public MutableStateFlow<EditedCommitPresentation> getEditedCommit() {
        return this.editedCommit;
    }

    @RequiresEdt
    private final void updateCommitWorkflowHandler() {
        this.isInitialized = true;
        boolean isNonModal = CommitModeManager.Companion.getInstance(this.project).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode;
        ChangesViewCommitWorkflowHandler currentHandler = this._commitWorkflowHandler;
        if (isNonModal) {
            if (currentHandler == null) {
                Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewWorkflowManager initialization");
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
                Activity activity2 = activity;
                ChangesViewCommitWorkflow workflow = new ChangesViewCommitWorkflow(this.project);
                ChangesViewProxy changesView = ChangesViewManager.Companion.getInstanceEx(this.project).getOrCreateCommitChangesView();
                ChangesViewCommitPanel commitPanel = new ChangesViewCommitPanel(this.project, changesView);
                this.setCommitWorkflowHandler(new ChangesViewCommitWorkflowHandler(workflow, commitPanel));
                activity2.end();
            } else {
                currentHandler.resetActivation();
            }
        } else if (currentHandler != null) {
            Disposer.dispose((Disposable)currentHandler);
            this.setCommitWorkflowHandler(null);
        }
    }

    private final void setCommitWorkflowHandler(ChangesViewCommitWorkflowHandler handler) {
        this._commitWorkflowHandler = handler;
        if (handler != null) {
            handler.addActivityListener(new ChangesViewCommitWorkflowHandler.ActivityListener(this, handler){
                final /* synthetic */ ChangesViewWorkflowManagerImpl this$0;
                final /* synthetic */ ChangesViewCommitWorkflowHandler $handler;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                }

                public void activityStateChanged() {
                    this.this$0.getAllowExcludeFromCommit().setValue((Object)this.$handler.isActive());
                }
            });
            this.getAllowExcludeFromCommit().setValue((Object)handler.isActive());
        } else {
            this.getAllowExcludeFromCommit().setValue((Object)false);
        }
        this.setEditedCommit(null);
        ((ChangesViewWorkflowManager.ChangesViewWorkflowListener)this.project.getMessageBus().syncPublisher(ChangesViewWorkflowManager.TOPIC)).commitWorkflowChanged();
    }

    public void dispose() {
        ChangesViewCommitWorkflowHandler handler = this._commitWorkflowHandler;
        if (handler != null) {
            Disposer.dispose((Disposable)handler);
            this._commitWorkflowHandler = null;
        }
    }

    @Override
    @Nullable
    protected ChangesViewCommitWorkflowHandler doGetCommitWorkflowHandler() {
        if (ApplicationManager.getApplication().isDispatchThread() && !this.isInitialized) {
            this.updateCommitWorkflowHandler();
        }
        return this._commitWorkflowHandler;
    }

    @Override
    public void setEditedCommit(@Nullable EditedCommitPresentation editedCommit) {
        this.getEditedCommit().setValue((Object)editedCommit);
    }

    private static final void _init_$lambda$0(ChangesViewWorkflowManagerImpl this$0) {
        this$0.updateCommitWorkflowHandler();
    }
}

