/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.platform.split.connection.network.DatagramSocketWrapperKt;
import com.intellij.platform.split.connection.network.IDatagramSocketWrapper;
import com.intellij.platform.split.connection.network.TurnPacketEvent;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.rd.platform.codeWithMe.util.ThreadUtil;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.RdDefaultErrorLoggerHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.Signal;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J,\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J0\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00122\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0017J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\r\u001a;\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0010*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u00110\u000e\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0015\u001aG\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00160\u0016\u00120\u0012.\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0010*\u0016\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00170\u00170\u000e\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/platform/split/connection/network/DatagramSocketWrapper;", "Lcom/intellij/platform/split/connection/network/IDatagramSocketWrapper;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "socket", "Ljava/net/DatagramSocket;", "remainingPacketsEvent", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/intellij/platform/split/connection/network/TurnPacketEvent;", "mappedEvents", "Lcom/intellij/util/containers/MultiMap;", "Ljava/net/InetSocketAddress;", "kotlin.jvm.PlatformType", "Lkotlin/Function1;", "", "", "Lorg/jetbrains/annotations/NotNull;", "prefixedEvents", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "Lkotlin/Function2;", "localAddress", "getLocalAddress", "()Ljava/net/InetSocketAddress;", "adviseOnRemainingPackets", "adviseLifetime", "handler", "adviseOnSpecificAddressPackets", "address", "adviseOnSpecificContentPrefix", "prefix", "send", "buffer", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nDatagramSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatagramSocketWrapper.kt\ncom/intellij/platform/split/connection/network/DatagramSocketWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,159:1\n1#2:160\n67#3,4:161\n60#3,5:165\n60#3,5:170\n60#3,5:175\n60#3,5:180\n67#3,4:185\n135#4:189\n117#4,7:190\n136#4:197\n135#4:198\n117#4,7:199\n136#4:206\n127#4,6:207\n*S KotlinDebug\n*F\n+ 1 DatagramSocketWrapper.kt\ncom/intellij/platform/split/connection/network/DatagramSocketWrapper\n*L\n60#1:161,4\n68#1:165,5\n84#1:170,5\n89#1:175,5\n94#1:180,5\n104#1:185,4\n114#1:189\n114#1:190,7\n114#1:197\n127#1:198\n127#1:199,7\n127#1:206\n149#1:207,6\n*E\n"})
public final class DatagramSocketWrapper
implements IDatagramSocketWrapper {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final DatagramSocket socket;
    @NotNull
    private final Signal<TurnPacketEvent> remainingPacketsEvent;
    @NotNull
    private final MultiMap<InetSocketAddress, Function1<byte[], Unit>> mappedEvents;
    @NotNull
    private final MultiMap<ByteArraySequence, Function2<InetSocketAddress, byte[], Unit>> prefixedEvents;

    /*
     * WARNING - void declaration
     */
    public DatagramSocketWrapper(@NotNull Lifetime lifetime) {
        void it;
        DatagramSocket datagramSocket;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        DatagramSocket datagramSocket2 = datagramSocket = new DatagramSocket();
        DatagramSocketWrapper datagramSocketWrapper = this;
        boolean bl = false;
        it.setReuseAddress(true);
        datagramSocketWrapper.socket = datagramSocket;
        this.remainingPacketsEvent = new Signal();
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.mappedEvents = multiMap;
        MultiMap multiMap2 = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"createConcurrent(...)");
        this.prefixedEvents = multiMap2;
        String threadName = "UDP receive on " + this.socket.getLocalSocketAddress();
        Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)threadName, (int)0, () -> DatagramSocketWrapper._init_$lambda$0(this, threadName), (int)21, null);
        this.lifetime.onTermination(() -> DatagramSocketWrapper._init_$lambda$1(this, thread));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
    }

    @Override
    public void adviseOnRemainingPackets(@NotNull Lifetime adviseLifetime, @NotNull Function2<? super InetSocketAddress, ? super byte[], Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.remainingPacketsEvent.advise(adviseLifetime, arg_0 -> DatagramSocketWrapper.adviseOnRemainingPackets$lambda$0(handler, arg_0));
    }

    @Override
    public void adviseOnSpecificAddressPackets(@NotNull Lifetime adviseLifetime, @NotNull InetSocketAddress address, @NotNull Function1<? super byte[], Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        adviseLifetime.bracketIfAlive(() -> DatagramSocketWrapper.adviseOnSpecificAddressPackets$lambda$0(this, address, handler), () -> DatagramSocketWrapper.adviseOnSpecificAddressPackets$lambda$1(this, address, handler));
    }

    public final void adviseOnSpecificContentPrefix(@NotNull Lifetime adviseLifetime, @NotNull byte[] prefix, @NotNull Function2<? super InetSocketAddress, ? super byte[], Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)adviseLifetime, (String)"adviseLifetime");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ByteArraySequence seq = new ByteArraySequence(prefix);
        adviseLifetime.bracketIfAlive(() -> DatagramSocketWrapper.adviseOnSpecificContentPrefix$lambda$0(this, seq, handler), () -> DatagramSocketWrapper.adviseOnSpecificContentPrefix$lambda$1(this, seq, handler));
    }

    @Override
    public void send(@NotNull byte[] buffer, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        com.intellij.openapi.diagnostic.Logger $this$trace$iv = DatagramSocketWrapperKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            com.intellij.openapi.diagnostic.Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Send UDP packet to " + address + " size " + buffer.length + " bytes");
        }
        this.socket.send(new DatagramPacket(buffer, 0, buffer.length, address));
    }

    private static final Unit adviseOnRemainingPackets$lambda$0(Function2 $handler, TurnPacketEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $handler.invoke((Object)it.getAddress(), (Object)it.getData());
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificAddressPackets$lambda$0(DatagramSocketWrapper this$0, InetSocketAddress $address, Function1 $handler) {
        this$0.mappedEvents.putValue((Object)$address, (Object)$handler);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificAddressPackets$lambda$1(DatagramSocketWrapper this$0, InetSocketAddress $address, Function1 $handler) {
        this$0.mappedEvents.remove((Object)$address, (Object)$handler);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificContentPrefix$lambda$0(DatagramSocketWrapper this$0, ByteArraySequence $seq, Function2 $handler) {
        this$0.prefixedEvents.putValue((Object)$seq, (Object)$handler);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnSpecificContentPrefix$lambda$1(DatagramSocketWrapper this$0, ByteArraySequence $seq, Function2 $handler) {
        this$0.prefixedEvents.remove((Object)$seq, (Object)$handler);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$0(DatagramSocketWrapper this$0, String $threadName) {
        com.intellij.openapi.diagnostic.Logger logger;
        com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv = DatagramSocketWrapperKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Receive thread '" + $threadName + "' is operational", t$iv);
        }
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        try {
            block13: while (true) {
                Collection specificHandlers;
                byte[] packetData;
                DatagramPacket packet = new DatagramPacket(buffer.array(), 0, buffer.capacity());
                try {
                    this$0.socket.receive(packet);
                }
                catch (IOException t) {
                    Throwable t$iv2;
                    if (this$0.socket.isClosed()) {
                        com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv2 = DatagramSocketWrapperKt.access$getLOG$p();
                        t$iv2 = null;
                        boolean $i$f$debug2 = false;
                        if ($this$debug_u24default$iv2.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv2;
                            boolean bl = false;
                            logger.debug("Receive thread '" + $threadName + "': socket is closed", t$iv2);
                        }
                        break;
                    }
                    if (RLifetimeKt.isNotAlive((Lifetime)this$0.lifetime)) {
                        com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv3 = DatagramSocketWrapperKt.access$getLOG$p();
                        t$iv2 = null;
                        boolean $i$f$debug3 = false;
                        if ($this$debug_u24default$iv3.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv3;
                            boolean bl = false;
                            logger.debug("Receive thread '" + $threadName + "': lifetime is terminated", t$iv2);
                        }
                        break;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        com.intellij.openapi.diagnostic.Logger $this$debug_u24default$iv4 = DatagramSocketWrapperKt.access$getLOG$p();
                        t$iv2 = null;
                        boolean $i$f$debug4 = false;
                        if ($this$debug_u24default$iv4.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv4;
                            boolean bl = false;
                            logger.debug("Receive thread '" + $threadName + "': thread was interrupted", t$iv2);
                        }
                        break;
                    }
                    DatagramSocketWrapperKt.access$getLOG$p().warn("I/O exception receiving UDP packet: " + t.getMessage(), (Throwable)t);
                    continue;
                }
                com.intellij.openapi.diagnostic.Logger $this$trace$iv = DatagramSocketWrapperKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Received an UDP packet from " + packet.getSocketAddress() + " size " + packet.getLength() + " bytes");
                }
                Intrinsics.checkNotNullExpressionValue((Object)packet.getData(), (String)"getData(...)");
                int bl = packet.getLength();
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf($i$f$trace, bl), (String)"copyOf(...)");
                SocketAddress socketAddress = packet.getSocketAddress();
                Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                InetSocketAddress remoteAddress = (InetSocketAddress)socketAddress;
                for (Object object : this$0.prefixedEvents.entrySet()) {
                    Intrinsics.checkNotNull((Object)object);
                    ByteArraySequence prefixSeq = (ByteArraySequence)object.getKey();
                    Collection handlers = (Collection)object.getValue();
                    if (packetData.length < prefixSeq.getLength() || !Intrinsics.areEqual((Object)new ByteArraySequence(packetData, 0, prefixSeq.getLength()), (Object)prefixSeq)) continue;
                    Iterator iterator = handlers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block13;
                        Function2 handler = (Function2)iterator.next();
                        String comment$iv = "UDP packet handler for specific prefix, remoteAddress: " + remoteAddress + ", " + handler.getClass().getName();
                        boolean $i$f$catch = false;
                        Logger $this$catch$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                        boolean $i$f$catch2 = false;
                        try {
                            boolean bl2 = false;
                            handler.invoke((Object)remoteAddress, (Object)packetData);
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence charSequence = comment$iv;
                            String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : " (" + comment$iv + ")");
                            LoggerKt.error((Logger)$this$catch$iv$iv, (String)("Catch " + sfx$iv$iv), (Throwable)e$iv$iv);
                        }
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)this$0.mappedEvents.get((Object)remoteAddress), (String)"get(...)");
                if (!specificHandlers.isEmpty()) {
                    Object object;
                    object = specificHandlers.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block13;
                        Function1 specificHandler = (Function1)object.next();
                        String comment$iv = "UDP packet handler for " + remoteAddress + ": " + specificHandler.getClass().getName();
                        boolean $i$f$catch = false;
                        Logger $this$catch$iv$iv = (Logger)RdDefaultErrorLoggerHolder.INSTANCE.getDefaultErrorLogger();
                        boolean $i$f$catch3 = false;
                        try {
                            boolean bl3 = false;
                            specificHandler.invoke((Object)packetData);
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence charSequence = comment$iv;
                            String sfx$iv$iv = e$iv$iv.getClass().getName() + " " + e$iv$iv.getMessage() + (String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : " (" + comment$iv + ")");
                            LoggerKt.error((Logger)$this$catch$iv$iv, (String)("Catch " + sfx$iv$iv), (Throwable)e$iv$iv);
                        }
                    }
                }
                this$0.remainingPacketsEvent.fire((Object)new TurnPacketEvent(remoteAddress, packetData));
            }
        }
        catch (InterruptedException packet) {
        }
        catch (Throwable t) {
            DatagramSocketWrapperKt.access$getLOG$p().warn("Receive thread '" + $threadName + "' exception: " + t.getMessage(), t);
        }
        finally {
            DatagramSocketWrapperKt.access$getLOG$p().debug("Receive thread '" + $threadName + "' is finished");
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(DatagramSocketWrapper this$0, Thread $thread) {
        if (!this$0.socket.isClosed()) {
            boolean $i$f$catchAndDrop = false;
            try {
                boolean bl = false;
                this$0.socket.close();
            }
            catch (Throwable throwable) {
            }
        }
        ThreadUtil.INSTANCE.gracefullyJoinThread($thread);
        return Unit.INSTANCE;
    }
}

