/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.turn.TurnMessageUtil;
import com.intellij.platform.split.connection.network.turn.data.ChannelState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\n\u0010 \u001a\u00020!H\u0096\u0080\u0004J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J'\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010(\u001a\u00020\u001dH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/ChannelInfo;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "channelNumber", "", "peerAddress", "Ljava/net/InetSocketAddress;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;CLjava/net/InetSocketAddress;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getChannelNumber", "()C", "getPeerAddress", "()Ljava/net/InetSocketAddress;", "expiration", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "getExpiration", "()Ljava/util/concurrent/atomic/AtomicReference;", "state", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/intellij/platform/split/connection/network/turn/data/ChannelState;", "getState", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "updateChannelLifetimeFromNow", "", "lifetimeSeconds", "", "isRefreshRequired", "", "toString", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nChannelInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/ChannelInfo\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n13#2:81\n13#3:82\n*S KotlinDebug\n*F\n+ 1 ChannelInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/ChannelInfo\n*L\n24#1:81\n24#1:82\n*E\n"})
public final class ChannelInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition lifetime;
    private final char channelNumber;
    @NotNull
    private final InetSocketAddress peerAddress;
    @NotNull
    private final AtomicReference<Instant> expiration;
    @NotNull
    private final IProperty<ChannelState> state;
    @NotNull
    private static final Logger logger;
    private static final int defaultChannelLifetimeSeconds = 600;
    private static final DateTimeFormatter dateFormatter;

    public ChannelInfo(@NotNull LifetimeDefinition lifetime, char channelNumber, @NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        this.lifetime = lifetime;
        this.channelNumber = channelNumber;
        this.peerAddress = peerAddress;
        this.expiration = new AtomicReference<Instant>(Instant.now());
        this.state = (IProperty)new Property((Object)ChannelState.FREE);
        ChannelInfo.updateChannelLifetimeFromNow$default(this, 0, 1, null);
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    public final char getChannelNumber() {
        return this.channelNumber;
    }

    @NotNull
    public final InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    @NotNull
    public final AtomicReference<Instant> getExpiration() {
        return this.expiration;
    }

    @NotNull
    public final IProperty<ChannelState> getState() {
        return this.state;
    }

    public final void updateChannelLifetimeFromNow(int lifetimeSeconds) {
        long lifetimeEpochSeconds = Instant.now().getEpochSecond() + (long)lifetimeSeconds;
        this.expiration.set(Instant.ofEpochSecond(lifetimeEpochSeconds));
        Instant channelExpirationValue = this.expiration.get();
        logger.info("Updated channel lifetime to '" + dateFormatter.format(channelExpirationValue) + "' (+" + lifetimeSeconds + " sec, epoch: " + channelExpirationValue.getEpochSecond() + " sec)");
    }

    public static /* synthetic */ void updateChannelLifetimeFromNow$default(ChannelInfo channelInfo, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 600;
        }
        channelInfo.updateChannelLifetimeFromNow(n);
    }

    public final boolean isRefreshRequired() {
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)this.lifetime))) {
            return false;
        }
        ChannelState state = (ChannelState)((Object)this.state.getValue());
        if (state == ChannelState.TERMINATING) {
            return false;
        }
        long nowEpochSeconds = Instant.now().getEpochSecond();
        return nowEpochSeconds >= this.expiration.get().getEpochSecond() - Duration.ofMinutes(2L).toSeconds();
    }

    @NotNull
    public String toString() {
        return "TURN channel (number: " + TurnMessageUtil.INSTANCE.toHex(this.channelNumber) + ", peer address: " + this.peerAddress + ", state: " + ((ChannelState)((Object)this.state.getValue())).name() + ")";
    }

    @NotNull
    public final LifetimeDefinition component1() {
        return this.lifetime;
    }

    public final char component2() {
        return this.channelNumber;
    }

    @NotNull
    public final InetSocketAddress component3() {
        return this.peerAddress;
    }

    @NotNull
    public final ChannelInfo copy(@NotNull LifetimeDefinition lifetime, char channelNumber, @NotNull InetSocketAddress peerAddress) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
        return new ChannelInfo(lifetime, channelNumber, peerAddress);
    }

    public static /* synthetic */ ChannelInfo copy$default(ChannelInfo channelInfo, LifetimeDefinition lifetimeDefinition, char c, InetSocketAddress inetSocketAddress, int n, Object object) {
        if ((n & 1) != 0) {
            lifetimeDefinition = channelInfo.lifetime;
        }
        if ((n & 2) != 0) {
            c = channelInfo.channelNumber;
        }
        if ((n & 4) != 0) {
            inetSocketAddress = channelInfo.peerAddress;
        }
        return channelInfo.copy(lifetimeDefinition, c, inetSocketAddress);
    }

    public int hashCode() {
        int result = this.lifetime.hashCode();
        result = result * 31 + Character.hashCode(this.channelNumber);
        result = result * 31 + this.peerAddress.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChannelInfo)) {
            return false;
        }
        ChannelInfo channelInfo = (ChannelInfo)other;
        if (!Intrinsics.areEqual((Object)this.lifetime, (Object)channelInfo.lifetime)) {
            return false;
        }
        if (this.channelNumber != channelInfo.channelNumber) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.peerAddress, (Object)channelInfo.peerAddress);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChannelInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChannelInfo.logger = logger;
        dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/ChannelInfo$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "defaultChannelLifetimeSeconds", "", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

