/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.tags.Jinja2Tag;
import com.intellij.jinja.template.psi.impl.DjangoLiteral;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.lang.template.psi.impl.url.arguments.Jinja2UrlArgument;
import com.jetbrains.django.lang.template.psi.impl.url.arguments.Jinja2UrlArgumentValue;
import com.jetbrains.django.lang.template.tags.Jinja2UrlTag;
import com.jetbrains.django.model.modelApi.DjangoUrlArgumentDefinition;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DjangoUrlArgumentsInspection
extends DjangoTemplateLocalInspectionTool {
    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new MyUrlArgumentVisitor(manager);
    }

    @InspectionMessage
    private static String getMixedArgsError() {
        return DjangoBundle.message((String)"inspection.url_tag_arguments.args_mixed", (Object[])new Object[0]);
    }

    private static final class MyUrlArgumentVisitor
    extends DjangoInspectionVisitorAdapter {
        private MyUrlArgumentVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        public void visitTag(@NotNull Jinja2Tag tag) {
            if (tag == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(1);
            }
            if (tag instanceof Jinja2UrlTag) {
                boolean positionSyntaxUsed;
                Jinja2UrlTag urlTag = (Jinja2UrlTag)tag;
                DjangoUrlModel urlModel = urlTag.findAssociatedUrl();
                if (urlModel == null) {
                    return;
                }
                ArrayList expectedGroups = new ArrayList(urlModel.getArguments());
                if (expectedGroups.isEmpty()) {
                    return;
                }
                HashMap<String, Jinja2UrlArgument> namedArguments = new HashMap<String, Jinja2UrlArgument>();
                ArrayList<Jinja2UrlArgument> positionArguments = new ArrayList<Jinja2UrlArgument>();
                for (Jinja2UrlArgument argument : urlTag.getArguments()) {
                    String argumentName = argument.getArgumentName();
                    if (argumentName != null) {
                        namedArguments.put(argumentName, argument);
                        continue;
                    }
                    positionArguments.add(argument);
                }
                boolean namedSyntaxUsed = !namedArguments.isEmpty();
                boolean bl = positionSyntaxUsed = !positionArguments.isEmpty();
                if (namedSyntaxUsed && positionSyntaxUsed) {
                    this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)urlTag, DjangoUrlArgumentsInspection.getMixedArgsError(), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
                    return;
                }
                if (!namedSyntaxUsed && !positionSyntaxUsed) {
                    this.missingExpectedArguments(urlTag, expectedGroups, 0);
                    return;
                }
                if (namedSyntaxUsed) {
                    this.processNamedSyntax(urlTag, expectedGroups, namedArguments);
                }
                if (positionSyntaxUsed) {
                    this.processPositionSyntax(urlTag, expectedGroups, positionArguments);
                } else {
                    super.visitTag(tag);
                }
            }
        }

        private void missingExpectedArguments(@NotNull Jinja2UrlTag urlTag, @NotNull List<DjangoUrlArgumentDefinition<?>> expectedGroups, int start) {
            if (urlTag == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(2);
            }
            if (expectedGroups == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(3);
            }
            ArrayList<String> errors = new ArrayList<String>();
            for (int i = start; i < expectedGroups.size(); ++i) {
                DjangoUrlArgumentDefinition<?> group = expectedGroups.get(i);
                String groupName = group.getName();
                if (groupName != null) {
                    errors.add(DjangoBundle.message((String)"inspection.url_tag_arguments.named_arg_string", (Object[])new Object[]{groupName}));
                    continue;
                }
                errors.add(DjangoBundle.message((String)"inspection.url_tag_arguments.pos_arg_string", (Object[])new Object[]{i + 1}));
            }
            if (!errors.isEmpty()) {
                String message = DjangoBundle.message((String)"inspection.url_tag_arguments.missing_args", (Object[])new Object[]{StringUtil.join(errors, (String)",")});
                this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)urlTag, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
            }
        }

        private void processPositionSyntax(@NotNull Jinja2UrlTag urlTag, @NotNull List<DjangoUrlArgumentDefinition<?>> expectedGroups, @NotNull List<Jinja2UrlArgument> positionArguments) {
            int i;
            if (urlTag == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(4);
            }
            if (expectedGroups == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(5);
            }
            if (positionArguments == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(6);
            }
            int expectedNumOfArguments = expectedGroups.size();
            if (positionArguments.size() < expectedNumOfArguments) {
                this.missingExpectedArguments(urlTag, expectedGroups, expectedNumOfArguments - positionArguments.size());
            } else if (positionArguments.size() > expectedNumOfArguments) {
                for (i = expectedNumOfArguments; i < positionArguments.size(); ++i) {
                    PsiElement argToMark = (PsiElement)positionArguments.get(i);
                    String argName = DjangoBundle.message((String)"inspection.url_tag_arguments.pos_arg_string", (Object[])new Object[]{i + 1});
                    String message = DjangoBundle.message((String)"inspection.url_tag_arguments.redundant_argument", (Object[])new Object[]{argName});
                    this.myProblems.add(this.myManager.createProblemDescriptor(argToMark, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
                }
            }
            for (i = 0; i < positionArguments.size(); ++i) {
                if (expectedGroups.size() <= i) continue;
                this.tryValidateArgument(expectedGroups.get(i), positionArguments.get(i));
            }
        }

        private void processNamedSyntax(@NotNull Jinja2UrlTag urlTag, @NotNull List<DjangoUrlArgumentDefinition<?>> expectedGroups, @NotNull Map<String, Jinja2UrlArgument> namedArguments) {
            if (urlTag == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(7);
            }
            if (expectedGroups == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(8);
            }
            if (namedArguments == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(9);
            }
            HashSet<String> missedArguments = new HashSet<String>();
            for (DjangoUrlArgumentDefinition<?> paramGroup : expectedGroups) {
                String groupName = paramGroup.getName();
                if (groupName == null) continue;
                if (!namedArguments.containsKey(groupName)) {
                    missedArguments.add(groupName);
                    continue;
                }
                Jinja2UrlArgument argument = namedArguments.remove(groupName);
                assert (argument != null) : "Collection returned null while element exists";
                this.tryValidateArgument(paramGroup, argument);
            }
            for (Jinja2UrlArgument argument : namedArguments.values()) {
                String message = DjangoBundle.message((String)"inspection.url_tag_arguments.redundant_argument", (Object[])new Object[]{argument.getArgumentName()});
                this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)argument, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
            }
            if (!missedArguments.isEmpty()) {
                String message = DjangoBundle.message((String)"inspection.url_tag_arguments.missing_args", (Object[])new Object[]{StringUtil.join(missedArguments, (String)",")});
                this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)urlTag, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
            }
        }

        private void tryValidateArgument(@NotNull DjangoUrlArgumentDefinition<?> group, @NotNull Jinja2UrlArgument argument) {
            Jinja2UrlArgumentValue argumentValue;
            if (group == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(10);
            }
            if (argument == null) {
                MyUrlArgumentVisitor.$$$reportNull$$$0(11);
            }
            if ((argumentValue = argument.getValue()) == null) {
                return;
            }
            DjangoLiteral djangoLiteral = (DjangoLiteral)PsiTreeUtil.getChildOfType((PsiElement)argumentValue, DjangoLiteral.class);
            if (djangoLiteral == null) {
                return;
            }
            String stringValue = djangoLiteral.getValue();
            Boolean valid = group.isValid(stringValue);
            String pattern = group.getPattern();
            if (valid != null && !valid.booleanValue() && pattern != null) {
                String message = DjangoBundle.message((String)"inspection.url_tag_arguments.bad_regex", (Object[])new Object[]{stringValue, pattern});
                this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)argument, message, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlTag";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedGroups";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "positionArguments";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedArguments";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/lang/template/inspection/DjangoUrlArgumentsInspection$MyUrlArgumentVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTag";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "missingExpectedArguments";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processPositionSyntax";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNamedSyntax";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryValidateArgument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

