/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.logical;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.structureView.logical.ExternalElementsProvider;
import com.intellij.ide.structureView.logical.model.LogicalContainerPresentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.python.django.logical.codeGenerator.DjangoLogicalStructureCodeGeneratorService;
import com.intellij.python.django.logical.models.DjangoEmptyNodeWithCodeGenerationLModel;
import com.intellij.python.django.logical.models.DjangoModelLModel;
import com.intellij.python.django.logical.models.DjangoSerializerLModel;
import com.intellij.python.django.packages.restFramework.DjangoSerializerClass;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.DjangoIcons;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.psi.resolve.PackageAvailabilityKt;
import com.jetbrains.python.psi.resolve.PackageAvailabilitySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=SerializersPresentation.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/django/logical/DjangoModelToSerializersProvider;", "Lcom/intellij/ide/structureView/logical/ExternalElementsProvider;", "Lcom/intellij/python/django/logical/models/DjangoModelLModel;", "", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "generateSerializer", "", "project", "Lcom/intellij/openapi/project/Project;", "djangoModelLModel", "Companion", "SerializersPresentation", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoModelToSerializersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoModelToSerializersProvider.kt\ncom/intellij/python/django/logical/DjangoModelToSerializersProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1586#2:61\n1661#2,3:62\n*S KotlinDebug\n*F\n+ 1 DjangoModelToSerializersProvider.kt\ncom/intellij/python/django/logical/DjangoModelToSerializersProvider\n*L\n32#1:61\n32#1:62,3\n*E\n"})
public final class DjangoModelToSerializersProvider
implements ExternalElementsProvider<DjangoModelLModel, Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PackageAvailabilitySpec DRF_SERIALIZER_MARKER;

    public boolean isApplicable(@NotNull DjangoModelLModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Module module = DjangoUtil.getDjangoModule((Project)parent.getDjangoModelClass().getPyClass().getProject());
        if (module == null) {
            return false;
        }
        Module djangoModule = module;
        return PackageAvailabilityKt.isPackageAvailable((Module)djangoModule, (PackageAvailabilitySpec)DRF_SERIALIZER_MARKER);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Object> getElements(@NotNull DjangoModelLModel parent) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Project project = parent.getDjangoModelClass().getPyClass().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Iterable $this$map$iv = DjangoSerializerClass.Companion.findDjangoModelSerializersByModelClass(parent.getDjangoModelClass());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DjangoSerializerClass djangoSerializerClass = (DjangoSerializerClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DjangoSerializerLModel((DjangoSerializerClass)it, null, null, 6, null));
        }
        List listOfSerializers = (List)destination$iv$iv;
        if (!((Collection)listOfSerializers).isEmpty()) {
            return listOfSerializers;
        }
        Project project3 = parent.getDjangoModelClass().getPyClass().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        return CollectionsKt.listOf((Object)new DjangoEmptyNodeWithCodeGenerationLModel(project3, (Function0<Unit>)((Function0)() -> DjangoModelToSerializersProvider.getElements$lambda$1(this, project2, parent))));
    }

    private final void generateSerializer(Project project, DjangoModelLModel djangoModelLModel) {
        DjangoLogicalStructureCodeGeneratorService codeGenerator = DjangoLogicalStructureCodeGeneratorService.Companion.getInstance(project);
        codeGenerator.generateSerializerForModel(djangoModelLModel);
    }

    private static final Unit getElements$lambda$1(DjangoModelToSerializersProvider this$0, Project $project, DjangoModelLModel $parent) {
        this$0.generateSerializer($project, $parent);
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"rest_framework.serializers.Serializer"};
        DRF_SERIALIZER_MARKER = new PackageAvailabilitySpec("djangorestframework", stringArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/django/logical/DjangoModelToSerializersProvider$Companion;", "", "<init>", "()V", "DRF_SERIALIZER_MARKER", "Lcom/jetbrains/python/psi/resolve/PackageAvailabilitySpec;", "intellij.python.django"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/django/logical/DjangoModelToSerializersProvider$SerializersPresentation;", "Lcom/intellij/ide/structureView/logical/model/LogicalContainerPresentationProvider;", "Lcom/intellij/python/django/logical/DjangoModelToSerializersProvider;", "<init>", "()V", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "intellij.python.django"})
    public static final class SerializersPresentation
    extends LogicalContainerPresentationProvider<DjangoModelToSerializersProvider> {
        @NotNull
        public String getName(@Nullable DjangoModelToSerializersProvider t) {
            String string = DjangoBundle.message((String)"django.presentation.model.to.serializers.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public Icon getIcon(@Nullable DjangoModelToSerializersProvider t) {
            Icon icon = DjangoIcons.LogicalStructure.Serializer;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Serializer");
            return icon;
        }
    }
}

