/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.constance.ref;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageSearchParameters;
import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.python.django.packages.constance.ConstanceUtils;
import com.intellij.python.django.packages.constance.ref.ConstanceSettingSymbol;
import com.intellij.refactoring.rename.api.PsiModifiableRenameUsage;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageSearchParameters;
import com.intellij.util.QueriesKt;
import com.intellij.util.Query;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ,\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u000e2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ\u001a\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005*\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/django/packages/constance/ref/ConstanceSearchUtils;", "", "<init>", "()V", "collectSearcherRequest", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/PsiUsage;", "parameters", "Lcom/intellij/find/usages/api/UsageSearchParameters;", "editQueryBuilder", "Lkotlin/Function1;", "Lcom/intellij/model/search/SearchWordQueryBuilder;", "collectRenameSearcherRequest", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "Lcom/intellij/refactoring/rename/api/RenameUsageSearchParameters;", "mappingToConstanceUsages", "Lcom/intellij/model/search/TextOccurrence;", "isConfigString", "", "element", "Lcom/intellij/psi/PsiElement;", "isConfigUsageText", "isConfigDeclaration", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nConstanceSearchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstanceSearchUtils.kt\ncom/intellij/python/django/packages/constance/ref/ConstanceSearchUtils\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,94:1\n18#2:95\n18#2:96\n*S KotlinDebug\n*F\n+ 1 ConstanceSearchUtils.kt\ncom/intellij/python/django/packages/constance/ref/ConstanceSearchUtils\n*L\n80#1:95\n68#1:96\n*E\n"})
public final class ConstanceSearchUtils {
    @NotNull
    public static final ConstanceSearchUtils INSTANCE = new ConstanceSearchUtils();

    private ConstanceSearchUtils() {
    }

    @Nullable
    public final Query<? extends PsiUsage> collectSearcherRequest(@NotNull UsageSearchParameters parameters, @NotNull Function1<? super SearchWordQueryBuilder, ? extends SearchWordQueryBuilder> editQueryBuilder) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(editQueryBuilder, (String)"editQueryBuilder");
        SearchTarget searchTarget = parameters.getTarget();
        ConstanceSettingSymbol constanceSettingSymbol = searchTarget instanceof ConstanceSettingSymbol ? (ConstanceSettingSymbol)searchTarget : null;
        if (constanceSettingSymbol == null) {
            return null;
        }
        ConstanceSettingSymbol symbol = constanceSettingSymbol;
        SearchService searchService = SearchService.Companion.getInstance();
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = symbol.getConfigElement().getName().getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        SearchWordQueryBuilder searchWordQueryBuilder = searchService.searchWord(project, string);
        SearchContext searchContext = SearchContext.inCode();
        Intrinsics.checkNotNullExpressionValue((Object)searchContext, (String)"inCode(...)");
        SearchWordQueryBuilder searchWordQueryBuilder2 = new SearchContext[1];
        Intrinsics.checkNotNullExpressionValue((Object)SearchContext.inStrings(), (String)"inStrings(...)");
        searchWordQueryBuilder2 = searchWordQueryBuilder.inContexts(searchContext, (SearchContext[])searchWordQueryBuilder2).inScope(parameters.getSearchScope()).caseSensitive(true);
        return this.mappingToConstanceUsages((Query<? extends TextOccurrence>)((SearchWordQueryBuilder)editQueryBuilder.invoke((Object)searchWordQueryBuilder2)).buildLeafOccurrenceQuery());
    }

    @Nullable
    public final Query<? extends RenameUsage> collectRenameSearcherRequest(@NotNull RenameUsageSearchParameters parameters, @NotNull Function1<? super SearchWordQueryBuilder, ? extends SearchWordQueryBuilder> editQueryBuilder) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(editQueryBuilder, (String)"editQueryBuilder");
        RenameTarget renameTarget = parameters.getTarget();
        ConstanceSettingSymbol constanceSettingSymbol = renameTarget instanceof ConstanceSettingSymbol ? (ConstanceSettingSymbol)renameTarget : null;
        if (constanceSettingSymbol == null) {
            return null;
        }
        ConstanceSettingSymbol symbol = constanceSettingSymbol;
        SearchService searchService = SearchService.Companion.getInstance();
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = symbol.getConfigElement().getName().getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        SearchWordQueryBuilder searchWordQueryBuilder = searchService.searchWord(project, string);
        SearchContext searchContext = SearchContext.inCode();
        Intrinsics.checkNotNullExpressionValue((Object)searchContext, (String)"inCode(...)");
        SearchWordQueryBuilder searchWordQueryBuilder2 = new SearchContext[1];
        Intrinsics.checkNotNullExpressionValue((Object)SearchContext.inStrings(), (String)"inStrings(...)");
        SearchWordQueryBuilder searchWordQueryBuilder3 = searchWordQueryBuilder.inContexts(searchContext, (SearchContext[])searchWordQueryBuilder2);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)parameters.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        searchWordQueryBuilder2 = searchWordQueryBuilder3.inScope((SearchScope)globalSearchScope).caseSensitive(true);
        return this.mappingToConstanceUsages((Query<? extends TextOccurrence>)((SearchWordQueryBuilder)editQueryBuilder.invoke((Object)searchWordQueryBuilder2)).buildLeafOccurrenceQuery()).mapping(arg_0 -> ConstanceSearchUtils.collectRenameSearcherRequest$lambda$1(ConstanceSearchUtils::collectRenameSearcherRequest$lambda$0, arg_0));
    }

    @NotNull
    public final Query<? extends PsiUsage> mappingToConstanceUsages(@NotNull Query<? extends TextOccurrence> $this$mappingToConstanceUsages) {
        Intrinsics.checkNotNullParameter($this$mappingToConstanceUsages, (String)"<this>");
        return QueriesKt.mappingNotNull($this$mappingToConstanceUsages, ConstanceSearchUtils::mappingToConstanceUsages$lambda$0);
    }

    private final boolean isConfigString(PsiElement element) {
        if (!(element instanceof PyStringElement)) {
            return false;
        }
        PsiElement $this$asSafely$iv = ((PyStringElement)element).getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PyStringLiteralExpression)) {
            psiElement = null;
        }
        PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)psiElement;
        if (pyStringLiteralExpression == null) {
            return false;
        }
        PyStringLiteralExpression stringLiteralExpression = pyStringLiteralExpression;
        return this.isConfigDeclaration(stringLiteralExpression) || ConstanceUtils.INSTANCE.isFieldsetsSettingUsage(stringLiteralExpression);
    }

    private final boolean isConfigUsageText(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof PyQualifiedExpression && ConstanceUtils.INSTANCE.isConfigSettingUsage((PyQualifiedExpression)parent) || parent instanceof PyKeywordArgument && ConstanceUtils.INSTANCE.isOverrideSettingUsage((PyKeywordArgument)parent) || parent instanceof Jinja2MemberNameImpl && ConstanceUtils.INSTANCE.isConfigSettingUsage((Jinja2MemberNameImpl)parent);
    }

    private final boolean isConfigDeclaration(PyStringLiteralExpression element) {
        return ConstanceUtils.INSTANCE.getConfigDeclaration(element) != null;
    }

    private static final PsiModifiableRenameUsage collectRenameSearcherRequest$lambda$0(PsiUsage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiModifiableRenameUsage.Companion.defaultPsiModifiableRenameUsage(it);
    }

    private static final PsiModifiableRenameUsage collectRenameSearcherRequest$lambda$1(Function1 $tmp0, Object p0) {
        return (PsiModifiableRenameUsage)$tmp0.invoke(p0);
    }

    private static final PsiUsage mappingToConstanceUsages$lambda$0(TextOccurrence occurence) {
        PsiUsage psiUsage;
        Intrinsics.checkNotNullParameter((Object)occurence, (String)"occurence");
        PsiElement psiElement = occurence.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element = psiElement;
        if (INSTANCE.isConfigUsageText(element)) {
            psiUsage = PsiUsage.Companion.textUsage(element, new TextRange(0, element.getTextLength()));
        } else if (INSTANCE.isConfigString(element)) {
            PsiElement $this$asSafely$iv = element.getParent();
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof PyStringLiteralExpression)) {
                psiElement2 = null;
            }
            PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)psiElement2;
            if (pyStringLiteralExpression != null) {
                PyStringLiteralExpression stringLiteralExpression = pyStringLiteralExpression;
                boolean bl = false;
                PsiElement psiElement3 = (PsiElement)stringLiteralExpression;
                TextRange textRange = stringLiteralExpression.getStringValueTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getStringValueTextRange(...)");
                psiUsage = PsiUsage.Companion.textUsage(psiElement3, textRange);
            } else {
                psiUsage = null;
            }
        } else {
            psiUsage = null;
        }
        return psiUsage;
    }
}

