/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.restFramework.ref;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.rename.PythonNamesValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/django/packages/restFramework/ref/DrfInsertMissingFunctionViewSetQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "classToFix", "Lcom/jetbrains/python/psi/PyClass;", "viewFunctionName", "", "<init>", "(Lcom/jetbrains/python/psi/PyClass;Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.django"})
public final class DrfInsertMissingFunctionViewSetQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final PyClass classToFix;
    @NotNull
    private String viewFunctionName;

    public DrfInsertMissingFunctionViewSetQuickFix(@NotNull PyClass classToFix, @NotNull String viewFunctionName) {
        Intrinsics.checkNotNullParameter((Object)classToFix, (String)"classToFix");
        Intrinsics.checkNotNullParameter((Object)viewFunctionName, (String)"viewFunctionName");
        this.classToFix = classToFix;
        this.viewFunctionName = viewFunctionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = DjangoBundle.message((String)"django.insert_missing_function.viewset.quickfix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!new PythonNamesValidator().isIdentifier(this.viewFunctionName, project)) {
            updater.cancel(DjangoBundle.message((String)"django.insert.missing.function.viewset.quickfix.error", (Object[])new Object[0]) + ": " + DjangoBundle.message((String)"django.insert.missing.function.viewset.quickfix.not.identifier", (Object[])new Object[0]));
            return;
        }
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)project);
        String code = StringsKt.trimIndent((String)("\n    def " + this.viewFunctionName + "(self, request, *args, **kwargs):\n      return Response(status=status.HTTP_200_OK)\n    "));
        PyClass classToFixWritable = (PyClass)updater.getWritable((PsiElement)this.classToFix);
        Object object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)classToFixWritable)), PyFunction.class, code);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createFromText(...)");
        PyFunction codeToAdd = (PyFunction)object;
        try {
            AddImportHelper.addOrUpdateFromImportStatement((PsiFile)classToFixWritable.getContainingFile(), (String)"rest_framework.response", (String)"Response", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
            AddImportHelper.addOrUpdateFromImportStatement((PsiFile)classToFixWritable.getContainingFile(), (String)"rest_framework", (String)"status", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
            PsiElement addedPsi = classToFixWritable.getStatementList().add((PsiElement)codeToAdd);
            updater.moveCaretTo(addedPsi);
        }
        catch (Exception e) {
            updater.cancel(DjangoBundle.message((String)"django.insert.missing.function.viewset.quickfix.error", (Object[])new Object[0]) + ": " + e.getMessage());
        }
    }
}

