/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.structure.ui.tree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.python.django.structure.data.DjangoComponent;
import com.intellij.python.django.structure.data.DjangoComponentDescriptor;
import com.intellij.python.django.structure.statistics.DjangoStructureUsageCollector;
import com.intellij.python.django.structure.ui.tree.DjangoDirectComponentsContainerNode;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\"\u001a\u00020\nH\u0016J\u0012\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0014J\u0014\u0010)\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010\u0017H\u0096\u0082\u0004J\n\u0010+\u001a\u00020,H\u0096\u0080\u0004J\b\u0010-\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/python/django/structure/ui/tree/DjangoComponentNode;", "C", "Lcom/intellij/python/django/structure/data/DjangoComponent;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "Lcom/intellij/python/django/structure/ui/tree/DjangoDirectComponentsContainerNode;", "Lcom/intellij/ide/util/treeView/ValidateableNode;", "project", "Lcom/intellij/openapi/project/Project;", "djangoComponent", "shouldShowApplicationName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/django/structure/data/DjangoComponent;Z)V", "components", "", "getComponents", "()Ljava/util/Collection;", "descriptor", "Lcom/intellij/python/django/structure/data/DjangoComponentDescriptor;", "getDescriptor", "()Lcom/intellij/python/django/structure/data/DjangoComponentDescriptor;", "canRepresent", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canNavigate", "canNavigateToSource", "navigate", "", "requestFocus", "getVirtualFile", "getCacheableFile", "isAlwaysLeaf", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "equals", "other", "hashCode", "", "isValid", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoComponentNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoComponentNode.kt\ncom/intellij/python/django/structure/ui/tree/DjangoComponentNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,70:1\n1#2:71\n18#3:72\n*S KotlinDebug\n*F\n+ 1 DjangoComponentNode.kt\ncom/intellij/python/django/structure/ui/tree/DjangoComponentNode\n*L\n57#1:72\n*E\n"})
public final class DjangoComponentNode<C extends DjangoComponent>
extends ProjectViewNode<C>
implements DjangoDirectComponentsContainerNode<C>,
ValidateableNode {
    private final boolean shouldShowApplicationName;
    @NotNull
    private final Collection<C> components;
    @NotNull
    private final DjangoComponentDescriptor descriptor;

    public DjangoComponentNode(@NotNull Project project, @NotNull C djangoComponent, boolean shouldShowApplicationName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(djangoComponent, (String)"djangoComponent");
        super(project, djangoComponent, (ViewSettings)ProjectViewSettings.Immutable.DEFAULT);
        this.shouldShowApplicationName = shouldShowApplicationName;
        this.components = CollectionsKt.listOf(djangoComponent);
        this.descriptor = djangoComponent.getDescriptor();
    }

    @Override
    @NotNull
    public Collection<C> getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public DjangoComponentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean canRepresent(@Nullable Object element) {
        return this.getVirtualFile().equals(element);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile it = this.getVirtualFile();
        boolean bl = false;
        return VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
    }

    public boolean canNavigate() {
        return ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Navigatable)this.getValue()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DjangoStructureUsageCollector.INSTANCE.onNavigateToSources(project, ((DjangoComponent)this.getValue()).getDescriptor().getComponentType());
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return ((DjangoComponent)this.getValue()).getVirtualFile();
    }

    @Nullable
    protected VirtualFile getCacheableFile() {
        Object object = this.getEqualityObject();
        SmartPsiElementPointer smartPsiElementPointer = object instanceof SmartPsiElementPointer ? (SmartPsiElementPointer)object : null;
        return smartPsiElementPointer != null ? smartPsiElementPointer.getVirtualFile() : null;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren() {
        return CollectionsKt.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(((DjangoComponent)this.getValue()).getIcon());
        presentation.addText(((DjangoComponent)this.getValue()).getDisplayNameColoredFragment());
        if (this.shouldShowApplicationName) {
            presentation.addText(new PresentableNodeDescriptor.ColoredFragment(StringsKt.repeat((CharSequence)" ", (int)2), SimpleTextAttributes.REGULAR_ATTRIBUTES));
            presentation.addText(((DjangoComponent)this.getValue()).getApplicationModel().getName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setTooltip(((DjangoComponent)this.getValue()).getTooltip());
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(other.getClass(), this.getClass())) {
            return false;
        }
        Object $this$asSafely$iv = other;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof DjangoComponentNode)) {
            object = null;
        }
        DjangoComponentNode djangoComponentNode = (DjangoComponentNode)object;
        if (djangoComponentNode == null) {
            return false;
        }
        DjangoComponentNode otherNode = djangoComponentNode;
        return Intrinsics.areEqual((Object)((DjangoComponent)otherNode.getValue()).getApplicationModel().getName(), (Object)((DjangoComponent)this.getValue()).getApplicationModel().getName()) && Intrinsics.areEqual((Object)((DjangoComponent)otherNode.getValue()).getDisplayName(), (Object)((DjangoComponent)this.getValue()).getDisplayName());
    }

    public int hashCode() {
        int result = ((DjangoComponent)this.getValue()).getApplicationModel().getName().hashCode();
        result = 31 * result + ((DjangoComponent)this.getValue()).getDisplayName().hashCode();
        return result;
    }

    public boolean isValid() {
        return ((DjangoComponent)this.getValue()).getPsiElement().isValid();
    }
}

