/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.structure.ui.tree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.python.django.structure.data.DjangoComponentType;
import com.intellij.python.django.structure.statistics.DjangoStructureUsageCollector;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.django.DjangoIcons;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0011\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0017\u001a\u00020\nH\u0016J\u0012\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\nH\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/python/django/structure/ui/tree/DjangoSettingsNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/ide/util/treeView/ValidateableNode;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canNavigate", "canNavigateToSource", "navigate", "", "requestFocus", "getVirtualFile", "getCacheableFile", "isAlwaysLeaf", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getWeight", "", "isValid", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoSettingsNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoSettingsNode.kt\ncom/intellij/python/django/structure/ui/tree/DjangoSettingsNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class DjangoSettingsNode
extends ProjectViewNode<PsiFile>
implements ValidateableNode {
    public DjangoSettingsNode(@NotNull Project project, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        super(project, (Object)psiFile, (ViewSettings)ProjectViewSettings.Immutable.DEFAULT);
    }

    public boolean canRepresent(@Nullable Object element) {
        return this.getVirtualFile().equals(element);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile it = this.getVirtualFile();
        boolean bl = false;
        return VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
    }

    public boolean canNavigate() {
        return ((PsiFile)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((PsiFile)this.getValue()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DjangoStructureUsageCollector.INSTANCE.onNavigateToSources(project, DjangoComponentType.SETTINGS);
        ((PsiFile)this.getValue()).navigate(requestFocus);
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = ((PsiFile)this.getValue()).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return virtualFile;
    }

    @Nullable
    protected VirtualFile getCacheableFile() {
        Object object = this.getEqualityObject();
        SmartPsiElementPointer smartPsiElementPointer = object instanceof SmartPsiElementPointer ? (SmartPsiElementPointer)object : null;
        return smartPsiElementPointer != null ? smartPsiElementPointer.getVirtualFile() : null;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren() {
        return CollectionsKt.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(DjangoIcons.Django);
        presentation.addText(DjangoBundle.message((String)"django.structure.component.settings", (Object[])new Object[0]), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(StringsKt.repeat((CharSequence)" ", (int)2), SimpleTextAttributes.REGULAR_ATTRIBUTES));
        presentation.addText(((PsiFile)this.getValue()).getName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public int getWeight() {
        return 20;
    }

    public boolean isValid() {
        return ((PsiFile)this.getValue()).isValid();
    }
}

