/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssMediaQueryImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public final class CssPsiElementPatters {
    private static final TokenSet BLOCK_START_OR_END_SET = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RBRACE});
    public static final PsiElementPattern.Capture<PsiElement> IMPORTANT_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).inside(CssDeclaration.class)).afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withText("!"));
    public static final PsiElementPattern.Capture<PsiElement> KEYFRAMES_SELECTOR_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(CssKeyframesSelector.class);

    private CssPsiElementPatters() {
    }

    public static PsiElementPattern.Capture<PsiElement> elementInsidePropertyAtRule() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_CUSTOM_PROPERTY_AT_RULE));
    }

    public static PsiElementPattern.Capture<PsiElement> emptyElement() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("");
    }

    public static PsiElementPattern.Capture<PsiElement> spaceElement() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(" ");
    }

    public static ElementPattern<PsiElement> blockStartOrEnd() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType(BLOCK_START_OR_END_SET), PlatformPatterns.psiElement().withText((ElementPattern)StandardPatterns.string().contains("\n"))});
    }

    public static PsiElementPattern.Capture<PsiElement> mediaType() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent(CssMediaQueryImpl.class);
    }

    public static ElementPattern<? extends PsiElement> supportsUnknownConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    public static ElementPattern<? extends PsiElement> supportsAndConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    public static ElementPattern<? extends PsiElement> supportsOrConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    public static PsiElementPattern.Capture<PsiElement> inCssFile(IElementType cssIdent) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)cssIdent).inside((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_STYLESHEET));
    }

    public static PsiElementPattern.Capture<PsiElement> propertyDeclaration() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).andOr(new ElementPattern[]{CssPsiElementPatters.propertyName(), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(CssSimpleSelector.class)).inside(CssBlock.class)).afterLeafSkipping(StandardPatterns.or((ElementPattern[])new ElementPattern[]{CssPsiElementPatters.emptyElement(), CssPsiElementPatters.spaceElement()}), CssPsiElementPatters.blockStartOrEnd())).beforeLeafSkipping(StandardPatterns.or((ElementPattern[])new ElementPattern[]{CssPsiElementPatters.emptyElement(), CssPsiElementPatters.spaceElement()}), CssPsiElementPatters.blockStartOrEnd())});
    }

    public static PsiElementPattern.Capture<PsiElement> propertyName() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).atStartOf((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_DECLARATION));
    }

    public static ElementPattern<? extends PsiElement> mediaQueryKeywords() {
        return ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, CssMediaQueryImpl.class)).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{","}))).andOr(new ElementPattern[]{StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement(CssMediaExpression.class), (ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError())), PlatformPatterns.psiElement().afterLeaf(new String[]{")"})});
    }

    public static ElementPattern<? extends PsiElement> mediaFeatureName() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).atStartOf((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_MEDIA_FEATURE));
    }

    public static PsiElementPattern.Capture<PsiElement> pseudoSelectors() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent((ElementPattern)PlatformPatterns.psiElement(CssPseudoSelector.class))).afterLeaf(new String[]{":"});
    }

    public static PsiElementPattern.Capture<PsiElement> selector() {
        return (PsiElementPattern.Capture)CssPsiElementPatters.inCssFile(CssElementTypes.CSS_IDENT).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent(CssDeclaration.class), ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(CssTerm.class)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_TERM_LIST).andNot((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_TERM_LIST).afterLeaf(new String[]{":"})))).withSuperParent(3, CssDeclaration.class)});
    }

    public static ElementPattern<? extends PsiElement> atKeyword() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_ATKEYWORD);
    }

    public static ElementPattern<? extends PsiElement> charsetName() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_STRING_TOKEN).withParent(CssString.class)).withSuperParent(2, CssCharset.class);
    }
}

