/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.python;

import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.models.chat.ChatRepository;
import com.intellij.aiplayground.models.statistic.PlaygroundCollector;
import com.intellij.aiplayground.models.utils.AiPlaygroundCoroutine;
import com.intellij.aiplayground.models.utils.AiPlaygroundPluginDisposable;
import com.intellij.aiplayground.python.AIPlaygroundPythonBundle;
import com.intellij.aiplayground.python.AiPlaygroundInlayCollector;
import com.intellij.aiplayground.python.AiPlaygroundInlayHintsProviderKt;
import com.intellij.aiplayground.python.MLPromptStringsDetector;
import com.intellij.aiplayground.python.TextUtilsKt;
import com.intellij.aiplayground.ui.AIPlaygroundColors;
import com.intellij.aiplayground.ui.AIPlaygroundIcons;
import com.intellij.aiplayground.ui.chat.ChatUiProvider;
import com.intellij.aiplayground.ui.chat.ChatViewModel;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.ChangeOnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.InlayButtonPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u001b\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector;", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "()V", "isValidEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "collect", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "createAndShowPopup", "", "project", "Lcom/intellij/openapi/project/Project;", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "e", "Ljava/awt/event/MouseEvent;", "showContextMenu", "addInlayPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "cleanHighlightersIfAny", "ensureNoHighlighting", "AIPlaygroundHighlighter", "HighlightRemoverOnDocumentChange", "HoverListener", "intellij.aiplayground.python"})
@SourceDebugExtension(value={"SMAP\nAiPlaygroundInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPlaygroundInlayHintsProvider.kt\ncom/intellij/aiplayground/python/AiPlaygroundInlayCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,383:1\n1#2:384\n49#3,5:385\n42#4,3:390\n*S KotlinDebug\n*F\n+ 1 AiPlaygroundInlayHintsProvider.kt\ncom/intellij/aiplayground/python/AiPlaygroundInlayCollector\n*L\n273#1:385,5\n233#1:390,3\n*E\n"})
final class AiPlaygroundInlayCollector
implements InlayHintsCollector,
DocumentListener {
    public final boolean isValidEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project editorProject = editor.getProject();
        return editorProject != null && !editorProject.isDisposed() && !editor.isDisposed() && UIUtil.isShowing((Component)editor.getContentComponent());
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        PyPlainStringElement pyPlainStringElement = TextUtilsKt.asPromptElementOrNull$default(element, false, 1, null);
        if (pyPlainStringElement == null) {
            return true;
        }
        PyPlainStringElement promptElement = pyPlainStringElement;
        InlayPresentation inlayPresentation = this.addInlayPresentation(editor, element);
        sink.addInlineElement(promptElement.getTextRange().getEndOffset(), true, inlayPresentation, false);
        AiPlaygroundInlayHintsProviderKt.getPerEditorListenerMap().computeIfAbsent(editor, arg_0 -> AiPlaygroundInlayCollector.collect$lambda$1(arg_0 -> AiPlaygroundInlayCollector.collect$lambda$0(this, editor, element, arg_0), arg_0));
        PlaygroundCollector.INSTANCE.logInlayHintShown(editor);
        return true;
    }

    private final void createAndShowPopup(Editor editor, Project project, DefaultActionGroup actionGroup, MouseEvent e) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor).add(CommonDataKeys.PROJECT, (Object)project).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        popup.showInScreenCoordinates((Component)editor.getContentComponent(), e.getLocationOnScreen());
    }

    private final void showContextMenu(MouseEvent e, Editor editor) {
        DefaultActionGroup defaultActionGroup;
        List popupActions = InlayHintsUtils.INSTANCE.getDefaultInlayHintsProviderPopupActions(AiPlaygroundInlayHintsProviderKt.access$getKEY$p(), AiPlaygroundInlayCollector::showContextMenu$lambda$0);
        DefaultActionGroup $this$showContextMenu_u24lambda_u241 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$showContextMenu_u24lambda_u241.addAll((Collection)popupActions);
        DefaultActionGroup actionGroup = defaultActionGroup;
        this.createAndShowPopup(editor, editor.getProject(), actionGroup, e);
    }

    private final InlayPresentation addInlayPresentation(Editor editor, PsiElement element) {
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        SmartPsiElementPointer smartElement = smartPsiElementPointer;
        PresentationFactory factory = new PresentationFactory(editor);
        InlayButtonPresentationFactory inlayButtonPresentationFactory = new InlayButtonPresentationFactory(editor, factory, null, null, null, 28, null);
        String hintText = AIPlaygroundPythonBundle.message("inlay.hints.text", new Object[0]);
        String tooltipText = AIPlaygroundPythonBundle.message("inlay.hints.tooltip.text", new Object[0]);
        Icon icon = AIPlaygroundIcons.PurpleAIPlayground;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PurpleAIPlayground");
        Icon iconToUse = icon;
        InlayPresentation defaultButton = null;
        Ref.ObjectRef hoveredButton = new Ref.ObjectRef();
        if (!Intrinsics.areEqual((Object)hintText, (Object)"")) {
            defaultButton = inlayButtonPresentationFactory.iconAndText(iconToUse, hintText).withTooltip(tooltipText).build();
            hoveredButton.element = inlayButtonPresentationFactory.iconAndText(iconToUse, hintText).withTooltip(tooltipText).buildHovered();
        } else {
            defaultButton = inlayButtonPresentationFactory.icon(iconToUse).withTooltip(tooltipText).build();
            hoveredButton.element = inlayButtonPresentationFactory.icon(iconToUse).withTooltip(tooltipText).buildHovered();
        }
        ChangeOnHoverPresentation buttonWithHoverEffect = new ChangeOnHoverPresentation(defaultButton, () -> AiPlaygroundInlayCollector.addInlayPresentation$lambda$0(hoveredButton), null, 4, null);
        Executor executor2 = AiPlaygroundInlayCollector::addInlayPresentation$lambda$1;
        StaticDelegatePresentation clickSupport2 = new StaticDelegatePresentation(buttonWithHoverEffect, this, editor, (SmartPsiElementPointer<PsiElement>)smartElement, element){
            final /* synthetic */ AiPlaygroundInlayCollector this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ SmartPsiElementPointer<PsiElement> $smartElement;
            final /* synthetic */ PsiElement $element;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$smartElement = $smartElement;
                this.$element = $element;
                super((InlayPresentation)$buttonWithHoverEffect);
            }

            public void mousePressed(MouseEvent event, Point translated) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                switch (event.getButton()) {
                    case 1: {
                        String string = (String)ReadAction.compute(() -> addInlayPresentation.clickSupport.1.mousePressed$lambda$0(this.$smartElement));
                        if (string == null) {
                            return;
                        }
                        String chatInput = string;
                        boolean $i$f$service = false;
                        Class<AiPlaygroundCoroutine> serviceClass$iv = AiPlaygroundCoroutine.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        BuildersKt.launch$default((CoroutineScope)((AiPlaygroundCoroutine)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$element, chatInput, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ PsiElement $element;
                            final /* synthetic */ String $chatInput;
                            {
                                this.$element = $element;
                                this.$chatInput = $chatInput;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = this.$element.getProject();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                                        $this$service$iv = (ComponentManager)v0;
                                        $i$f$service = false;
                                        serviceClass$iv = ChatRepository.class;
                                        v1 = $this$service$iv.getService(serviceClass$iv);
                                        if (v1 == null) {
                                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                        }
                                        newChat = ChatRepository.createChat$default((ChatRepository)((ChatRepository)v1), null, (int)1, null);
                                        v2 = this.$element.getProject();
                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProject(...)");
                                        $this$service$iv = (ComponentManager)v2;
                                        $i$f$service = false;
                                        serviceClass$iv = ChatUiProvider.class;
                                        v3 = $this$service$iv.getService(serviceClass$iv);
                                        if (v3 == null) {
                                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                        }
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)newChat);
                                        this.label = 1;
                                        v4 = ((ChatUiProvider)v3).openChat(newChat, (Continuation)this);
                                        if (v4 == var7_2) {
                                            return var7_2;
                                        }
                                        ** GOTO lbl32
                                    }
                                    case 1: {
                                        newChat = (Chat)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl32:
                                        // 2 sources

                                        v5 = vm = (ChatViewModel)v4;
                                        if (v5 != null) {
                                            v5.updateInput(this.$chatInput);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        PlaygroundCollector.INSTANCE.logInlayHintClicked();
                        break;
                    }
                    case 3: {
                        AiPlaygroundInlayCollector.access$showContextMenu(this.this$0, event, this.$editor);
                        PlaygroundCollector.INSTANCE.logInlayHintRightClicked();
                    }
                }
            }

            private static final String mousePressed$lambda$0(SmartPsiElementPointer $smartElement) {
                PsiElement psiElement = $smartElement.getElement();
                Object object = psiElement != null ? psiElement.getParent() : null;
                Object object2 = object instanceof PyStringLiteralExpression ? (PyStringLiteralExpression)object : null;
                if (object2 == null || (object2 = object2.getStringValue()) == null) {
                    return null;
                }
                return object2;
            }
        };
        HoverListener hoverListener = new HoverListener(editor, (SmartPsiElementPointer<PsiElement>)smartElement, executor2);
        InlayPresentation hoverHighlightSupport = factory.onHover((InlayPresentation)clickSupport2, (InlayPresentationFactory.HoverListener)hoverListener);
        return hoverHighlightSupport;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void cleanHighlightersIfAny(Editor editor) {
        Object newValue$iv;
        Object existing$iv;
        void $this$getAndUpdateUserData$iv;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.util.UserDataHolderEx");
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)editor;
        Key key$iv = AiPlaygroundInlayHintsProviderKt.access$getAI_PLAYGROUND_HIGHLIGHTER_KEY$p();
        boolean $i$f$getAndUpdateUserData = false;
        do {
            existing$iv = $this$getAndUpdateUserData$iv.getUserData(key$iv);
            List it = (List)existing$iv;
            boolean bl = false;
        } while (!$this$getAndUpdateUserData$iv.replace(key$iv, existing$iv, newValue$iv = null));
        List list = (List)existing$iv;
        if (list == null) {
            return;
        }
        List highlighters = list;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        for (RangeHighlighter highlighter : highlighters) {
            markupModel2.removeHighlighter(highlighter);
        }
    }

    private final void ensureNoHighlighting(Editor editor) {
        ApplicationManager.getApplication().invokeLater(() -> AiPlaygroundInlayCollector.ensureNoHighlighting$lambda$0(this, editor));
    }

    private static final DocumentListener collect$lambda$0(AiPlaygroundInlayCollector this$0, Editor $editor, PsiElement $element, Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HighlightRemoverOnDocumentChange listener = this$0.new HighlightRemoverOnDocumentChange($editor);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Project project = $element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Disposer.register((Disposable)AiPlaygroundPluginDisposable.Companion.getInstance(project), (Disposable)disposable2);
        EditorUtil.disposeWithEditor((Editor)$editor, (Disposable)disposable2);
        $editor.getDocument().addDocumentListener((DocumentListener)listener, disposable2);
        return (DocumentListener)listener;
    }

    private static final DocumentListener collect$lambda$1(Function1 $tmp0, Object p0) {
        return (DocumentListener)$tmp0.invoke(p0);
    }

    private static final String showContextMenu$lambda$0() {
        return AIPlaygroundPythonBundle.message("inlay.hints.name", new Object[0]);
    }

    private static final InlayPresentation addInlayPresentation$lambda$0(Ref.ObjectRef $hoveredButton) {
        return (InlayPresentation)$hoveredButton.element;
    }

    private static final void addInlayPresentation$lambda$1(Runnable task) {
        boolean $i$f$service = false;
        Class<AiPlaygroundCoroutine> serviceClass$iv = AiPlaygroundCoroutine.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        BuildersKt.launch$default((CoroutineScope)((AiPlaygroundCoroutine)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task, null){
            int label;
            final /* synthetic */ Runnable $task;
            {
                this.$task = $task;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$task.run();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void ensureNoHighlighting$lambda$0(AiPlaygroundInlayCollector this$0, Editor $editor) {
        this$0.cleanHighlightersIfAny($editor);
    }

    public static final /* synthetic */ void access$showContextMenu(AiPlaygroundInlayCollector $this, MouseEvent e, Editor editor) {
        $this.showContextMenu(e, editor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J=\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector$AIPlaygroundHighlighter;", "", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "startOffset", "", "endOffset", "layer", "targetArea", "Lcom/intellij/openapi/editor/markup/HighlighterTargetArea;", "<init>", "(Lcom/intellij/openapi/editor/colors/TextAttributesKey;IIILcom/intellij/openapi/editor/markup/HighlighterTargetArea;)V", "getTextAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getStartOffset", "()I", "getEndOffset", "getLayer", "getTargetArea", "()Lcom/intellij/openapi/editor/markup/HighlighterTargetArea;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.aiplayground.python"})
    public static final class AIPlaygroundHighlighter {
        @Nullable
        private final TextAttributesKey textAttributesKey;
        private final int startOffset;
        private final int endOffset;
        private final int layer;
        @NotNull
        private final HighlighterTargetArea targetArea;

        public AIPlaygroundHighlighter(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
            Intrinsics.checkNotNullParameter((Object)targetArea, (String)"targetArea");
            this.textAttributesKey = textAttributesKey;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.layer = layer;
            this.targetArea = targetArea;
        }

        @Nullable
        public final TextAttributesKey getTextAttributesKey() {
            return this.textAttributesKey;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        public final int getLayer() {
            return this.layer;
        }

        @NotNull
        public final HighlighterTargetArea getTargetArea() {
            return this.targetArea;
        }

        @Nullable
        public final TextAttributesKey component1() {
            return this.textAttributesKey;
        }

        public final int component2() {
            return this.startOffset;
        }

        public final int component3() {
            return this.endOffset;
        }

        public final int component4() {
            return this.layer;
        }

        @NotNull
        public final HighlighterTargetArea component5() {
            return this.targetArea;
        }

        @NotNull
        public final AIPlaygroundHighlighter copy(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
            Intrinsics.checkNotNullParameter((Object)targetArea, (String)"targetArea");
            return new AIPlaygroundHighlighter(textAttributesKey, startOffset, endOffset, layer, targetArea);
        }

        public static /* synthetic */ AIPlaygroundHighlighter copy$default(AIPlaygroundHighlighter aIPlaygroundHighlighter, TextAttributesKey textAttributesKey, int n, int n2, int n3, HighlighterTargetArea highlighterTargetArea, int n4, Object object) {
            if ((n4 & 1) != 0) {
                textAttributesKey = aIPlaygroundHighlighter.textAttributesKey;
            }
            if ((n4 & 2) != 0) {
                n = aIPlaygroundHighlighter.startOffset;
            }
            if ((n4 & 4) != 0) {
                n2 = aIPlaygroundHighlighter.endOffset;
            }
            if ((n4 & 8) != 0) {
                n3 = aIPlaygroundHighlighter.layer;
            }
            if ((n4 & 0x10) != 0) {
                highlighterTargetArea = aIPlaygroundHighlighter.targetArea;
            }
            return aIPlaygroundHighlighter.copy(textAttributesKey, n, n2, n3, highlighterTargetArea);
        }

        @NotNull
        public String toString() {
            return "AIPlaygroundHighlighter(textAttributesKey=" + this.textAttributesKey + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", layer=" + this.layer + ", targetArea=" + this.targetArea + ")";
        }

        public int hashCode() {
            int result = this.textAttributesKey == null ? 0 : this.textAttributesKey.hashCode();
            result = result * 31 + Integer.hashCode(this.startOffset);
            result = result * 31 + Integer.hashCode(this.endOffset);
            result = result * 31 + Integer.hashCode(this.layer);
            result = result * 31 + this.targetArea.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AIPlaygroundHighlighter)) {
                return false;
            }
            AIPlaygroundHighlighter aIPlaygroundHighlighter = (AIPlaygroundHighlighter)other;
            if (!Intrinsics.areEqual((Object)this.textAttributesKey, (Object)aIPlaygroundHighlighter.textAttributesKey)) {
                return false;
            }
            if (this.startOffset != aIPlaygroundHighlighter.startOffset) {
                return false;
            }
            if (this.endOffset != aIPlaygroundHighlighter.endOffset) {
                return false;
            }
            if (this.layer != aIPlaygroundHighlighter.layer) {
                return false;
            }
            return this.targetArea == aIPlaygroundHighlighter.targetArea;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector$HighlightRemoverOnDocumentChange;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener$Simple;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "beforeDocumentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.aiplayground.python"})
    public final class HighlightRemoverOnDocumentChange
    implements BulkAwareDocumentListener.Simple {
        @NotNull
        private final Editor editor;

        public HighlightRemoverOnDocumentChange(Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        public void beforeDocumentChange(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            AiPlaygroundInlayCollector.this.ensureNoHighlighting(this.editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector$HoverListener;", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$HoverListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "smartElement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "executor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/intellij/aiplayground/python/AiPlaygroundInlayCollector;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/SmartPsiElementPointer;Ljava/util/concurrent/Executor;)V", "ensureHighlighting", "", "onHover", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "onHoverFinished", "intellij.aiplayground.python"})
    @SourceDebugExtension(value={"SMAP\nAiPlaygroundInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPlaygroundInlayHintsProvider.kt\ncom/intellij/aiplayground/python/AiPlaygroundInlayCollector$HoverListener\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n455#2:384\n1586#3:385\n1661#3,3:386\n*S KotlinDebug\n*F\n+ 1 AiPlaygroundInlayHintsProvider.kt\ncom/intellij/aiplayground/python/AiPlaygroundInlayCollector$HoverListener\n*L\n298#1:384\n349#1:385\n349#1:386,3\n*E\n"})
    public final class HoverListener
    implements InlayPresentationFactory.HoverListener {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> smartElement;
        @NotNull
        private final Executor executor;

        public HoverListener(@NotNull Editor editor, @NotNull SmartPsiElementPointer<PsiElement> smartElement, Executor executor2) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(smartElement, (String)"smartElement");
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            this.editor = editor;
            this.smartElement = smartElement;
            this.executor = executor2;
        }

        private final void ensureHighlighting() {
            long stamp = this.editor.getDocument().getModificationStamp();
            Object[] objectArray = new Object[]{AiPlaygroundInlayCollector.class, this.editor};
            ReadAction.nonBlocking(() -> HoverListener.ensureHighlighting$lambda$0(this)).coalesceBy(objectArray).expireWhen(() -> HoverListener.ensureHighlighting$lambda$1(this, stamp, AiPlaygroundInlayCollector.this)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> HoverListener.ensureHighlighting$lambda$3(arg_0 -> HoverListener.ensureHighlighting$lambda$2(this, AiPlaygroundInlayCollector.this, stamp, arg_0), arg_0)).submit(this.executor);
        }

        public void onHover(@NotNull MouseEvent event, @NotNull Point translated) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
            this.ensureHighlighting();
        }

        public void onHoverFinished() {
            AiPlaygroundInlayCollector.this.ensureNoHighlighting(this.editor);
        }

        private static final List ensureHighlighting$lambda$0(HoverListener this$0) {
            List list;
            PsiElement psiElement = this$0.smartElement.getElement();
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement element = psiElement;
            List $this$ensureHighlighting_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            PsiElement psiElement2 = element.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
            PsiElement $this$childrenOfType$iv = psiElement2;
            boolean $i$f$childrenOfType = false;
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, PyPlainStringElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
            for (PyPlainStringElement stringElement : list2) {
                $this$ensureHighlighting_u24lambda_u240_u240.add(new AIPlaygroundHighlighter(AIPlaygroundColors.INSTANCE.getAI_INLAY_HINT_HIGHLIGHT_PROMPT(), stringElement.getTextRange().getStartOffset(), stringElement.getTextRange().getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE));
                if (!Registry.Companion.is("aiplayground.inlay.hint.for.prompts.highlight.variables")) continue;
                MLPromptStringsDetector mLPromptStringsDetector = MLPromptStringsDetector.Companion.getInstance();
                String string = stringElement.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                List<MLPromptStringsDetector.PlaceholderPosition> placeholderPositions = mLPromptStringsDetector.getPlaceholderPositions(string);
                for (MLPromptStringsDetector.PlaceholderPosition placeholderPosition : placeholderPositions) {
                    $this$ensureHighlighting_u24lambda_u240_u240.add(new AIPlaygroundHighlighter(AIPlaygroundColors.INSTANCE.getAI_INLAY_HINT_HIGHLIGHT_PROMPT_PLACEHOLDER_BRACES(), stringElement.getTextRange().getStartOffset() + placeholderPosition.getStart(), stringElement.getTextRange().getStartOffset() + placeholderPosition.getStart() + 1, 6002, HighlighterTargetArea.EXACT_RANGE));
                    $this$ensureHighlighting_u24lambda_u240_u240.add(new AIPlaygroundHighlighter(AIPlaygroundColors.INSTANCE.getAI_INLAY_HINT_HIGHLIGHT_PROMPT_PLACEHOLDER_TEXT(), stringElement.getTextRange().getStartOffset() + placeholderPosition.getStart() + 1, stringElement.getTextRange().getStartOffset() + placeholderPosition.getEnd() - 1, 6002, HighlighterTargetArea.EXACT_RANGE));
                    $this$ensureHighlighting_u24lambda_u240_u240.add(new AIPlaygroundHighlighter(AIPlaygroundColors.INSTANCE.getAI_INLAY_HINT_HIGHLIGHT_PROMPT_PLACEHOLDER_BRACES(), stringElement.getTextRange().getStartOffset() + placeholderPosition.getEnd() - 1, stringElement.getTextRange().getStartOffset() + placeholderPosition.getEnd(), 6002, HighlighterTargetArea.EXACT_RANGE));
                }
            }
            return CollectionsKt.build((List)list);
        }

        private static final boolean ensureHighlighting$lambda$1(HoverListener this$0, long $stamp, AiPlaygroundInlayCollector this$1) {
            return this$0.editor.getDocument().getModificationStamp() != $stamp || !this$1.isValidEditor(this$0.editor) || this$0.smartElement.getElement() == null;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit ensureHighlighting$lambda$2(HoverListener this$0, AiPlaygroundInlayCollector this$1, long $stamp, List results) {
            void $this$mapTo$iv$iv;
            PsiElement psiElement = this$0.smartElement.getElement();
            if (psiElement == null) {
                return Unit.INSTANCE;
            }
            PsiElement element = psiElement;
            if (!this$1.isValidEditor(this$0.editor) || this$0.editor.getDocument().getModificationStamp() != $stamp || !element.isValid() || results.isEmpty()) {
                return Unit.INSTANCE;
            }
            this$1.cleanHighlightersIfAny(this$0.editor);
            Intrinsics.checkNotNull((Object)results);
            Iterable $this$map$iv = results;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AIPlaygroundHighlighter aIPlaygroundHighlighter = (AIPlaygroundHighlighter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this$0.editor.getMarkupModel().addRangeHighlighter(it.getTextAttributesKey(), it.getStartOffset(), it.getEndOffset(), it.getLayer(), it.getTargetArea()));
            }
            List highlighters = (List)destination$iv$iv;
            this$0.editor.putUserData(AiPlaygroundInlayHintsProviderKt.access$getAI_PLAYGROUND_HIGHLIGHTER_KEY$p(), (Object)highlighters);
            PlaygroundCollector.INSTANCE.logInlayHintHovered(this$0.editor);
            return Unit.INSTANCE;
        }

        private static final void ensureHighlighting$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

