/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.python;

import com.intellij.aiplayground.python.LooksLikeCode;
import com.intellij.aiplayground.python.PromptCandidateFilter;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.ml.models.PromptStringsModelHolder;
import com.jetbrains.mlapi.bundle.ModelPipelineLoader;
import com.jetbrains.mlapi.feature.FeatureDeclaration;
import com.jetbrains.mlapi.feature.PrimitiveFeatureDeclaration;
import com.jetbrains.mlapi.model.pipeline.ModelPipeline;
import com.jetbrains.mlapi.model.prediction.ClassesProbabilities;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/aiplayground/python/MLPromptStringsDetector;", "", "<init>", "()V", "modelPipeline", "Lcom/jetbrains/mlapi/model/pipeline/ModelPipeline;", "Lcom/jetbrains/mlapi/model/prediction/ClassesProbabilities;", "modelFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "loadModel", "", "containsPlaceholder", "", "t", "", "getPlaceholderPositions", "", "Lcom/intellij/aiplayground/python/MLPromptStringsDetector$PlaceholderPosition;", "looksLikeBibTex", "s", "looksLikeRegex", "looksLikeSystemPrompt", "looksLikeInstructionPrompt", "getContainingLinesText", "literal", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "isPromptHeuristics", "text", "isPromptHeuristicsFallback", "isPromptML", "detectPrompts", "Companion", "PlaceholderPosition", "intellij.aiplayground.python"})
@SourceDebugExtension(value={"SMAP\nMLPromptStringsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLPromptStringsDetector.kt\ncom/intellij/aiplayground/python/MLPromptStringsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n1834#2,4:181\n1834#2,4:185\n1807#2,3:189\n13#3:192\n*S KotlinDebug\n*F\n+ 1 MLPromptStringsDetector.kt\ncom/intellij/aiplayground/python/MLPromptStringsDetector\n*L\n95#1:181,4\n103#1:185,4\n106#1:189,3\n23#1:192\n*E\n"})
public final class MLPromptStringsDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile ModelPipeline<ClassesProbabilities> modelPipeline;
    @Nullable
    private CompletableFuture<Void> modelFuture;
    @NotNull
    private static final Logger LOG;
    private static final Pattern placeholderRe;
    private static final Pattern sysRe;
    private static final Pattern instrRe;
    @NotNull
    private static final PrimitiveFeatureDeclaration<String> inputStringFeature;

    public MLPromptStringsDetector() {
        this.loadModel();
    }

    private final void loadModel() {
        CompletableFuture<Void> completableFuture = this.modelFuture;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        LOG.info("Loading CatBoost JetEnry prompt strings detection model for AI Playground");
        ModelPipelineLoader modelPipelineLoader = ModelPipelineLoader.Companion.getDEFAULT();
        InputStream inputStream = PromptStringsModelHolder.getStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getStream(...)");
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        this.modelFuture = ((CompletableFuture)modelPipelineLoader.load(inputStream, executorService).thenAccept(arg_0 -> MLPromptStringsDetector.loadModel$lambda$1(arg_0 -> MLPromptStringsDetector.loadModel$lambda$0(this, arg_0), arg_0))).exceptionally(MLPromptStringsDetector::loadModel$lambda$2);
    }

    private final boolean containsPlaceholder(String t) {
        return placeholderRe.matcher(t).find();
    }

    @NotNull
    public final List<PlaceholderPosition> getPlaceholderPositions(@NotNull String t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Matcher matcher = placeholderRe.matcher(t);
        List placeholders = new ArrayList();
        while (matcher.find()) {
            placeholders.add(new PlaceholderPosition(matcher.start(), matcher.end()));
        }
        return placeholders;
    }

    private final boolean looksLikeBibTex(String s) {
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)s)).toString(), (String)"@", (boolean)false, (int)2, null)) {
            return true;
        }
        if (s.length() > 100 && StringsKt.lines((CharSequence)s).size() >= 3) {
            int n;
            String string = s.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String l = string;
            Object[] objectArray = new String[]{"title=", "author=", "journal=", "booktitle=", "year=", "doi="};
            List keys = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$count$iv = keys;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)l, (CharSequence)it, (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n >= 2;
        }
        return false;
    }

    private final boolean looksLikeRegex(String s) {
        int n;
        Object[] objectArray = new String[]{"\\\\d", "\\\\w", "\\\\s", "[", "]", "(?:", "(?=", "(?!", "(?P<", ".*", ".+", "$", "^", "|", "\\\\b", "\\\\B", "\\\\A", "\\\\Z"};
        List toks = CollectionsKt.listOf((Object[])objectArray);
        String string = s.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String l = string;
        Iterable $this$count$iv = toks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)l, (CharSequence)it, (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n >= 2;
    }

    private final boolean looksLikeSystemPrompt(String t) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = StringsKt.lines((CharSequence)t);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String s;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    char[] cArray = new char[]{'#', ' '};
                    Intrinsics.checkNotNullExpressionValue((Object)StringsKt.trimStart((String)it, (char[])cArray).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    if (!sysRe.matcher(s).lookingAt()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean looksLikeInstructionPrompt(String t) {
        String s = ((Object)StringsKt.trim((CharSequence)t)).toString();
        Matcher matcher = instrRe.matcher(s);
        int matchesCount = 0;
        while (matcher.find()) {
            if (++matchesCount <= 3) continue;
            return true;
        }
        return false;
    }

    private final String getContainingLinesText(PyStringLiteralExpression literal) {
        PsiFile psiFile = literal.getContainingFile();
        if (psiFile == null) {
            String string = literal.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        PsiFile file = psiFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            String string = literal.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        Document doc = document;
        int startOffset = literal.getTextRange().getStartOffset();
        int rawEndOffset = literal.getTextRange().getEndOffset();
        int endOffsetForLine = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)(rawEndOffset - 1), (int)0), (int)(doc.getTextLength() - 1));
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffsetForLine);
        int lineStart = doc.getLineStartOffset(startLine);
        int lineEnd = doc.getLineEndOffset(endLine);
        return ((Object)doc.getCharsSequence().subSequence(lineStart, lineEnd)).toString();
    }

    private final boolean isPromptHeuristics(String text) {
        return !this.looksLikeBibTex(text) && !this.looksLikeRegex(text) && !LooksLikeCode.INSTANCE.looksLikeCode(text);
    }

    private final boolean isPromptHeuristicsFallback(String text) {
        boolean isSystemPrompt = Registry.Companion.is("com.intellij.aiplayground.python.experimental.detect.system.prompts") ? this.looksLikeSystemPrompt(text) || this.looksLikeInstructionPrompt(text) : false;
        return this.containsPlaceholder(text) || isSystemPrompt;
    }

    private final boolean isPromptML(PyStringLiteralExpression literal) {
        String string = literal.getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        String content = string;
        ModelPipeline<ClassesProbabilities> m = this.modelPipeline;
        if (m == null) {
            return this.isPromptHeuristicsFallback(content);
        }
        String modelInput = this.getContainingLinesText(literal);
        ClassesProbabilities logits = (ClassesProbabilities)m.predict(CollectionsKt.listOf((Object)inputStringFeature.with(modelInput)));
        return ((Number)MapsKt.getValue(logits.getProbabilities(), (Object)"text")).doubleValue() > 0.5;
    }

    public final boolean detectPrompts(@NotNull PyStringLiteralExpression literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = literal.getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        String text = string;
        if (!this.isPromptHeuristics(text)) {
            return false;
        }
        if (!PromptCandidateFilter.INSTANCE.shouldKeep(literal)) {
            return false;
        }
        return this.isPromptML(literal);
    }

    private static final Unit loadModel$lambda$0(MLPromptStringsDetector this$0, ModelPipeline model) {
        LOG.info("Successfully loaded CatBoost JetEnry prompt strings detection model for AI Playground");
        this$0.modelPipeline = model.predictingClasses();
        return Unit.INSTANCE;
    }

    private static final void loadModel$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Void loadModel$lambda$2(Throwable e) {
        LOG.warn("Failed to load CatBoost JetEnry prompt strings detection model for AI Playground", e);
        return null;
    }

    @JvmStatic
    @NotNull
    public static final MLPromptStringsDetector getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MLPromptStringsDetector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        placeholderRe = Pattern.compile("(?<![{$])\\{[\\p{L}_][\\p{L}\\p{N}_]*}(?!})");
        Object[] objectArray = new String[]{"you are\\b", "you have\\b", "you should\\b", "as an ai\\b", "act as\\b", "assistant[,:]?\\b", "answer (only|solely)\\b", "please\\b", "human[: ]", "system[: ]", "remember\\b", "question\\b", "i need\\b", "tell me\\b", "you function\\b", "show me\\b"};
        sysRe = Pattern.compile(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null), 2);
        instrRe = Pattern.compile("\\b(write|generate|create|explain|describe|summarize|translate|answer|provide|return|output|list|classify|convert|give|determine|identify|respond|rate|assess|compare|solve|edit|get|rephrase|replace)\\b", 2);
        inputStringFeature = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, "input_string", null, null, 6, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/aiplayground/python/MLPromptStringsDetector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "placeholderRe", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "sysRe", "instrRe", "inputStringFeature", "Lcom/jetbrains/mlapi/feature/PrimitiveFeatureDeclaration;", "", "getInstance", "Lcom/intellij/aiplayground/python/MLPromptStringsDetector;", "intellij.aiplayground.python"})
    @SourceDebugExtension(value={"SMAP\nMLPromptStringsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLPromptStringsDetector.kt\ncom/intellij/aiplayground/python/MLPromptStringsDetector$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,180:1\n42#2,3:181\n*S KotlinDebug\n*F\n+ 1 MLPromptStringsDetector.kt\ncom/intellij/aiplayground/python/MLPromptStringsDetector$Companion\n*L\n47#1:181,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MLPromptStringsDetector getInstance() {
            boolean $i$f$service = false;
            Class<MLPromptStringsDetector> serviceClass$iv = MLPromptStringsDetector.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MLPromptStringsDetector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/aiplayground/python/MLPromptStringsDetector$PlaceholderPosition;", "", "start", "", "end", "<init>", "(II)V", "getStart", "()I", "getEnd", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.aiplayground.python"})
    public static final class PlaceholderPosition {
        private final int start;
        private final int end;

        public PlaceholderPosition(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final PlaceholderPosition copy(int start, int end) {
            return new PlaceholderPosition(start, end);
        }

        public static /* synthetic */ PlaceholderPosition copy$default(PlaceholderPosition placeholderPosition, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = placeholderPosition.start;
            }
            if ((n3 & 2) != 0) {
                n2 = placeholderPosition.end;
            }
            return placeholderPosition.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "PlaceholderPosition(start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlaceholderPosition)) {
                return false;
            }
            PlaceholderPosition placeholderPosition = (PlaceholderPosition)other;
            if (this.start != placeholderPosition.start) {
                return false;
            }
            return this.end == placeholderPosition.end;
        }
    }
}

