/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.python;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/aiplayground/python/PromptCandidateFilter;", "", "<init>", "()V", "Q_CHARS", "", "", "URL_RE", "Lkotlin/text/Regex;", "IDENT_RE", "FNAME_RE", "REGEX_RE", "proportionAlpha", "", "s", "", "hasQ", "", "noWhitespace", "keepTextPythonParity", "isUnderAssert", "literal", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "isUnderRaise", "LOG_NAMES", "isInLoggingCall", "isInPrintCall", "shouldKeep", "intellij.aiplayground.python"})
@SourceDebugExtension(value={"SMAP\nPromptCandidateFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptCandidateFilter.kt\ncom/intellij/aiplayground/python/PromptCandidateFilter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,113:1\n1123#2,3:114\n1107#2,2:117\n1874#2,2:119\n1276#3,2:121\n1276#3,2:123\n184#3,2:125\n184#3,2:127\n*S KotlinDebug\n*F\n+ 1 PromptCandidateFilter.kt\ncom/intellij/aiplayground/python/PromptCandidateFilter\n*L\n29#1:114,3\n33#1:117,2\n35#1:119,2\n74#1:121,2\n77#1:123,2\n85#1:125,2\n93#1:127,2\n*E\n"})
public final class PromptCandidateFilter {
    @NotNull
    public static final PromptCandidateFilter INSTANCE = new PromptCandidateFilter();
    @NotNull
    private static final Set<Character> Q_CHARS;
    @NotNull
    private static final Regex URL_RE;
    @NotNull
    private static final Regex IDENT_RE;
    @NotNull
    private static final Regex FNAME_RE;
    @NotNull
    private static final Regex REGEX_RE;
    @NotNull
    private static final Set<String> LOG_NAMES;

    private PromptCandidateFilter() {
    }

    private final double proportionAlpha(String s) {
        if (((CharSequence)s).length() == 0) {
            return 0.0;
        }
        CharSequence $this$count$iv = s;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!Character.isLetter(it)) continue;
            ++count$iv;
        }
        int alpha = count$iv;
        return (double)alpha / (double)s.length();
    }

    private final boolean hasQ(String s) {
        boolean bl;
        block1: {
            CharSequence $this$any$iv = s;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!Q_CHARS.contains(Character.valueOf(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean noWhitespace(String s) {
        boolean bl;
        block1: {
            CharSequence $this$none$iv = s;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final boolean keepTextPythonParity(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String trimmed = ((Object)StringsKt.trim((CharSequence)s)).toString();
        if (s.length() <= 12 && !this.hasQ(s)) {
            return false;
        }
        if (this.proportionAlpha(s) < 0.4) {
            return false;
        }
        if (URL_RE.matches((CharSequence)s)) {
            return false;
        }
        if (FNAME_RE.matches((CharSequence)trimmed)) {
            return false;
        }
        if (StringsKt.contains$default((CharSequence)s, (char)'_', (boolean)false, (int)2, null) && IDENT_RE.matches((CharSequence)trimmed)) {
            return false;
        }
        if (this.noWhitespace(s)) {
            return false;
        }
        return !REGEX_RE.containsMatchIn((CharSequence)s);
    }

    private final boolean isUnderAssert(PyStringLiteralExpression literal) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)literal, PromptCandidateFilter::isUnderAssert$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PyAssertStatement)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isUnderRaise(PyStringLiteralExpression literal) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)literal, PromptCandidateFilter::isUnderRaise$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PyRaiseStatement)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInLoggingCall(PyStringLiteralExpression literal) {
        String string;
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            Sequence sequence = SequencesKt.generateSequence((Object)literal, PromptCandidateFilter::isInLoggingCall$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PyCallExpression)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Object var4_8 = v0;
        PyCallExpression pyCallExpression = var4_8 instanceof PyCallExpression ? (PyCallExpression)var4_8 : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression callee = call.getCallee();
        Object object = callee instanceof PyQualifiedExpression ? (PyQualifiedExpression)callee : null;
        if (object != null && (object = object.getReferencedName()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String name = string;
        return name != null && LOG_NAMES.contains(name);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInPrintCall(PyStringLiteralExpression literal) {
        Object v0;
        Sequence sequence;
        block2: {
            void $this$firstOrNull$iv;
            sequence = SequencesKt.generateSequence((Object)literal, PromptCandidateFilter::isInPrintCall$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PyCallExpression)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object var4_8 = v0;
        PyCallExpression pyCallExpression = var4_8 instanceof PyCallExpression ? (PyCallExpression)var4_8 : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        sequence = call.getCallee();
        PyReferenceExpression pyReferenceExpression = sequence instanceof PyReferenceExpression ? (PyReferenceExpression)sequence : null;
        String calleeName = pyReferenceExpression != null ? pyReferenceExpression.getReferencedName() : null;
        return Intrinsics.areEqual((Object)calleeName, (Object)"print");
    }

    public final boolean shouldKeep(@NotNull PyStringLiteralExpression literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = literal.getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        if (!this.keepTextPythonParity(string)) {
            return false;
        }
        if (this.isUnderAssert(literal)) {
            return false;
        }
        if (this.isUnderRaise(literal)) {
            return false;
        }
        if (this.isInLoggingCall(literal)) {
            return false;
        }
        return !this.isInPrintCall(literal);
    }

    private static final PsiElement isUnderAssert$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final PsiElement isUnderRaise$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final PsiElement isInLoggingCall$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final PsiElement isInPrintCall$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('?'), Character.valueOf('\uff1f')};
        Q_CHARS = SetsKt.setOf((Object[])objectArray);
        URL_RE = new Regex("^\\s*(https?|ftp)://\\S+\\s*$", RegexOption.IGNORE_CASE);
        IDENT_RE = new Regex("^[A-Za-z_][A-Za-z0-9_]*$");
        FNAME_RE = new Regex("^[A-Za-z0-9_.-]+\\.[A-Za-z0-9]{1,7}$");
        REGEX_RE = new Regex("\\\\\\\\[dwsDWS]|\\[\\^?.+?]|\\(\\??[:=!]|\\(\\?P<|\\{[0-9]+(,[0-9]*)?}|\\.\\*|\\.\\+|\\$|\\^|\\||\\\\\\\\[bBAZ]");
        objectArray = new String[]{"debug", "info", "warning", "warn", "error", "critical", "exception", "fatal"};
        LOG_NAMES = SetsKt.setOf((Object[])objectArray);
    }
}

