/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/XDebuggerBackendOnlyActionHandler;", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "<init>", "()V", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Experimental
public abstract class XDebuggerBackendOnlyActionHandler
extends DebuggerActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public final boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (SplitDebuggerMode.showSplitWarnings() && FrontendApplicationInfo.INSTANCE.getFrontendType() instanceof FrontendType.Remote) {
            LOG.error("XDebuggerBackendOnlyActionHandler should only be used for backend-only actions. If your action operates on the frontend, use XDebuggerActionHandler instead.");
        }
        XDebugSession xDebugSession = DebuggerUIUtil.getSession(event);
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession session = xDebugSession;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return this.isEnabled(session, dataContext);
    }

    public final void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        XDebugSession xDebugSession = DebuggerUIUtil.getSession(event);
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.perform(session, dataContext);
    }

    public abstract boolean isEnabled(@NotNull XDebugSession var1, @NotNull DataContext var2);

    public abstract void perform(@NotNull XDebugSession var1, @NotNull DataContext var2);

    static {
        Logger logger = Logger.getInstance(XDebuggerBackendOnlyActionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/XDebuggerBackendOnlyActionHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

