/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/data/VcsUserKeyDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Lcom/intellij/vcs/log/VcsUser;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "<init>", "(Lcom/intellij/vcs/log/VcsUserRegistry;)V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "in", "Ljava/io/DataInput;", "getHashCode", "", "isEqual", "", "val1", "val2", "intellij.platform.vcs.log.impl"})
public final class VcsUserKeyDescriptor
implements KeyDescriptor<VcsUser> {
    @NotNull
    private final VcsUserRegistry userRegistry;

    public VcsUserKeyDescriptor(@NotNull VcsUserRegistry userRegistry) {
        Intrinsics.checkNotNullParameter((Object)userRegistry, (String)"userRegistry");
        this.userRegistry = userRegistry;
    }

    public void save(@NotNull DataOutput out, @NotNull VcsUser value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IOUtil.writeUTF((DataOutput)out, (String)value.getName());
        IOUtil.writeUTF((DataOutput)out, (String)value.getEmail());
    }

    @NotNull
    public VcsUser read(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        String name = IOUtil.readUTF((DataInput)in);
        String email = IOUtil.readUTF((DataInput)in);
        VcsUser vcsUser = this.userRegistry.createUser(name, email);
        Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"createUser(...)");
        return vcsUser;
    }

    public int getHashCode(@NotNull VcsUser value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.hashCode();
    }

    public boolean isEqual(@Nullable VcsUser val1, @Nullable VcsUser val2) {
        return Intrinsics.areEqual((Object)val1, (Object)val2);
    }
}

