/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPortHandler;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortListeningOptions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.PortForwardingProcessWatcher;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.ptr.IntByReference;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/WindowsPortForwardingProcessWatcher;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher;", "pid", "", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "options", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "<init>", "(JLcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;)V", "getPortsOfPids", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "pids", "Companion", "intellij.platform.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWindowsPortForwardingProcessWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsPortForwardingProcessWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/WindowsPortForwardingProcessWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class WindowsPortForwardingProcessWatcher
extends PortForwardingProcessWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger = PortForwardingProcessWatcher.getLogger();

    public WindowsPortForwardingProcessWatcher(long pid, @NotNull ListeningPortHandler handler, @NotNull PortListeningOptions options) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        super(pid, handler, options);
        if (!SystemInfoRt.isWindows) {
            boolean bl = false;
            String string = "WindowsPortForwardingProcessWatcher called not on Windows. This is a programming error";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    protected Set<ListeningPort> getPortsOfPids(@NotNull Set<Long> pids) {
        Intrinsics.checkNotNullParameter(pids, (String)"pids");
        IntByReference sizePtr = new IntByReference();
        WindowsPortForwardingProcessWatcher $this$getPortsOfPids_u24lambda_u240 = this;
        boolean bl = false;
        int retCode = IPHlpAPI.INSTANCE.GetExtendedTcpTable(null, sizePtr, false, 2, 3, 0);
        switch (retCode) {
            case 122: {
                break;
            }
            case 87: {
                logger.error("Invalid parameter(s) was passed to GetExtendedTcpTable.");
                return new LinkedHashSet();
            }
            default: {
                logger.warn("Unexpected return code from GetExtendedTcpTable. " + retCode);
            }
        }
        int size = 0;
        Memory buf = null;
        do {
            size = sizePtr.getValue();
            buf = new Memory((long)size);
            int retCode2 = IPHlpAPI.INSTANCE.GetExtendedTcpTable((Pointer)buf, sizePtr, false, 2, 3, 0);
            switch (retCode2) {
                case 122: {
                    break;
                }
                case 87: {
                    logger.error("Invalid parameter(s) was passed to GetExtendedTcpTable.");
                    return new LinkedHashSet();
                }
                case 0: {
                    break;
                }
                default: {
                    logger.warn("Unexpected return code from GetExtendedTcpTable. " + retCode2);
                }
            }
        } while (size < sizePtr.getValue());
        IPHlpAPI.MIB_TCPTABLE_OWNER_PID tcpTable = new IPHlpAPI.MIB_TCPTABLE_OWNER_PID((Pointer)buf);
        Set result2 = new LinkedHashSet();
        int n = tcpTable.dwNumEntries;
        for (int i = 0; i < n; ++i) {
            IPHlpAPI.MIB_TCPROW_OWNER_PID row = tcpTable.table[i];
            try {
                long pid = row.dwOwningPid;
                if (!pids.contains(pid)) continue;
                int localAddressRaw = row.dwLocalAddr;
                byte[] localAddressBytes = ByteBuffer.allocate(4).putInt(localAddressRaw).array();
                if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                    byte[] byArray = localAddressBytes;
                    Intrinsics.checkNotNull((Object)byArray);
                    localAddressBytes = ArraysKt.reversedArray((byte[])byArray);
                }
                InetAddress localAddress = Inet4Address.getByAddress(localAddressBytes);
                int localPortRaw = row.dwLocalPort;
                byte[] localPortBytes = ByteBuffer.allocate(4).putInt(localPortRaw).array();
                if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                    byte[] byArray = localPortBytes;
                    Intrinsics.checkNotNull((Object)byArray);
                    localPortBytes = ArraysKt.reversedArray((byte[])byArray);
                }
                int n2 = UByte.constructor-impl((byte)localPortBytes[0]);
                int n3 = 256;
                n2 = UInt.constructor-impl((int)(UInt.constructor-impl((int)(n2 & 0xFF)) * n3));
                n3 = UByte.constructor-impl((byte)localPortBytes[1]);
                int localPort = UInt.constructor-impl((int)(n2 + UInt.constructor-impl((int)(n3 & 0xFF))));
                result2.add(new ListeningPort(new InetSocketAddress(localAddress.getHostAddress(), localPort), PortType.TCP, pid));
                continue;
            }
            catch (Exception e) {
                logger.warn("Failed to parse one tcp row. '" + row + "'", (Throwable)e);
            }
        }
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/WindowsPortForwardingProcessWatcher$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

