/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.cef;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.RdCefBrowser;
import com.jetbrains.rd.ide.model.RdCefCommand;
import com.jetbrains.rd.ide.model.RdCefEvent;
import com.jetbrains.rd.ide.model.RdCefExecuteJavaScriptCommand;
import com.jetbrains.rd.ide.model.RdCefLoadUrlCommand;
import com.jetbrains.rd.ide.model.RdCefOnBeforeBrowseEvent;
import com.jetbrains.rd.ide.model.RdCefOnLoadEndEvent;
import com.jetbrains.rd.ide.model.RdCefOnLoadErrorEvent;
import com.jetbrains.rd.ide.model.RdCefOnLoadStartEvent;
import com.jetbrains.rd.ide.model.RdCefOnLoadingStateChangeEvent;
import com.jetbrains.rd.ide.model.RdCefReloadCommand;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.platform.util.ThreadSafeProperty;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import com.jetbrains.rdserver.cef.BackendCefBrowserKt;
import com.jetbrains.rdserver.cef.BackendCefClient;
import com.jetbrains.rdserver.cef.BackendCefFrameKt;
import com.jetbrains.rdserver.cef.BackendCefHost;
import com.jetbrains.rdserver.cef.BackendCefMessageRouterBridge;
import com.jetbrains.rdserver.cef.BackendCefRequestContext;
import com.jetbrains.rdserver.cef.BackendCefRequestKt;
import com.jetbrains.rdserver.cef.BackendCefResourceBridge;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.input.CefCompositionUnderline;
import org.cef.input.CefTouchEvent;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002\u00a2\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0012J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\tH\u0007J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0006\u0010'\u001a\u00020\u0012J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020\u001eJ\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u001eH\u0016J\b\u00104\u001a\u00020\u0012H\u0016J\b\u00105\u001a\u00020\u001eH\u0016J\b\u00106\u001a\u00020\u0012H\u0016J\b\u00107\u001a\u00020\u001eH\u0016J\b\u00108\u001a\u00020\u001eH\u0016J\b\u00109\u001a\u00020\u001eH\u0016J\b\u0010:\u001a\u00020\tH\u0016J\n\u0010;\u001a\u0004\u0018\u00010<H\u0016J\n\u0010=\u001a\u0004\u0018\u00010<H\u0016J\u0014\u0010>\u001a\u0004\u0018\u00010<2\b\u0010?\u001a\u0004\u0018\u00010\u0005H\u0016J\u0014\u0010@\u001a\u0004\u0018\u00010<2\b\u0010A\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050CH\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050CH\u0016J\b\u0010E\u001a\u00020\tH\u0016J\b\u0010F\u001a\u00020\u0012H\u0016J\b\u0010G\u001a\u00020\u0012H\u0016J\b\u0010H\u001a\u00020\u001eH\u0016J\u0012\u0010I\u001a\u00020\u001e2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016J\u0012\u0010L\u001a\u00020\u001e2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016J\u0012\u0010M\u001a\u00020\u001e2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010S\u001a\u00020\tH\u0016J\b\u0010T\u001a\u00020\u0005H\u0016J\b\u0010U\u001a\u00020\u001eH\u0016J\b\u0010V\u001a\u00020\u0012H\u0016J\b\u0010W\u001a\u00020\u001eH\u0016J\b\u0010X\u001a\u00020\u0012H\u0016J\b\u0010Y\u001a\u00020\u0012H\u0016J\u0010\u0010Z\u001a\u00020\u001e2\u0006\u0010[\u001a\u00020\u0012H\u0016J\u0010\u0010\\\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020\u0012H\u0016J\b\u0010^\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020\u001e2\u0006\u0010a\u001a\u00020_H\u0016J@\u0010b\u001a\u00020\u001e2\b\u0010c\u001a\u0004\u0018\u00010d2\b\u0010e\u001a\u0004\u0018\u00010\u00052\b\u0010f\u001a\u0004\u0018\u00010\u00052\u000e\u0010g\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010C2\b\u0010h\u001a\u0004\u0018\u00010iH\u0016J\u0012\u0010j\u001a\u00020\u001e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010k\u001a\u00020\u001eH\u0016J&\u0010l\u001a\u00020\u001e2\b\u0010m\u001a\u0004\u0018\u00010\u00052\b\u0010n\u001a\u0004\u0018\u00010o2\b\u0010h\u001a\u0004\u0018\u00010pH\u0016J*\u0010q\u001a\u00020\u001e2\b\u0010r\u001a\u0004\u0018\u00010\u00052\u0006\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u00122\u0006\u0010u\u001a\u00020\u0012H\u0016J\u0010\u0010v\u001a\u00020\u001e2\u0006\u0010w\u001a\u00020\u0012H\u0016J\b\u0010x\u001a\u00020\u001eH\u0016J\u0012\u0010x\u001a\u00020\u001e2\b\u0010y\u001a\u0004\u0018\u00010zH\u0016J\b\u0010{\u001a\u00020|H\u0016J\u0012\u0010}\u001a\u00020\u001e2\b\u0010~\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u007f\u001a\u00020\u001e2\u0007\u0010\u0080\u0001\u001a\u00020\t2\u0007\u0010\u0081\u0001\u001a\u00020\tH\u0016J\t\u0010\u0082\u0001\u001a\u00020\u001eH\u0016J\t\u0010\u0083\u0001\u001a\u00020\u001eH\u0016J\u0015\u0010\u0084\u0001\u001a\u00020\u001e2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0016J\u0015\u0010\u0087\u0001\u001a\u00020\u001e2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0016J\u0015\u0010\u0089\u0001\u001a\u00020\u001e2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0016J\u0015\u0010\u008b\u0001\u001a\u00020\u001e2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u008c\u0001H\u0016J\u001a\u0010\u008d\u0001\u001a\n\u0012\u0005\u0012\u00030\u008f\u00010\u008e\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u0012H\u0016J?\u0010\u0091\u0001\u001a\u00020\u001e2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00052\u0011\u0010\u0093\u0001\u001a\f\u0012\u0005\u0012\u00030\u0095\u0001\u0018\u00010\u0094\u00012\n\u0010\u0096\u0001\u001a\u0005\u0018\u00010\u0097\u00012\n\u0010\u0098\u0001\u001a\u0005\u0018\u00010\u0097\u0001H\u0016J)\u0010\u0099\u0001\u001a\u00020\u001e2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00052\n\u0010\u0096\u0001\u001a\u0005\u0018\u00010\u0097\u00012\u0007\u0010\u009a\u0001\u001a\u00020\tH\u0016J\u0012\u0010\u009b\u0001\u001a\u00020\u001e2\u0007\u0010\u009c\u0001\u001a\u00020\u0012H\u0016J\t\u0010\u009d\u0001\u001a\u00020\u001eH\u0016J\u0012\u0010\u009e\u0001\u001a\u00020\u001e2\u0007\u0010\u009f\u0001\u001a\u00020\tH\u0016J\u0010\u0010\u00a0\u0001\u001a\t\u0012\u0004\u0012\u00020\t0\u008e\u0001H\u0016J\t\u0010\u00a1\u0001\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/jetbrains/rdserver/cef/BackendCefBrowser;", "Lorg/cef/browser/CefBrowser;", "client", "Lcom/jetbrains/rdserver/cef/BackendCefClient;", "url", "", "<init>", "(Lcom/jetbrains/rdserver/cef/BackendCefClient;Ljava/lang/String;)V", "id", "", "state", "Lcom/jetbrains/rdserver/cef/BackendCefBrowser$State;", "_lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component", "Ljavax/swing/JPanel;", "Lcom/jetbrains/rd/platform/util/ThreadSafeProperty;", "navigationDisabled", "", "command", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/jetbrains/rd/ide/model/RdCefCommand;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "toModel", "Lcom/jetbrains/rd/ide/model/RdCefBrowser;", "createImmediately", "bindBackgroundColor", "", "model", "handleEvent", "event", "Lcom/jetbrains/rd/ide/model/RdCefEvent;", "bindIfNeeded", "close", "force", "closeDevTools", "isInitialized", "getUIComponent", "Ljava/awt/Component;", "getClient", "getRequestContext", "Lorg/cef/browser/CefRequestContext;", "disableNavigation", "getRenderHandler", "Lorg/cef/handler/CefRenderHandler;", "getWindowHandler", "Lorg/cef/handler/CefWindowHandler;", "canGoBack", "goBack", "canGoForward", "goForward", "isLoading", "reload", "reloadIgnoreCache", "stopLoad", "getIdentifier", "getMainFrame", "Lorg/cef/browser/CefFrame;", "getFocusedFrame", "getFrameByIdentifier", "identifier", "getFrameByName", "name", "getFrameIdentifiers", "Ljava/util/Vector;", "getFrameNames", "getFrameCount", "isPopup", "hasDocument", "viewSource", "getSource", "visitor", "Lorg/cef/callback/CefStringVisitor;", "getText", "loadRequest", "request", "Lorg/cef/network/CefRequest;", "loadURL", "executeJavaScript", "code", "line", "getURL", "setCloseAllowed", "doClose", "onBeforeClose", "isClosing", "isClosed", "setFocus", "enable", "setWindowVisibility", "visible", "getZoomLevel", "", "setZoomLevel", "zoomLevel", "runFileDialog", "mode", "Lorg/cef/handler/CefDialogHandler$FileDialogMode;", "title", "defaultFilePath", "acceptFilters", "callback", "Lorg/cef/callback/CefRunFileDialogCallback;", "startDownload", "print", "printToPDF", "path", "settings", "Lorg/cef/misc/CefPdfPrintSettings;", "Lorg/cef/callback/CefPdfPrintCallback;", "find", "searchText", "forward", "matchCase", "findNext", "stopFinding", "clearSelection", "openDevTools", "inspectAt", "Ljava/awt/Point;", "getDevToolsClient", "Lorg/cef/browser/CefDevToolsClient;", "replaceMisspelling", "word", "wasResized", "width", "height", "invalidate", "notifyScreenInfoChanged", "sendKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "sendMouseEvent", "Ljava/awt/event/MouseEvent;", "sendMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "sendTouchEvent", "Lorg/cef/input/CefTouchEvent;", "createScreenshot", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "nativeResolution", "ImeSetComposition", "text", "underlines", "", "Lorg/cef/input/CefCompositionUnderline;", "replacementRange", "Lorg/cef/misc/CefRange;", "selectionRange", "ImeCommitText", "relativeCursorPos", "ImeFinishComposingText", "keepSelection", "ImeCancelComposing", "setWindowlessFrameRate", "frameRate", "getWindowlessFrameRate", "isWindowless", "State", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendCefBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCefBrowser.kt\ncom/jetbrains/rdserver/cef/BackendCefBrowser\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,436:1\n42#2,3:437\n*S KotlinDebug\n*F\n+ 1 BackendCefBrowser.kt\ncom/jetbrains/rdserver/cef/BackendCefBrowser\n*L\n114#1:437,3\n*E\n"})
public final class BackendCefBrowser
implements CefBrowser {
    @NotNull
    private final BackendCefClient client;
    private volatile int id;
    @NotNull
    private volatile State state;
    @NotNull
    private final LifetimeDefinition _lifetime;
    @NotNull
    private final JPanel component;
    @NotNull
    private final ThreadSafeProperty<String> url;
    @NotNull
    private final ThreadSafeProperty<Boolean> navigationDisabled;
    @NotNull
    private final Signal<RdCefCommand> command;

    public BackendCefBrowser(@NotNull BackendCefClient client, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.client = client;
        this.id = -1;
        this.state = State.CREATED;
        this._lifetime = new LifetimeDefinition();
        this.component = new JPanel();
        this.url = new ThreadSafeProperty((Object)url);
        this.navigationDisabled = new ThreadSafeProperty((Object)false);
        this.command = new Signal();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return (Lifetime)this._lifetime;
    }

    @NotNull
    public final RdCefBrowser toModel(@NotNull Lifetime lifetime, boolean createImmediately) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        BackendCefMessageRouterBridge routerBridge = new BackendCefMessageRouterBridge(this);
        RdCefBrowser modelBrowser = new RdCefBrowser(routerBridge.getModelRouters(), createImmediately);
        this.bindBackgroundColor(lifetime, modelBrowser);
        SingleThreadScheduler eventScheduler = new SingleThreadScheduler(lifetime, "RD JCEF event scheduler");
        SourceExKt.flowInto((ISource)((ISource)this.url), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)modelBrowser.getUrl()));
        new BackendCefResourceBridge(modelBrowser).handleResourceRequests(this);
        SourceExKt.flowInto((ISource)((ISource)this.command), (Lifetime)lifetime, (ISignal)((ISignal)modelBrowser.getCommand()));
        SourceExKt.flowInto((ISource)((ISource)this.navigationDisabled), (Lifetime)lifetime, (IMutablePropertyBase)((IMutablePropertyBase)modelBrowser.getNavigationDisabled()));
        modelBrowser.getEvent().adviseOn(lifetime, (IScheduler)eventScheduler, (Function1)new Function1<RdCefEvent, Unit>((Object)this){

            public final void invoke(RdCefEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                BackendCefBrowser.access$handleEvent((BackendCefBrowser)this.receiver, p0);
            }
        });
        routerBridge.handleQueries(modelBrowser, (IScheduler)eventScheduler);
        return modelBrowser;
    }

    private final void bindBackgroundColor(Lifetime lifetime, RdCefBrowser model2) {
        PropertyChangeListener propChangeListener = arg_0 -> BackendCefBrowser.bindBackgroundColor$lambda$1(this, model2, arg_0);
        lifetime.bracketIfAlive(() -> BackendCefBrowser.bindBackgroundColor$lambda$2(this, propChangeListener), () -> BackendCefBrowser.bindBackgroundColor$lambda$3(this, propChangeListener));
        BackendCefBrowser.bindBackgroundColor$reportBackground(this, model2);
    }

    private final void handleEvent(RdCefEvent event) {
        RdCefEvent rdCefEvent = event;
        if (rdCefEvent instanceof RdCefOnLoadingStateChangeEvent) {
            this.client.onLoadingStateChange(this, ((RdCefOnLoadingStateChangeEvent)event).isLoading(), ((RdCefOnLoadingStateChangeEvent)event).getCanGoBack(), ((RdCefOnLoadingStateChangeEvent)event).getCanGoForward());
        } else if (rdCefEvent instanceof RdCefOnLoadStartEvent) {
            this.client.onLoadStart(this, BackendCefFrameKt.fromModel(((RdCefOnLoadStartEvent)event).getFrame()), BackendCefBrowserKt.access$toCefTransitionType(((RdCefOnLoadStartEvent)event).getTransitionType()));
        } else if (rdCefEvent instanceof RdCefOnLoadEndEvent) {
            this.client.onLoadEnd(this, BackendCefFrameKt.fromModel(((RdCefOnLoadEndEvent)event).getFrame()), ((RdCefOnLoadEndEvent)event).getHttpStatusCode());
        } else if (rdCefEvent instanceof RdCefOnLoadErrorEvent) {
            this.client.onLoadError(this, BackendCefFrameKt.fromModel(((RdCefOnLoadErrorEvent)event).getFrame()), CefLoadHandler.ErrorCode.findByCode((int)((RdCefOnLoadErrorEvent)event).getErrorCode()), ((RdCefOnLoadErrorEvent)event).getErrorText(), ((RdCefOnLoadErrorEvent)event).getFailedUrl());
        } else if (rdCefEvent instanceof RdCefOnBeforeBrowseEvent) {
            boolean bl;
            boolean it = bl = this.client.onBeforeBrowse(this, BackendCefFrameKt.fromModel(((RdCefOnBeforeBrowseEvent)event).getFrame()), BackendCefRequestKt.fromModel(((RdCefOnBeforeBrowseEvent)event).getRequest()), ((RdCefOnBeforeBrowseEvent)event).getUserGesture(), ((RdCefOnBeforeBrowseEvent)event).isRedirect());
            boolean bl2 = false;
            if (it) {
                BackendCefBrowserKt.access$getLOG$p().warn("Preventing navigation via CefRequestHandler.onBeforeBrowse isn't supported on backend");
            }
        }
    }

    @RequiresEdt
    public final int bindIfNeeded() {
        return this.bindIfNeeded(false);
    }

    private final int bindIfNeeded(boolean createImmediately) {
        if (this.id < 0 && this.state != State.CLOSED) {
            boolean $i$f$service = false;
            Class<BackendCefHost> serviceClass$iv = BackendCefHost.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Pair<Integer, Lifetime> pair = ((BackendCefHost)object).bind(this, createImmediately);
            if (pair != null) {
                Pair<Integer, Lifetime> pair2 = pair;
                boolean bl = false;
                int newId = ((Number)pair2.component1()).intValue();
                Lifetime newIdLifetime = (Lifetime)pair2.component2();
                Unit cfr_ignored_0 = (Unit)newIdLifetime.bracketIfAlive(() -> BackendCefBrowser.bindIfNeeded$lambda$0$0(this, newId), () -> BackendCefBrowser.bindIfNeeded$lambda$0$1(this));
            }
            if (this.state == State.CREATED) {
                this.state = State.INITIALIZED;
                this.client.onAfterCreated(this);
            }
        }
        return this.id;
    }

    public void createImmediately() {
        UIUtil.invokeLaterIfNeeded(() -> BackendCefBrowser.createImmediately$lambda$0(this));
    }

    public void close(boolean force) {
        UIUtil.invokeLaterIfNeeded(() -> BackendCefBrowser.close$lambda$0(this));
    }

    public void closeDevTools() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: closeDevTools");
    }

    public final boolean isInitialized() {
        return this.state != State.CREATED;
    }

    @NotNull
    public Component getUIComponent() {
        return this.component;
    }

    @NotNull
    public BackendCefClient getClient() {
        return this.client;
    }

    @NotNull
    public CefRequestContext getRequestContext() {
        return BackendCefRequestContext.Companion.getINSTANCE();
    }

    public final void disableNavigation() {
        this.navigationDisabled.set((Object)true);
    }

    @Nullable
    public CefRenderHandler getRenderHandler() {
        return null;
    }

    @Nullable
    public CefWindowHandler getWindowHandler() {
        return null;
    }

    public boolean canGoBack() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: canGoBack");
        return false;
    }

    public void goBack() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: goBack");
    }

    public boolean canGoForward() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: canGoForward");
        return false;
    }

    public void goForward() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: goForward");
    }

    public boolean isLoading() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: isLoading");
        return false;
    }

    public void reload() {
        this.command.fire((Object)new RdCefReloadCommand());
    }

    public void reloadIgnoreCache() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: reloadIgnoreCache");
    }

    public void stopLoad() {
    }

    public int getIdentifier() {
        return this.id;
    }

    @Nullable
    public CefFrame getMainFrame() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getMainFrame");
        return null;
    }

    @Nullable
    public CefFrame getFocusedFrame() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getFocusedFrame");
        return null;
    }

    @Nullable
    public CefFrame getFrameByIdentifier(@Nullable String identifier) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getFrameByIdentifier");
        return null;
    }

    @Nullable
    public CefFrame getFrameByName(@Nullable String name) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: GetFrameByName");
        return null;
    }

    @NotNull
    public Vector<String> getFrameIdentifiers() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getFrameIdentifiers");
        return new Vector<String>();
    }

    @NotNull
    public Vector<String> getFrameNames() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getFrameNames");
        return new Vector<String>();
    }

    public int getFrameCount() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getFrameCount");
        return 0;
    }

    public boolean isPopup() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: gisPopup");
        return false;
    }

    public boolean hasDocument() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: hasDocument");
        return false;
    }

    public void viewSource() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: viewSource");
    }

    public void getSource(@Nullable CefStringVisitor visitor) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getSource");
    }

    public void getText(@Nullable CefStringVisitor visitor) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getText");
    }

    public void loadRequest(@Nullable CefRequest request) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: loadRequest");
    }

    public void loadURL(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url.set((Object)url);
        this.command.fire((Object)new RdCefLoadUrlCommand());
    }

    public void executeJavaScript(@NotNull String code, @Nullable String url, int line) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.command.fire((Object)new RdCefExecuteJavaScriptCommand(code, url, line));
    }

    @NotNull
    public String getURL() {
        return (String)this.url.getValue();
    }

    public void setCloseAllowed() {
    }

    public boolean doClose() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: doClose");
        return false;
    }

    public void onBeforeClose() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: onBeforeClose");
    }

    public boolean isClosing() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: isClosing");
        return false;
    }

    public boolean isClosed() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: isClosed");
        return false;
    }

    public void setFocus(boolean enable) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: setFocus");
    }

    public void setWindowVisibility(boolean visible) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: setWindowVisibility");
    }

    public double getZoomLevel() {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    public void setZoomLevel(double zoomLevel) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: setZoomLevel");
    }

    public void runFileDialog(@Nullable CefDialogHandler.FileDialogMode mode, @Nullable String title, @Nullable String defaultFilePath, @Nullable Vector<String> acceptFilters, @Nullable CefRunFileDialogCallback callback2) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: runFileDialog");
    }

    public void startDownload(@Nullable String url) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: startDownload");
    }

    public void print() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: print");
    }

    public void printToPDF(@Nullable String path, @Nullable CefPdfPrintSettings settings, @Nullable CefPdfPrintCallback callback2) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: printToPDF");
    }

    public void find(@Nullable String searchText, boolean forward, boolean matchCase, boolean findNext) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: find");
    }

    public void stopFinding(boolean clearSelection) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: stopFinding");
    }

    public void openDevTools() {
        this.openDevTools(null);
    }

    public void openDevTools(@Nullable Point inspectAt) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: getDevTools");
    }

    @NotNull
    public CefDevToolsClient getDevToolsClient() {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    public void replaceMisspelling(@Nullable String word) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: replaceMisspelling");
    }

    public void wasResized(int width, int height) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: wasResized");
    }

    public void invalidate() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: invalidate");
    }

    public void notifyScreenInfoChanged() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: notifyScreenInfoChanged");
    }

    public void sendKeyEvent(@Nullable KeyEvent e) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: sendKeyEvent");
    }

    public void sendMouseEvent(@Nullable MouseEvent e) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: sendMouseEvent");
    }

    public void sendMouseWheelEvent(@Nullable MouseWheelEvent e) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: sendMouseWheelEvent");
    }

    public void sendTouchEvent(@Nullable CefTouchEvent e) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: sendTouchEvent");
    }

    @NotNull
    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    public void ImeSetComposition(@Nullable String text, @Nullable List<CefCompositionUnderline> underlines, @Nullable CefRange replacementRange, @Nullable CefRange selectionRange) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: ImeSetComposition");
    }

    public void ImeCommitText(@Nullable String text, @Nullable CefRange replacementRange, int relativeCursorPos) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: ImeCommitText");
    }

    public void ImeFinishComposingText(boolean keepSelection) {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: ImeFinishComposingText");
    }

    public void ImeCancelComposing() {
        BackendCefBrowserKt.access$getLOG$p().warn("Not supported on backend: ImeCancelComposing");
    }

    public void setWindowlessFrameRate(int frameRate) {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    @NotNull
    public CompletableFuture<Integer> getWindowlessFrameRate() {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    public boolean isWindowless() {
        throw new UnsupportedOperationException("Not supported on backend");
    }

    private static final Unit bindBackgroundColor$reportBackground(BackendCefBrowser this$0, RdCefBrowser $model) {
        Unit unit;
        Color color = this$0.component.getBackground();
        if (color != null) {
            Color it = color;
            boolean bl = false;
            $model.getBackgroundColor().set((Object)ColorHostKt.toModel((Color)it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void bindBackgroundColor$lambda$1(BackendCefBrowser this$0, RdCefBrowser $model, PropertyChangeEvent it) {
        BackendCefBrowser.bindBackgroundColor$reportBackground(this$0, $model);
    }

    private static final Unit bindBackgroundColor$lambda$2(BackendCefBrowser this$0, PropertyChangeListener $propChangeListener) {
        this$0.component.addPropertyChangeListener("background", $propChangeListener);
        return Unit.INSTANCE;
    }

    private static final Unit bindBackgroundColor$lambda$3(BackendCefBrowser this$0, PropertyChangeListener $propChangeListener) {
        this$0.component.removePropertyChangeListener("background", $propChangeListener);
        return Unit.INSTANCE;
    }

    private static final Unit bindIfNeeded$lambda$0$0(BackendCefBrowser this$0, int $newId) {
        this$0.id = $newId;
        return Unit.INSTANCE;
    }

    private static final Unit bindIfNeeded$lambda$0$1(BackendCefBrowser this$0) {
        this$0.id = -1;
        return Unit.INSTANCE;
    }

    private static final void createImmediately$lambda$0(BackendCefBrowser this$0) {
        if (this$0.state == State.CREATED) {
            this$0.bindIfNeeded(true);
        }
    }

    private static final void close$lambda$0(BackendCefBrowser this$0) {
        if (this$0.state != State.CLOSED) {
            this$0.state = State.CLOSED;
            this$0.client.onBeforeClose(this$0);
            LifetimeDefinition.terminate$default((LifetimeDefinition)this$0._lifetime, (boolean)false, (int)1, null);
        }
    }

    public static final /* synthetic */ void access$handleEvent(BackendCefBrowser $this, RdCefEvent event) {
        $this.handleEvent(event);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/cef/BackendCefBrowser$State;", "", "<init>", "(Ljava/lang/String;I)V", "CREATED", "INITIALIZED", "CLOSED", "intellij.platform.backend.split"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State CREATED = new State();
        public static final /* enum */ State INITIALIZED = new State();
        public static final /* enum */ State CLOSED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.CREATED, State.INITIALIZED, State.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

