/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementCustomPreviewHolder;
import com.intellij.codeInsight.lookup.LookupElementInsertStopper;
import com.intellij.codeInsight.lookup.LookupElementInteractivity;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.impl.LookupCellRendererKt;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CompletionItemType;
import com.jetbrains.rd.ide.model.CompletionPresentationModel;
import com.jetbrains.rd.ide.model.CompletionPresentationPart;
import com.jetbrains.rd.ide.model.EffectStyle;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.CompletionItemTextBuilder;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a>\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u000b0\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00022\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001aB\u0010\u0010\u001a\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00022\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\u001a8\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013H\u0080@\u00a2\u0006\u0002\u0010#\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"9\u0010$\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0005 &*\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00150\u00150%\u00a2\u0006\u0002\b'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"convertToProtocolAsync", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "items", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "attachProtocolItems", "Lkotlin/Pair;", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "arranger", "Lcom/intellij/codeInsight/lookup/LookupArranger;", "buildCompletionItem", "item", "index", "", "map", "", "toCompletionPresentation", "Lcom/jetbrains/rd/ide/model/CompletionPresentationModel;", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "getCustomPreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/codeInsight/lookup/Lookup;", "id", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/lookup/Lookup;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "REMOTE_COMPLETION_ID_KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/rdserver/completion/UtilKt\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n68#2,6:139\n1596#3:145\n1629#3,4:146\n1586#3:150\n1661#3,3:151\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/rdserver/completion/UtilKt\n*L\n43#1:139,6\n45#1:145\n45#1:146,4\n35#1:150\n35#1:151,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final AtomicInteger idCounter = new AtomicInteger();
    @NotNull
    private static final Key<Map<Integer, LookupElement>> REMOTE_COMPLETION_ID_KEY;

    @NotNull
    public static final Promise<List<CompletionItem>> convertToProtocolAsync(@NotNull List<? extends LookupElement> items, @Nullable LookupImpl lookup) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (items.isEmpty()) {
            return Promises.resolvedPromise((Object)CollectionsKt.emptyList());
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> UtilKt.convertToProtocolAsync$lambda$0(items, lookup)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return (Promise)cancellablePromise;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<CompletionItem, LookupElement>> attachProtocolItems(List<? extends LookupElement> $this$attachProtocolItems, UserDataHolder userDataHolder, LookupArranger arranger) {
        void $this$mapIndexedTo$iv$iv;
        Object key$iv;
        Object object;
        block9: {
            block8: {
                void $this$getOrCreateUserDataUnsafe$iv;
                object = userDataHolder;
                if (object == null) break block8;
                UserDataHolder userDataHolder2 = object;
                key$iv = REMOTE_COMPLETION_ID_KEY;
                boolean $i$f$getOrCreateUserDataUnsafe = false;
                Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
                Object object2 = existing$iv;
                if (object2 == null) {
                    boolean bl = false;
                    Map value$iv = new LinkedHashMap();
                    $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
                    object2 = value$iv;
                }
                if ((object = (Map)object2) != null) break block9;
            }
            object = new LinkedHashMap();
        }
        Object map2 = object;
        Iterable $this$mapIndexed$iv = $this$attachProtocolItems;
        boolean $i$f$mapIndexed = false;
        key$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Pair pair;
            void item;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (item == null) {
                pair = null;
            } else {
                void index;
                CompletionItem resultItem = UtilKt.buildCompletionItem($this$attachProtocolItems, (LookupElement)item, (int)index, arranger, (Map<Integer, LookupElement>)map2);
                pair = TuplesKt.to((Object)resultItem, (Object)item);
            }
            collection.add(pair);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    static /* synthetic */ List attachProtocolItems$default(List list, UserDataHolder userDataHolder, LookupArranger lookupArranger, int n, Object object) {
        if ((n & 1) != 0) {
            userDataHolder = null;
        }
        if ((n & 2) != 0) {
            lookupArranger = null;
        }
        return UtilKt.attachProtocolItems(list, userDataHolder, lookupArranger);
    }

    private static final CompletionItem buildCompletionItem(List<? extends LookupElement> $this$buildCompletionItem, LookupElement item, int index, LookupArranger arranger, Map<Integer, LookupElement> map2) {
        LookupElementPresentation presentation = new LookupElementPresentation();
        LookupElementRenderer renderer = item.getExpensiveRenderer();
        String speculativeInsert = null;
        LookupElementRenderer lookupElementRenderer = renderer;
        if (lookupElementRenderer == null) {
            lookupElementRenderer = null;
        }
        if (lookupElementRenderer != null) {
            speculativeInsert = item.getLookupString();
            renderer.renderElement(item, presentation);
        } else {
            item.renderElement(presentation);
        }
        LookupArranger lookupArranger = arranger;
        PrefixMatcher prefixMatcher = lookupArranger != null ? lookupArranger.itemMatcher(item) : null;
        CamelHumpMatcher camelHumpMatcher = prefixMatcher instanceof CamelHumpMatcher ? (CamelHumpMatcher)prefixMatcher : null;
        String prefix = camelHumpMatcher != null ? camelHumpMatcher.toString() : null;
        LookupElementInteractivity lookupElementInteractivity = (LookupElementInteractivity)item.getUserData(LookupElementInteractivity.KEY);
        boolean isInteractive = lookupElementInteractivity != null ? lookupElementInteractivity.isInsertHandlerInteractive(item) : false;
        CompletionItemType type = item instanceof LiveTemplateLookupElement ? CompletionItemType.TemplateItem : CompletionItemType.Default;
        int id = idCounter.incrementAndGet();
        map2.put(id, item);
        String string = presentation.getItemText();
        if (string == null) {
            String string2 = item.getLookupString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        }
        Icon icon2 = presentation.getIcon();
        CompletionItem resultItem = new CompletionItem(string, UtilKt.toCompletionPresentation(presentation), presentation.getTypeText(), (IconModel)(icon2 != null ? com.jetbrains.rd.ui.icons.UtilKt.toModel((Icon)icon2) : null), id, (long)($this$buildCompletionItem.size() - index), type, CollectionsKt.emptyList(), prefix, 0, !isInteractive, item.isWorthShowingInAutoPopup(), speculativeInsert, Boolean.valueOf(item.as(LookupElementCustomPreviewHolder.class) != null), Boolean.valueOf(item.as(LookupElementInsertStopper.class) != null), Boolean.valueOf(LookupCellRendererKt.isSeparator((LookupElement)item)));
        return resultItem;
    }

    private static final CompletionPresentationModel toCompletionPresentation(LookupElementPresentation $this$toCompletionPresentation) {
        return ProtocolConversionsKt.completionItemText((Function1<? super CompletionItemTextBuilder, Unit>)((Function1)arg_0 -> UtilKt.toCompletionPresentation$lambda$0($this$toCompletionPresentation, arg_0)));
    }

    @Nullable
    public static final Object getCustomPreview(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull Editor editor, @NotNull Lookup lookup, int id, @NotNull Continuation<? super IntentionPreviewInfo> $completion) {
        if (!(lookup instanceof LookupImpl)) {
            return null;
        }
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime) || session.getProject().isDisposed() || editor.isDisposed()) {
            return null;
        }
        ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(session.getProject())};
        return CoroutinesKt.constrainedReadAction((ReadConstraint[])readConstraintArray, () -> UtilKt.getCustomPreview$lambda$0(lookup, id), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private static final List convertToProtocolAsync$lambda$0(List $items, LookupImpl $lookup) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UtilKt.attachProtocolItems$default($items, (UserDataHolder)$lookup, null, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletionItem)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private static final Unit toCompletionPresentation$lambda$0(LookupElementPresentation $this_toCompletionPresentation, CompletionItemTextBuilder $this$completionItemText) {
        Intrinsics.checkNotNullParameter((Object)$this$completionItemText, (String)"$this$completionItemText");
        String string = $this_toCompletionPresentation.getItemText();
        if (string != null) {
            String it = string;
            boolean bl = false;
            $this$completionItemText.append(new CompletionPresentationPart(it, $this_toCompletionPresentation.isTypeGrayed(), $this_toCompletionPresentation.isStrikeout() ? EffectStyle.StrikeOut : ($this_toCompletionPresentation.isItemTextUnderlined() ? EffectStyle.StraightUnderline : EffectStyle.None), $this_toCompletionPresentation.isItemTextBold() ? FontStyle.Bold : ($this_toCompletionPresentation.isItemTextItalic() ? FontStyle.Italic : FontStyle.Regular)));
        }
        for (LookupElementPresentation.TextFragment tailFragment : $this_toCompletionPresentation.getTailFragments()) {
            String string2 = tailFragment.text;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
            $this$completionItemText.append(new CompletionPresentationPart(string2, $this_toCompletionPresentation.isTypeGrayed(), $this_toCompletionPresentation.isStrikeout() ? EffectStyle.StrikeOut : EffectStyle.None, tailFragment.isItalic() ? FontStyle.Italic : FontStyle.Regular));
        }
        return Unit.INSTANCE;
    }

    private static final IntentionPreviewInfo getCustomPreview$lambda$0(Lookup $lookup, int $id) {
        Map map2 = (Map)((LookupImpl)$lookup).getUserData(REMOTE_COMPLETION_ID_KEY);
        if (map2 == null) {
            return null;
        }
        Map map3 = map2;
        LookupElement lookupElement = (LookupElement)map3.get($id);
        if (lookupElement == null) {
            return null;
        }
        LookupElement item = lookupElement;
        LookupElementCustomPreviewHolder lookupElementCustomPreviewHolder = (LookupElementCustomPreviewHolder)item.as(LookupElementCustomPreviewHolder.class);
        return lookupElementCustomPreviewHolder != null ? lookupElementCustomPreviewHolder.getPreview() : null;
    }

    static {
        Key key = Key.create((String)"remote.completion.id.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        REMOTE_COMPLETION_ID_KEY = key;
    }
}

