/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.inlays;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.InlineDebugRendererModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.daemon.BackendHighlighterRegistrationsHost;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendRangeMarkerModelCreator;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendDebuggerInlayModelCreator;", "Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerModelCreator;", "<init>", "()V", "accept", "", "rangeMarker", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "createModel", "Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;", "Companion", "intellij.platform.backend.split"})
public final class BackendDebuggerInlayModelCreator
implements BackendRangeMarkerModelCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HighlighterProperties PROPERTIES = BackendHighlighterRegistrationsHost.Companion.createDefaultProperties$default(BackendHighlighterRegistrationsHost.Companion, "IJ.DEBUG_INLINE_INLAY", false, false, 6, null);

    @Override
    public boolean accept(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (!BackendDebuggerHost.Companion.useLuxDebugger(contributor.getAppSession())) {
            return false;
        }
        Inlay inlay = rangeMarker instanceof Inlay ? (Inlay)rangeMarker : null;
        if (inlay == null) {
            return false;
        }
        Inlay inlay2 = inlay;
        return inlay2.getRenderer() instanceof InlineDebugRendererBase;
    }

    @Nullable
    public InlineDebugRendererModel createModel(@NotNull RangeMarkerEx rangeMarker, @NotNull BackendMarkupModelContributor contributor) {
        InlineDebugRendererBase renderer;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        Inlay inlay = rangeMarker instanceof Inlay ? (Inlay)rangeMarker : null;
        if (inlay == null) {
            return null;
        }
        Inlay inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        InlineDebugRendererBase inlineDebugRendererBase = editorCustomElementRenderer instanceof InlineDebugRendererBase ? (InlineDebugRendererBase)editorCustomElementRenderer : null;
        if (inlineDebugRendererBase == null) {
            return null;
        }
        InlineDebugRendererBase $this$createModel_u24lambda_u240 = renderer = inlineDebugRendererBase;
        boolean bl = false;
        SimpleColoredText simpleColoredText = $this$createModel_u24lambda_u240.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredText, (String)"getPresentation(...)");
        RichTextModel richTextModel = ProtocolConversionsKt.toRichText(simpleColoredText);
        boolean bl2 = $this$createModel_u24lambda_u240.isInExecutionPointCached;
        boolean bl3 = $this$createModel_u24lambda_u240.isCustomNode();
        boolean bl4 = $this$createModel_u24lambda_u240.isErrorMessage();
        String string = renderer.getSpecialRenderId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecialRenderId(...)");
        return new InlineDebugRendererModel(richTextModel, bl2, bl3, bl4, string, 0, true, (AbstractDocumentVersion)contributor.getDocumentVersion(), ((RangeMarker)rangeMarker).isGreedyToLeft(), ((RangeMarker)rangeMarker).isGreedyToRight(), false, null, null, ((RangeMarkerEx)inlay2).getId(), PROPERTIES, ((RangeMarker)inlay2).getStartOffset(), ((RangeMarker)inlay2).getEndOffset());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendDebuggerInlayModelCreator$Companion;", "", "<init>", "()V", "PROPERTIES", "Lcom/jetbrains/ide/model/highlighterRegistration/HighlighterProperties;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

