/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.document;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteDev.tests.DistributedTestApiKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentUniqueIdSessionRegistry;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionHolderImpl;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.FakeDocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.document.ProtocolDocumentHost;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.ide.model.CreationSide;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.PatchEngineDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentIdWithFileId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.document.BackendDocumentExtensionsProvider;
import com.jetbrains.rdserver.document.BackendDocumentHostKt;
import com.jetbrains.rdserver.document.BackendDocumentHostListener;
import com.jetbrains.rdserver.document.BackendDocumentProvider;
import com.jetbrains.rdserver.fileEditors.GuestFileEditorManager;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.requests.BackendPatchEngineKt;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002'(B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\r2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rdserver/document/BackendDocumentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "idToSynchronizersMap", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "Lkotlin/collections/HashMap;", "documentToSynchronizersMap", "Lcom/intellij/openapi/editor/Document;", "currentlyBindingDocument", "operationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "getOperationModel", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "synchronizeDocument", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentId", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "tryGetSynchronizer", "document", "getDocument", "findOrCreateDocument", "createId", "bindDocument", "extensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "uniqueIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "createAndSetUniqueId", "", "Companion", "MyProtocolListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 5 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,204:1\n67#2,4:205\n67#2,4:229\n13#2:235\n1#3:209\n45#4,8:210\n44#5,5:218\n50#5:233\n10574#6:223\n11007#6,5:224\n13#7:234\n*S KotlinDebug\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost\n*L\n91#1:205,4\n191#1:229,4\n53#1:235\n182#1:210,8\n183#1:218,5\n183#1:233\n184#1:223\n184#1:224,5\n53#1:234\n*E\n"})
public final class BackendDocumentHost
extends LifetimedService
implements ProtocolDocumentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final HashMap<RdDocumentId, DocumentSynchronizer> idToSynchronizersMap;
    @NotNull
    private final HashMap<Document, DocumentSynchronizer> documentToSynchronizersMap;
    @Nullable
    private Document currentlyBindingDocument;
    @NotNull
    private final AtomicLong uniqueIdCounter;
    @NotNull
    private static final Logger LOG;

    public BackendDocumentHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.idToSynchronizersMap = new HashMap();
        this.documentToSynchronizersMap = new HashMap();
        this.uniqueIdCounter = new AtomicLong();
    }

    private final DocumentsOperationModel getOperationModel() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session)));
    }

    private final void synchronizeDocument(Lifetime lifetime, RdDocumentId documentId, RdDocumentModel documentModel) {
        Document document;
        Document document2;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got document model=" + documentModel + ", creation side:" + documentModel.getCreationSide() + ", document: " + DocumentExKt.toDebugString((RdDocumentId)documentId));
        }
        if ((document2 = this.currentlyBindingDocument) == null) {
            document2 = this.findOrCreateDocument(documentId, documentModel);
        }
        if ((document = document2) == null) {
            ApplicationKt.getApplication().invokeLater(() -> BackendDocumentHost.synchronizeDocument$lambda$1(lifetime, this, documentId));
            return;
        }
        DocumentUniqueIdSessionRegistry.Companion.getInstance(this.session).registerUniqueId(document, documentModel.getUniqueId());
        DocumentSynchronizer documentSynchronizer = RuntimeFlagsKt.isRhizomeAdEnabled() ? (DocumentSynchronizer)new FakeDocumentSynchronizer(lifetime, this.session, document, documentModel, documentId, (DocumentVersionHolder)new DocumentVersionHolderImpl(DocumentVersionsKt.getInitialDocVersion(), documentId)) : (DocumentSynchronizer)new PatchEngineDocumentSynchronizer(lifetime, document, documentModel, documentId, (DocumentVersionHolder)new DocumentVersionHolderImpl(DocumentVersionsKt.getInitialDocVersion(), documentId), BackendPatchEngineKt.getEngine(this.session), DistributedTestApiKt.isDistributedTestMode((Application)ApplicationKt.getApplication()), false);
        CollectionExKt.addUnique((Map)this.documentToSynchronizersMap, (Lifetime)lifetime, (Object)document, (Object)documentSynchronizer);
        CollectionExKt.addUnique((Map)this.idToSynchronizersMap, (Lifetime)lifetime, (Object)documentId, (Object)documentSynchronizer);
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
        if (patchEngineDocumentSynchronizer != null) {
            patchEngineDocumentSynchronizer.sendInitialTextChange();
        }
        BackendDocumentHostListener publisher = (BackendDocumentHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(BackendDocumentHostListener.Companion.getTOPIC());
        publisher.documentBound(lifetime, this.session, documentId, documentModel, document);
        lifetime.onTermination(() -> BackendDocumentHost.synchronizeDocument$lambda$2(this, documentSynchronizer, publisher, documentId, document));
    }

    @Nullable
    public final DocumentSynchronizer tryGetSynchronizer(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.documentToSynchronizersMap.get(document);
    }

    @Nullable
    public final DocumentSynchronizer tryGetSynchronizer(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.idToSynchronizersMap.get(documentId);
    }

    @NotNull
    public final Document getDocument(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        DocumentSynchronizer documentSynchronizer = this.tryGetSynchronizer(documentId);
        Intrinsics.checkNotNull((Object)documentSynchronizer);
        return documentSynchronizer.getDocument();
    }

    private final Document findOrCreateDocument(RdDocumentId documentId, RdDocumentModel documentModel) {
        Pair documentValue = (Pair)BackendDocumentProvider.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> BackendDocumentHost.findOrCreateDocument$lambda$0(this, documentId, documentModel, arg_0));
        if (documentValue == null) {
            LOG.warn("No document providers found for " + DocumentExKt.toDebugString((RdDocumentId)documentId));
            return null;
        }
        Pair pair = documentValue;
        Document document = (Document)pair.component1();
        Object object = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        BackendDocumentProvider provider = (BackendDocumentProvider)object;
        if (document == null) {
            LOG.debug("Suitable provider refused from a document. Provider: " + provider + ", document: " + DocumentExKt.toDebugString((RdDocumentId)documentId));
            return null;
        }
        if (!ClientPermissionManager.Companion.getInstance(this.session).isVisible(document)) {
            LOG.error("Permission denied for " + this.session + " documentId=" + DocumentExKt.toDebugString((RdDocumentId)documentId));
            return null;
        }
        return document;
    }

    @NotNull
    public RdDocumentId createId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            RdFileId fileId = BackendVirtualFileSystemHostKt.bind$default(file2, this.session, false, 2, null);
            if (!(fileId != null)) {
                boolean bl = false;
                String string = "not enough permissions to open " + file2.getName();
                throw new IllegalArgumentException(string.toString());
            }
            return (RdDocumentId)new RdDocumentIdWithFileId(fileId);
        }
        return super.createId(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final RdDocumentId bindDocument(@NotNull Document document, @NotNull List<? extends DocumentExtension> extensions) {
        void description$iv;
        void $this$sendAccumulated_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        DocumentSynchronizer documentSynchronizer = this.tryGetSynchronizer(document);
        if (documentSynchronizer != null) {
            DocumentSynchronizer it = documentSynchronizer;
            boolean bl = false;
            return it.getDocumentId();
        }
        RdDocumentId documentId = this.createId(document);
        if (!ClientPermissionManager.Companion.getInstance(this.session).isVisible(document)) {
            boolean $i$a$-require-BackendDocumentHost$bindDocument$32 = false;
            String $i$a$-require-BackendDocumentHost$bindDocument$32 = "Permission denied for " + this.session + " documentId=" + DocumentExKt.toDebugString((RdDocumentId)documentId);
            throw new IllegalArgumentException($i$a$-require-BackendDocumentHost$bindDocument$32.toString());
        }
        PatchEngine patchEngine = BackendPatchEngineKt.getEngine(this.session);
        String $i$a$-require-BackendDocumentHost$bindDocument$32 = "Binding document";
        ChangeReason changeReason$iv = ChangeReason.INIT;
        Class changeProducer$iv = null;
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated_u24default$iv, (boolean)true, (String)description$iv, (ChangeReason)changeReason$iv, changeProducer$iv, null, (int)16, null);
        Throwable throwable = null;
        try {
            RdDocumentId rdDocumentId;
            void flag$iv;
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
            boolean bl = false;
            ChangeScope $this$bindDocument_u24lambda_u242 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return BackendDocumentHost.access$getCurrentlyBindingDocument$p((BackendDocumentHost)((Object)this.receiver));
                }

                public void set(Object value) {
                    BackendDocumentHost.access$setCurrentlyBindingDocument$p((BackendDocumentHost)((Object)this.receiver), (Document)value);
                }
            };
            Document value$iv = document;
            boolean $i$f$usingNullableFlag = false;
            if (!(flag$iv.get() == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                VirtualFile file2;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                flag$iv.set((Object)value$iv);
                boolean bl3 = false;
                Object[] objectArray = BackendDocumentExtensionsProvider.Companion.getEP_NAME().getExtensions();
                Collection collection = extensions;
                boolean $i$f$flatMap = false;
                void var23_32 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                    BackendDocumentExtensionsProvider it = (BackendDocumentExtensionsProvider)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = it.getExtensions(this.session, document);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List allExtensions = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                DocumentImpl documentImpl = document instanceof DocumentImpl ? (DocumentImpl)document : null;
                boolean isWriteThreadOnly = documentImpl != null ? documentImpl.isWriteThreadOnly() : true;
                String id = this.createAndSetUniqueId(document);
                PatchEngineDocumentModel documentModel = new PatchEngineDocumentModel(allExtensions, CreationSide.Backend, isWriteThreadOnly, id);
                VirtualFile virtualFile = file2 = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile != null) {
                    BackendVirtualFileSystemHostKt.bind(virtualFile, this.session, true);
                }
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    collection = $this$trace$iv;
                    boolean bl5 = false;
                    collection.trace("[file] bindDocument: Set new `documentId` to `documentsOperationModel.documents` map: documentId=" + DocumentExKt.toDebugString((RdDocumentId)documentId));
                }
                ((Map)this.getOperationModel().getDocuments()).put(documentId, documentModel);
                rdDocumentId = documentId;
            }
            catch (Throwable throwable2) {
                try {
                    flag$iv.set(null);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            flag$iv.set(null);
            RdDocumentId rdDocumentId2 = rdDocumentId;
            return rdDocumentId2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ RdDocumentId bindDocument$default(BackendDocumentHost backendDocumentHost, Document document, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return backendDocumentHost.bindDocument(document, list);
    }

    private final String createAndSetUniqueId(Document document) {
        return Registry.Companion.is("rdserver.patch.engine.enable.unique.document.id") ? "unique-id-backend-" + this.uniqueIdCounter.getAndIncrement() : "";
    }

    private static final void synchronizeDocument$lambda$1(Lifetime $lifetime, BackendDocumentHost this$0, RdDocumentId $documentId) {
        if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
            return;
        }
        this$0.getOperationModel().getDocuments().remove((Object)$documentId);
    }

    private static final Unit synchronizeDocument$lambda$2(BackendDocumentHost this$0, DocumentSynchronizer $documentSynchronizer, BackendDocumentHostListener $publisher, RdDocumentId $documentId, Document $document) {
        DocumentUniqueIdSessionRegistry.Companion.getInstance(this$0.session).unregisterUniqueId($documentSynchronizer.getDocument());
        $publisher.documentIsBeingUnbound(this$0.session, $documentId, $document);
        return Unit.INSTANCE;
    }

    private static final Pair findOrCreateDocument$lambda$0(BackendDocumentHost this$0, RdDocumentId $documentId, RdDocumentModel $documentModel, BackendDocumentProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.accept(this$0.session, $documentId, $documentModel)) {
            return null;
        }
        return TuplesKt.to((Object)it.document(this$0.session, $documentId, $documentModel), (Object)it);
    }

    public static final /* synthetic */ Document access$getCurrentlyBindingDocument$p(BackendDocumentHost $this) {
        return $this.currentlyBindingDocument;
    }

    public static final /* synthetic */ void access$setCurrentlyBindingDocument$p(BackendDocumentHost $this, Document document) {
        $this.currentlyBindingDocument = document;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendDocumentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/document/BackendDocumentHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/document/BackendDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "getInstanceIfExists", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_backend_split", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,204:1\n50#2:205\n*S KotlinDebug\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost$Companion\n*L\n51#1:205\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendDocumentHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            BackendDocumentHost backendDocumentHost = this.getInstanceIfExists(session);
            if (backendDocumentHost == null) {
                throw new IllegalStateException(("Service is not found for " + session).toString());
            }
            return backendDocumentHost;
        }

        @Nullable
        public final BackendDocumentHost getInstanceIfExists(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$serviceOrNull$iv = (ComponentManager)session;
            boolean $i$f$serviceOrNull = false;
            return (BackendDocumentHost)((Object)$this$serviceOrNull$iv.getService(BackendDocumentHost.class));
        }

        @NotNull
        public final Logger getLOG$intellij_platform_backend_split() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/document/BackendDocumentHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n67#2,4:205\n67#2,4:209\n1915#3:213\n1916#3:215\n1#4:214\n*S KotlinDebug\n*F\n+ 1 BackendDocumentHost.kt\ncom/jetbrains/rdserver/document/BackendDocumentHost$MyProtocolListener\n*L\n63#1:205,4\n65#1:209,4\n79#1:213\n79#1:215\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Logger $this$trace$iv = Companion.getLOG$intellij_platform_backend_split();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: subscribe on `documents`");
            }
            model2.getDocuments().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.extensionCreated$lambda$1(session, model2, arg_0, arg_1, arg_2));
            model2.getClientOpenedWithError().advise(lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$2(session, model2, arg_0));
        }

        private static final Unit extensionCreated$lambda$1$1(DocumentsOperationModel $model, RdDocumentId $documentId) {
            $model.getHostReleasedDocument().fire((Object)$documentId);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(ClientAppSession $session, DocumentsOperationModel $model, Lifetime documentLifetime, RdDocumentId documentId, RdDocumentModel documentModel) {
            Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
            Logger $this$trace$iv = Companion.getLOG$intellij_platform_backend_split();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] MyProtocolListener$extensionCreated$document.view called");
            }
            documentLifetime.onTermination(() -> MyProtocolListener.extensionCreated$lambda$1$1($model, documentId));
            Companion.getInstance($session).synchronizeDocument(documentLifetime, documentId, documentModel);
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$2(ClientAppSession $session, DocumentsOperationModel $model, RdDocumentId documentId) {
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            DocumentSynchronizer documentSynchronizer = BackendDocumentHostKt.toSynchronizerOrNull(documentId, $session);
            if (documentSynchronizer == null) {
                return Unit.INSTANCE;
            }
            DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
            DocumentUniqueIdSessionRegistry registry = DocumentUniqueIdSessionRegistry.Companion.getInstance($session);
            registry.unregisterUniqueId(documentSynchronizer2.getDocument());
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(documentSynchronizer2.getDocument());
            if (virtualFile == null) {
                return Unit.INSTANCE;
            }
            VirtualFile virtualFile2 = virtualFile;
            Iterable $this$forEach$iv = documentSynchronizer2.getModelDocument().getTextControls().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TextControlId textControlId = (TextControlId)element$iv;
                boolean bl = false;
                RdProjectId rdProjectId = textControlId.getProjectId();
                if (rdProjectId == null) continue;
                RdProjectId it = rdProjectId;
                boolean bl2 = false;
                ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)$session, (RdProjectId)it);
                rdProjectId = clientProjectSession;
                if (clientProjectSession == null) {
                    continue;
                }
                RdProjectId projectSession = rdProjectId;
                GuestFileEditorManager.Companion.getInstance((ClientProjectSession)projectSession).closeFile(virtualFile2, true);
            }
            $model.getDocuments().remove((Object)documentId);
            return Unit.INSTANCE;
        }
    }
}

