/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.services;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.jetbrains.rdserver.lux.awt.font.LuxGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdserver/lux/services/LuxFontLayoutService;", "Lcom/intellij/openapi/editor/impl/view/FontLayoutService;", "original", "<init>", "(Lcom/intellij/openapi/editor/impl/view/FontLayoutService;)V", "layoutGlyphVector", "Ljava/awt/font/GlyphVector;", "font", "Ljava/awt/Font;", "fontRenderContext", "Ljava/awt/font/FontRenderContext;", "chars", "", "start", "", "end", "isRtl", "", "charWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "c", "", "codePoint", "charWidth2D", "", "stringWidth", "str", "", "getHeight", "getDescent", "intellij.platform.backend.split"})
public final class LuxFontLayoutService
extends FontLayoutService {
    @NotNull
    private final FontLayoutService original;

    public LuxFontLayoutService(@NotNull FontLayoutService original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
    }

    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)fontRenderContext, (String)"fontRenderContext");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        GlyphVector vector = this.original.layoutGlyphVector(font, fontRenderContext, chars, start, end, isRtl);
        return new LuxGlyphVector(font, fontRenderContext, chars, start, end, isRtl, vector);
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return this.original.charWidth(fontMetrics, c);
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return this.original.charWidth(fontMetrics, codePoint);
    }

    public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return this.original.charWidth2D(fontMetrics, codePoint);
    }

    public int stringWidth(@NotNull FontMetrics fontMetrics, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.original.stringWidth(fontMetrics, str);
    }

    public int getHeight(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return this.original.getHeight(fontMetrics);
    }

    public int getDescent(@NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        return this.original.getDescent(fontMetrics);
    }
}

