/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.permissions.impl;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/permissions/impl/BackendWriteAccessProvider;", "Lcom/intellij/openapi/vfs/WritingAccessProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "requestWriting", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "isPotentiallyWritable", "", "file", "intellij.platform.backend.split"})
public final class BackendWriteAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final Project project;

    public BackendWriteAccessProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.project);
        if (!ClientPermissionManager.Companion.getInstance(session).hasFileWriteAccess()) {
            return files2;
        }
        return new ArrayList();
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.project);
        return ClientPermissionManager.Companion.getInstance(session).isWritable(file2);
    }
}

