/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.utils;

import com.intellij.execution.impl.ProcessHandlerPidProvider;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.ExposedRdPortInfo;
import com.jetbrains.codeWithMe.model.ForwardedRdPortInfo;
import com.jetbrains.codeWithMe.model.PortForwardingSuggestion;
import com.jetbrains.codeWithMe.model.RdPortId;
import com.jetbrains.codeWithMe.model.SessionPortForwarding;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ContainerPortForwardingCollector;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.GlobalPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPortHandler;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortForwardingManager;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PerClientPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortBinding;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortListeningOptions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.PortForwardingProcessWatcher;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rdserver.portForwarding.internal.ForwardedPortImpl;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingProcessListener;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingSessionData;
import com.jetbrains.rdserver.portForwarding.utils.PortForwardingStdoutPortListener;
import com.jetbrains.rdserver.portForwarding.utils.SuggestionHolder;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ(\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020#H\u0002J \u0010(\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020#2\u0006\u0010)\u001a\u00020'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/PortForwardingSessionUtils;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sessionsMap", "", "Ljava/util/UUID;", "Lcom/jetbrains/rdserver/portForwarding/utils/SuggestionHolder;", "getSessionsMap", "()Ljava/util/Map;", "createSession", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "clientAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "onPortStoppedListening", "", "sessionPortForwarding", "listeningPort", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "onPortForwardingAvailable", "sessionOrigin", "", "setupPortForwardingSession", "Lcom/jetbrains/rdserver/portForwarding/utils/PortForwardingSessionData;", "pid", "", "includePidItself", "", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "findSuggestedForwardedPort", "", "portNumber", "(I)Ljava/lang/Integer;", "createPortForwardingSuggestion", "Lcom/jetbrains/codeWithMe/model/PortForwardingSuggestion;", "addSuggestionToSessionMap", "portSuggestion", "ProcessListeningPortHandler", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPortForwardingSessionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingSessionUtils.kt\ncom/jetbrains/rdserver/portForwarding/utils/PortForwardingSessionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,345:1\n1#2:346\n1915#3:347\n1915#3:348\n1916#3:354\n1916#3:355\n1915#3:361\n1915#3,2:362\n1916#3:364\n296#3,2:370\n1915#3,2:382\n60#4,5:349\n60#4,5:356\n60#4,5:365\n60#4,5:372\n60#4,5:377\n23#4:384\n*S KotlinDebug\n*F\n+ 1 PortForwardingSessionUtils.kt\ncom/jetbrains/rdserver/portForwarding/utils/PortForwardingSessionUtils\n*L\n265#1:347\n266#1:348\n266#1:354\n265#1:355\n285#1:361\n287#1:362,2\n285#1:364\n121#1:370,2\n164#1:382,2\n269#1:349,5\n281#1:356,5\n115#1:365,5\n138#1:372,5\n143#1:377,5\n42#1:384\n*E\n"})
public final class PortForwardingSessionUtils {
    @NotNull
    public static final PortForwardingSessionUtils INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<UUID, SuggestionHolder> sessionsMap;

    private PortForwardingSessionUtils() {
    }

    @NotNull
    public final Map<UUID, SuggestionHolder> getSessionsMap() {
        return sessionsMap;
    }

    private final SessionPortForwarding createSession(Lifetime sessionLifetime, ClientAppSession clientAppSession) {
        if (!clientAppSession.isController()) {
            return null;
        }
        if (!PerClientPortForwardingManager.Companion.getInstance(clientAppSession).isPortForwardingEnabled()) {
            return null;
        }
        SessionPortForwarding sessionPortForwarding = new SessionPortForwarding();
        sessionLifetime.onTermination(() -> PortForwardingSessionUtils.createSession$lambda$0(sessionPortForwarding));
        PerClientPortListener perClientPortLifecycleListener2 = new PerClientPortListener(clientAppSession, sessionPortForwarding){
            final /* synthetic */ ClientAppSession $clientAppSession;
            final /* synthetic */ SessionPortForwarding $sessionPortForwarding;
            {
                this.$clientAppSession = $clientAppSession;
                this.$sessionPortForwarding = $sessionPortForwarding;
            }

            public void stateChanged(ClientAppSession session, ForwardedPort port, ServerSocketPortState newState) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                if (!Intrinsics.areEqual((Object)this.$clientAppSession, (Object)session)) {
                    return;
                }
                if ((port instanceof ForwardedPortImpl ? (ForwardedPortImpl)port : null) == null) {
                    return;
                }
                PortForwardingSuggestion portForwardingSuggestion = (PortForwardingSuggestion)this.$sessionPortForwarding.getAvailablePorts().get((Object)((ForwardedPortImpl)port).getTargetPortNumber());
                if (portForwardingSuggestion == null) {
                    return;
                }
                PortForwardingSuggestion suggestion = portForwardingSuggestion;
                ServerSocketPortState serverSocketPortState = newState;
                if (serverSocketPortState instanceof ServerSocketPortState.Assigned) {
                    int n = ((ForwardedPortImpl)port).getTargetPortNumber();
                    UUID uUID = ((ForwardedPortImpl)port).getMyUuid$intellij_platform_backend_split();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-myUuid>(...)");
                    ForwardedRdPortInfo portInfo = new ForwardedRdPortInfo(new RdPortId(n, uUID));
                    portInfo.getClientPort().set((Object)((ServerSocketPortState.Assigned)newState).getPort());
                    suggestion.getForwardedPort().set((Object)portInfo);
                } else if (serverSocketPortState instanceof ServerSocketPortState.FailedToAssign) {
                    PortForwardingSessionUtils.access$getLogger$p().warn("Failed to assign port " + ((ForwardedPortImpl)port).getTargetPortNumber() + " on client side. Reason: " + ((ServerSocketPortState.FailedToAssign)newState).getReason());
                    suggestion.getForwardedPort().set(null);
                } else if (Intrinsics.areEqual((Object)serverSocketPortState, (Object)ServerSocketPortState.NotAssigned.INSTANCE)) {
                    PortForwardingSessionUtils.access$getLogger$p().warn("Got NotAssigned state in listener. Should not be here");
                    suggestion.getForwardedPort().set(null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }

            public void portRemoved(ClientAppSession session, ForwardedPort port) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                if (!Intrinsics.areEqual((Object)this.$clientAppSession, (Object)session)) {
                    return;
                }
                PortForwardingSuggestion portForwardingSuggestion = (PortForwardingSuggestion)this.$sessionPortForwarding.getAvailablePorts().get((Object)port.getTargetPortNumber());
                if (portForwardingSuggestion == null) {
                    return;
                }
                PortForwardingSuggestion suggestion = portForwardingSuggestion;
                suggestion.getForwardedPort().set(null);
            }
        };
        ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)sessionLifetime, null, (int)1, null)).subscribe(PerClientPortListener.Companion.getTOPIC(), (Object)perClientPortLifecycleListener2);
        return sessionPortForwarding;
    }

    private final void onPortStoppedListening(SessionPortForwarding sessionPortForwarding, ListeningPort listeningPort) {
        ApplicationKt.getApplication().invokeLater(() -> PortForwardingSessionUtils.onPortStoppedListening$lambda$0(listeningPort, sessionPortForwarding));
    }

    private final void onPortForwardingAvailable(Lifetime sessionLifetime, SessionPortForwarding sessionPortForwarding, ClientAppSession clientAppSession, String sessionOrigin, ListeningPort listeningPort) {
        ApplicationKt.getApplication().invokeLater(() -> PortForwardingSessionUtils.onPortForwardingAvailable$lambda$0(listeningPort, sessionOrigin, sessionLifetime, sessionPortForwarding, clientAppSession));
    }

    @Nullable
    public final PortForwardingSessionData setupPortForwardingSession(@NotNull Lifetime sessionLifetime, @NotNull ClientAppSession clientAppSession, long pid, @NotNull String sessionOrigin, boolean includePidItself) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"clientAppSession");
        Intrinsics.checkNotNullParameter((Object)sessionOrigin, (String)"sessionOrigin");
        SessionPortForwarding sessionPortForwarding = this.createSession(sessionLifetime, clientAppSession);
        if (sessionPortForwarding == null) {
            return null;
        }
        SessionPortForwarding sessionPortForwarding2 = sessionPortForwarding;
        ProcessListeningPortHandler listeningPortHandler = new ProcessListeningPortHandler(sessionLifetime, sessionPortForwarding2, clientAppSession, sessionOrigin);
        PortListeningOptions options = includePidItself ? PortListeningOptions.INCLUDE_SELF_AND_CHILDREN : PortListeningOptions.INCLUDE_CHILDREN;
        PortForwardingProcessWatcher watcher = PortForwardingProcessWatcher.Companion.create(pid, (ListeningPortHandler)listeningPortHandler, options);
        watcher.startWatch(sessionLifetime);
        return new PortForwardingSessionData(sessionPortForwarding2, watcher);
    }

    @Nullable
    public final SessionPortForwarding setupPortForwardingSession(@NotNull Lifetime sessionLifetime, @NotNull ClientAppSession clientAppSession, @NotNull ProcessHandler handler, @NotNull String sessionOrigin) {
        Deferred pid;
        SessionPortForwarding sessionPortForwarding;
        block12: {
            Deferred deferred;
            Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
            Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"clientAppSession");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)sessionOrigin, (String)"sessionOrigin");
            SessionPortForwarding sessionPortForwarding2 = this.createSession(sessionLifetime, clientAppSession);
            if (sessionPortForwarding2 == null) {
                return null;
            }
            sessionPortForwarding = sessionPortForwarding2;
            for (ProcessHandlerPidProvider it : ProcessHandlerPidProvider.Companion.getEP_NAME().lazySequence()) {
                boolean bl = false;
                Deferred deferred2 = it.getPid(handler);
                if (deferred2 == null) continue;
                deferred = deferred2;
                break block12;
            }
            deferred = pid = null;
        }
        if (pid != null) {
            ProcessListeningPortHandler listeningPortHandler = new ProcessListeningPortHandler(sessionLifetime, sessionPortForwarding, clientAppSession, sessionOrigin);
            PortForwardingProcessListener listener2 = new PortForwardingProcessListener(sessionLifetime, (Deferred<Long>)pid, (ListeningPortHandler)listeningPortHandler);
            handler.addProcessListener((ProcessListener)listener2);
            return sessionPortForwarding;
        }
        if (handler instanceof BaseProcessHandler) {
            Process process2 = ((BaseProcessHandler)handler).getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"getProcess(...)");
            Process process3 = process2;
            if (process3 instanceof RemoteProcess) {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Iterable $this$forEach$iv2;
                Map filteredPortsBinding = new LinkedHashMap();
                Iterable iterable = ContainerPortForwardingCollector.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    ContainerPortForwardingCollector extension = (ContainerPortForwardingCollector)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = extension.collectForwardedPortsForRemoteProcess((RemoteProcess)process3);
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        PortBinding portBinding = (PortBinding)element$iv2;
                        boolean bl2 = false;
                        PortBinding existingBinding = (PortBinding)filteredPortsBinding.get(portBinding.getPort());
                        if (existingBinding != null) {
                            Logger $this$debug_u24default$iv = logger;
                            Throwable t$iv = null;
                            boolean $i$f$debug = false;
                            if (!$this$debug_u24default$iv.isDebugEnabled()) continue;
                            Logger logger = $this$debug_u24default$iv;
                            boolean bl3 = false;
                            logger.debug("The port: <" + portBinding.getPort() + "> has already been added to the bindings. Skip adding new binding: " + portBinding + ". Existing binding: " + existingBinding, t$iv);
                            continue;
                        }
                        filteredPortsBinding.put(portBinding.getPort(), portBinding);
                    }
                }
                Logger $this$debug_u24default$iv = logger;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Collected ports from remote process:\n" + CollectionsKt.joinToString$default((Iterable)filteredPortsBinding.values(), (CharSequence)"\n", null, null, (int)0, null, PortForwardingSessionUtils::setupPortForwardingSession$lambda$2$0, (int)30, null), t$iv);
                }
                $this$forEach$iv2 = filteredPortsBinding.values();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    PortBinding portBinding = (PortBinding)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = portBinding.getBindings();
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        InetSocketAddress binding = (InetSocketAddress)element$iv2;
                        boolean bl4 = false;
                        ListeningPort listeningPort = new ListeningPort(binding, portBinding.getType(), null);
                        INSTANCE.onPortForwardingAvailable(sessionLifetime, sessionPortForwarding, clientAppSession, "Container Forwarded Ports", listeningPort);
                    }
                }
            }
        } else {
            handler.addProcessListener((ProcessListener)new PortForwardingStdoutPortListener(sessionLifetime, (Function1<? super ListeningPort, Unit>)((Function1)arg_0 -> PortForwardingSessionUtils.setupPortForwardingSession$lambda$4(sessionLifetime, sessionPortForwarding, clientAppSession, sessionOrigin, arg_0))));
        }
        return sessionPortForwarding;
    }

    private final Integer findSuggestedForwardedPort(int portNumber) {
        Object v0;
        block1: {
            Iterable iterable = sessionsMap.values();
            for (Object t : iterable) {
                SuggestionHolder suggestion = (SuggestionHolder)t;
                boolean bl = false;
                if (!(suggestion.getSuggestedHostPort() == portNumber)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        SuggestionHolder suggestionHolder = v0;
        return suggestionHolder != null ? Integer.valueOf(suggestionHolder.getSuggestedHostPort()) : null;
    }

    private final PortForwardingSuggestion createPortForwardingSuggestion(int portNumber) {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        return new PortForwardingSuggestion(uUID, portNumber);
    }

    private final boolean addSuggestionToSessionMap(ClientAppSession clientAppSession, int portNumber, PortForwardingSuggestion portSuggestion) {
        boolean isPortAlreadyForwardedBySuggestion;
        List portsForHostPort = PerClientPortForwardingManager.Companion.getInstance(clientAppSession).getPorts(portNumber);
        boolean isPortAlreadyForwarded = !((Collection)portsForHostPort).isEmpty();
        boolean bl = isPortAlreadyForwardedBySuggestion = this.findSuggestedForwardedPort(portNumber) != null;
        if (!isPortAlreadyForwarded && !isPortAlreadyForwardedBySuggestion) {
            sessionsMap.put(portSuggestion.getSuggestionId(), new SuggestionHolder(portSuggestion));
            return true;
        }
        return false;
    }

    private static final void createSession$lambda$0$0(SessionPortForwarding $sessionPortForwarding) {
        $sessionPortForwarding.getSessionEnded().fire((Object)Unit.INSTANCE);
    }

    private static final Unit createSession$lambda$0(SessionPortForwarding $sessionPortForwarding) {
        ApplicationKt.getApplication().invokeLater(() -> PortForwardingSessionUtils.createSession$lambda$0$0($sessionPortForwarding));
        return Unit.INSTANCE;
    }

    private static final void onPortStoppedListening$lambda$0(ListeningPort $listeningPort, SessionPortForwarding $sessionPortForwarding) {
        block5: {
            Object v0;
            GlobalPortForwardingManager pfManager;
            block4: {
                int portNumber = $listeningPort.getSocketAddress().getPort();
                PortForwardingSuggestion removedAvailablePort = (PortForwardingSuggestion)$sessionPortForwarding.getAvailablePorts().remove((Object)portNumber);
                if (removedAvailablePort == null) {
                    return;
                }
                SuggestionHolder removedSuggestedPort = sessionsMap.remove(removedAvailablePort.getSuggestionId());
                if (removedSuggestedPort == null) {
                    Logger $this$debug_u24default$iv = logger;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Port <" + portNumber + "> does not exist in port forwarding sessions map.", t$iv);
                    }
                    return;
                }
                pfManager = GlobalPortForwardingManager.Companion.getInstance();
                List ports = pfManager.getPorts(portNumber);
                Iterable $this$firstOrNull$iv = ports;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ForwardedPort it = (ForwardedPort)element$iv;
                    boolean bl = false;
                    if (!(it.getConfiguration() instanceof PortConfiguration.TcpForwarding)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            ForwardedPort forwardedPort = v0;
            if (forwardedPort == null) break block5;
            ForwardedPort it = forwardedPort;
            boolean bl = false;
            pfManager.removePort(it);
        }
    }

    private static final Unit onPortForwardingAvailable$lambda$0$2(ListeningPort $listeningPort, String $sessionOrigin, SessionPortForwarding $sessionPortForwarding) {
        logger.info("Port forwarding session has been terminated. Stop port forwarding if needed for port: <" + $listeningPort.getSocketAddress().getPort() + "> (origin: " + $sessionOrigin + ")");
        INSTANCE.onPortStoppedListening($sessionPortForwarding, $listeningPort);
        return Unit.INSTANCE;
    }

    private static final Unit onPortForwardingAvailable$lambda$0$4(Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void onPortForwardingAvailable$lambda$0(ListeningPort $listeningPort, String $sessionOrigin, Lifetime $sessionLifetime, SessionPortForwarding $sessionPortForwarding, ClientAppSession $clientAppSession) {
        logger.info("Found port available for port forwarding: <" + $listeningPort.getSocketAddress() + "> (origin: " + $sessionOrigin + ")");
        if (RLifetimeKt.isNotAlive((Lifetime)$sessionLifetime)) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Port Forwarding session lifetime is already terminated. Skip forwarding setup.", t$iv);
            }
            return;
        }
        if ($sessionPortForwarding.getAvailablePorts().get((Object)$listeningPort.getSocketAddress().getPort()) != null) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Port <" + $listeningPort.getSocketAddress().getPort() + "> is already forwarded. Skip forwarding setup.", t$iv);
            }
            return;
        }
        PortForwardingSuggestion suggestion = INSTANCE.createPortForwardingSuggestion($listeningPort.getSocketAddress().getPort());
        INSTANCE.addSuggestionToSessionMap($clientAppSession, $listeningPort.getSocketAddress().getPort(), suggestion);
        $sessionLifetime.onTermination(() -> PortForwardingSessionUtils.onPortForwardingAvailable$lambda$0$2($listeningPort, $sessionOrigin, $sessionPortForwarding));
        List portsForHostPort = PerClientPortForwardingManager.Companion.getInstance($clientAppSession).getPorts($listeningPort.getSocketAddress().getPort());
        Iterable $this$forEach$iv = portsForHostPort;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$onPortForwardingAvailable_u24lambda_u240_u243_u240;
            ForwardedRdPortInfo portInfo;
            ForwardedPort forwardedPort = (ForwardedPort)element$iv;
            boolean bl = false;
            ForwardedPortImpl forwardedPortImpl = forwardedPort instanceof ForwardedPortImpl ? (ForwardedPortImpl)forwardedPort : null;
            if (forwardedPortImpl == null) {
                throw new IllegalStateException(("Unable to get Port instance from forwarded port: " + forwardedPort).toString());
            }
            ForwardedPortImpl port = forwardedPortImpl;
            PortConfiguration configuration = port.getConfiguration();
            if (configuration instanceof PortConfiguration.PerClientTcpForwarding) {
                ServerSocketPortState state = ((PortConfiguration.PerClientTcpForwarding)configuration).getServerSocketPortState();
                if (!(state instanceof ServerSocketPortState.Assigned)) continue;
                int n = port.getTargetPortNumber();
                UUID uUID = port.getMyUuid$intellij_platform_backend_split();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-myUuid>(...)");
                portInfo = new ForwardedRdPortInfo(new RdPortId(n, uUID));
                portInfo.getClientPort().set((Object)((ServerSocketPortState.Assigned)state).getPort());
                suggestion.getForwardedPort().set((Object)portInfo);
                continue;
            }
            if (!(configuration instanceof PortConfiguration.UrlExposure)) continue;
            IMutableViewableList iMutableViewableList = suggestion.getExposedPorts();
            int n = port.getTargetPortNumber();
            UUID uUID = port.getMyUuid$intellij_platform_backend_split();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-myUuid>(...)");
            ExposedRdPortInfo exposedRdPortInfo = new ExposedRdPortInfo(new RdPortId(n, uUID));
            portInfo = exposedRdPortInfo;
            IMutableViewableList iMutableViewableList2 = iMutableViewableList;
            boolean bl2 = false;
            $this$onPortForwardingAvailable_u24lambda_u240_u243_u240.getExposedUrl().set((Object)((PortConfiguration.UrlExposure)configuration).getExposedUrl());
            iMutableViewableList2.add((Object)exposedRdPortInfo);
        }
        suggestion.getGenerateHttpScratch().advise($sessionLifetime, PortForwardingSessionUtils::onPortForwardingAvailable$lambda$0$4);
        ((Map)$sessionPortForwarding.getAvailablePorts()).put($listeningPort.getSocketAddress().getPort(), suggestion);
    }

    private static final CharSequence setupPortForwardingSession$lambda$2$0(PortBinding portBinding) {
        Intrinsics.checkNotNullParameter((Object)portBinding, (String)"portBinding");
        return portBinding.toString();
    }

    private static final Unit setupPortForwardingSession$lambda$4(Lifetime $sessionLifetime, SessionPortForwarding $sessionPortForwarding, ClientAppSession $clientAppSession, String $sessionOrigin, ListeningPort listeningPort) {
        Intrinsics.checkNotNullParameter((Object)listeningPort, (String)"listeningPort");
        INSTANCE.onPortForwardingAvailable($sessionLifetime, $sessionPortForwarding, $clientAppSession, $sessionOrigin, listeningPort);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        PortForwardingSessionUtils $this$thisLogger$iv = INSTANCE = new PortForwardingSessionUtils();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(PortForwardingSessionUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingSessionUtils.logger = logger;
        sessionsMap = new LinkedHashMap();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/PortForwardingSessionUtils$ProcessListeningPortHandler;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionPortForwarding", "Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;", "clientAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "sessionOrigin", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/SessionPortForwarding;Lcom/intellij/openapi/client/ClientAppSession;Ljava/lang/String;)V", "onPortListeningStarted", "", "port", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "onPortListeningEnded", "intellij.platform.backend.split"})
    private static final class ProcessListeningPortHandler
    implements ListeningPortHandler {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final SessionPortForwarding sessionPortForwarding;
        @NotNull
        private final ClientAppSession clientAppSession;
        @NotNull
        private final String sessionOrigin;

        public ProcessListeningPortHandler(@NotNull Lifetime lifetime, @NotNull SessionPortForwarding sessionPortForwarding, @NotNull ClientAppSession clientAppSession, @NotNull String sessionOrigin) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)sessionPortForwarding, (String)"sessionPortForwarding");
            Intrinsics.checkNotNullParameter((Object)clientAppSession, (String)"clientAppSession");
            Intrinsics.checkNotNullParameter((Object)sessionOrigin, (String)"sessionOrigin");
            this.lifetime = lifetime;
            this.sessionPortForwarding = sessionPortForwarding;
            this.clientAppSession = clientAppSession;
            this.sessionOrigin = sessionOrigin;
        }

        public void onPortListeningStarted(@NotNull ListeningPort port) {
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            INSTANCE.onPortForwardingAvailable(this.lifetime, this.sessionPortForwarding, this.clientAppSession, this.sessionOrigin, port);
        }

        public void onPortListeningEnded(@NotNull ListeningPort port) {
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            INSTANCE.onPortStoppedListening(this.sessionPortForwarding, port);
        }
    }
}

