/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.SystemInfoRt;
import com.jetbrains.codeWithMe.model.FailureSignRequestResult;
import com.jetbrains.codeWithMe.model.RequestIdentitiesArg;
import com.jetbrains.codeWithMe.model.SignRequestArg;
import com.jetbrains.codeWithMe.model.SignRequestResult;
import com.jetbrains.codeWithMe.model.SshKeyIdentity;
import com.jetbrains.codeWithMe.model.SuccessSignRequestResult;
import com.jetbrains.rd.platform.codeWithMe.sshAgentProxy.SSH_AGENT_COMMAND;
import com.jetbrains.rd.platform.codeWithMe.sshAgentProxy.SshAgentConnection;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcFactory;
import com.jetbrains.rdserver.sshAgentProxy.UnixDomainSocketAgentIpcFactory;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeSshAgentIpcFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0014H\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentForwarder;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sshRemoteAgentProxy", "Lcom/jetbrains/rd/platform/codeWithMe/sshAgentProxy/SshAgentConnection;", "ipcKeyToReuse", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/platform/codeWithMe/sshAgentProxy/SshAgentConnection;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "forwardingThread", "Ljava/lang/Thread;", "ipcKey", "getIpcKey", "()Ljava/lang/String;", "ipcKey$delegate", "Lkotlin/Lazy;", "agentIpc", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "getAgentIpc", "()Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "agentIpc$delegate", "getSshAgentIpc", "agentStarted", "Lkotlinx/coroutines/CompletableDeferred;", "", "startForwarding", "processAcceptedIPC", "streams", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "processIncomingMessage", "incomingMessageStream", "Ljava/io/DataInputStream;", "dataOutputStream", "Ljava/io/DataOutputStream;", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "waitFor", "timeoutMs", "", "isAlive", "", "close", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nSshAgentForwarder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAgentForwarder.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentForwarder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,230:1\n67#2,4:231\n67#2,4:235\n67#2,4:239\n67#2,4:243\n67#2,4:247\n67#2,4:251\n67#2,4:255\n67#2,4:259\n67#2,4:263\n67#2,4:267\n82#2,3:271\n13#2:275\n13#3:274\n*S KotlinDebug\n*F\n+ 1 SshAgentForwarder.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentForwarder\n*L\n125#1:231,4\n154#1:235,4\n156#1:239,4\n160#1:243,4\n168#1:247,4\n179#1:251,4\n186#1:255,4\n190#1:259,4\n196#1:263,4\n202#1:267,4\n34#1:271,3\n23#1:275\n23#1:274\n*E\n"})
public final class SshAgentForwarder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SshAgentConnection sshRemoteAgentProxy;
    @Nullable
    private final String ipcKeyToReuse;
    @NotNull
    private final Thread forwardingThread;
    @NotNull
    private final Lazy ipcKey$delegate;
    @NotNull
    private final Lazy agentIpc$delegate;
    @NotNull
    private final CompletableDeferred<Unit> agentStarted;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final SshAgentIpcFactory ipcFactory;

    public SshAgentForwarder(@NotNull Lifetime lifetime, @NotNull SshAgentConnection sshRemoteAgentProxy, @Nullable String ipcKeyToReuse) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)sshRemoteAgentProxy, (String)"sshRemoteAgentProxy");
        this.lifetime = lifetime;
        this.sshRemoteAgentProxy = sshRemoteAgentProxy;
        this.ipcKeyToReuse = ipcKeyToReuse;
        this.lifetime.onTermination(() -> SshAgentForwarder._init_$lambda$0(this));
        this.forwardingThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"SshAgentForwarder", (int)0, () -> SshAgentForwarder.forwardingThread$lambda$0(this), (int)20, null);
        this.ipcKey$delegate = LazyKt.lazy(() -> SshAgentForwarder.ipcKey_delegate$lambda$0(this));
        this.agentIpc$delegate = LazyKt.lazy(() -> SshAgentForwarder.agentIpc_delegate$lambda$0(this));
        this.agentStarted = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final String getIpcKey() {
        Lazy lazy = this.ipcKey$delegate;
        return (String)lazy.getValue();
    }

    private final SshAgentIpc getAgentIpc() {
        Lazy lazy = this.agentIpc$delegate;
        return (SshAgentIpc)lazy.getValue();
    }

    @TestOnly
    @NotNull
    public final SshAgentIpc getSshAgentIpc() {
        return this.getAgentIpc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startForwarding() {
        try {
            this.getAgentIpc().open();
            this.agentStarted.complete((Object)Unit.INSTANCE);
            logger.info("Starting operation thread");
            while (RLifetimeKt.isAlive((Lifetime)this.lifetime) && this.getAgentIpc().isOpen()) {
                try {
                    Closeable closeable = this.getAgentIpc().accept();
                    Throwable throwable = null;
                    try {
                        SshAgentIpc.Streams streams = (SshAgentIpc.Streams)closeable;
                        boolean bl = false;
                        logger.info("Server IPC connected");
                        try {
                            this.processAcceptedIPC(streams);
                        }
                        catch (ClosedChannelException e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            logger.error("Exception while processing incoming connection", t);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (ClosedChannelException e) {
                    logger.info("IPC " + this.getAgentIpc().getKey() + " is closed. Exiting thread. Exception message: " + e.getMessage());
                    break;
                }
            }
        }
        catch (IOException e) {
            logger.error("Can't open Unix socket for ssh forwarding", (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("Unexpected error during IPC", e);
        }
        finally {
            try {
                this.getAgentIpc().close();
            }
            catch (IOException e) {
                logger.error("Exception occurred on IPC closing", (Throwable)e);
            }
            logger.trace("Cleaning up " + this.getAgentIpc().getKey());
            try {
                this.getAgentIpc().cleanup();
            }
            catch (Throwable t) {
                logger.warn("Failed to cleanup IPC: " + t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void processAcceptedIPC(SshAgentIpc.Streams streams) {
        var2_2 = new DataInputStream(streams.getInputStream());
        var3_3 = null;
        try {
            dataInputStream = (DataInputStream)var2_2;
            $i$a$-use-SshAgentForwarder$processAcceptedIPC$1 = false;
            var6_8 = new DataOutputStream(streams.getOutputStream());
            var7_9 = null;
            try {
                dataOutputStream = (DataOutputStream)var6_8;
                $i$a$-use-SshAgentForwarder$processAcceptedIPC$1$1 = false;
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        messageSize = dataInputStream.readInt();
                        $this$trace$iv = SshAgentForwarder.logger;
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var13_21 = $this$trace$iv;
                            $i$a$-trace-SshAgentForwarder$processAcceptedIPC$1$1$1 = false;
                            var13_21.trace("Request length: " + messageSize);
                        }
                        messageBytes = dataInputStream.readNBytes(messageSize);
                        var12_19 = new DataInputStream(new ByteArrayInputStream(messageBytes));
                        var14_22 = null;
                        try {
                            incomingMessageStream = (DataInputStream)var12_19;
                            $i$a$-use-SshAgentForwarder$processAcceptedIPC$1$1$2 = false;
                            this.processIncomingMessage(incomingMessageStream, dataOutputStream);
                            var15_24 = Unit.INSTANCE;
                        }
                        catch (Throwable var16_26) {
                            var14_22 = var16_26;
                            throw var16_26;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var12_19, (Throwable)var14_22);
                            continue;
                        }
                        break;
                    }
                }
                catch (EOFException <unused var>) {
                    SshAgentForwarder.logger.info("Reached EOF. Return.");
                }
                catch (ClosedChannelException e) {
                    SshAgentForwarder.logger.info("Channel is closed, terminating");
                    throw e;
                }
                catch (Throwable t) {
                    SshAgentForwarder.logger.error("Unexpected exception while communicating with ssh-agent", t);
                }
                ** GOTO lbl-1000
                var8_10 = Unit.INSTANCE;
            }
            catch (Throwable var9_12) {
                var7_9 = var9_12;
                throw var9_12;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var6_8, (Throwable)var7_9);
            }
            var4_4 = Unit.INSTANCE;
        }
        catch (Throwable var5_6) {
            var3_3 = var5_6;
            throw var5_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var2_2, (Throwable)var3_3);
        }
    }

    private final void processIncomingMessage(DataInputStream incomingMessageStream, DataOutputStream dataOutputStream) {
        byte messageType = incomingMessageStream.readByte();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outgoingMessageStream = new DataOutputStream(byteArrayOutputStream);
        byte by = messageType;
        if (by == SSH_AGENT_COMMAND.SSH_AGENTC_EXTENSION.getValue()) {
            Logger logger;
            Logger $this$trace$iv = SshAgentForwarder.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Got SSH_AGENTC_EXTENSION");
            }
            String extension = incomingMessageStream.readUTF();
            Logger $this$trace$iv2 = SshAgentForwarder.logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Extension asked: " + extension);
            }
            outgoingMessageStream.writeByte(SSH_AGENT_COMMAND.SSH_AGENT_FAILURE.getValue());
        } else if (by == SSH_AGENT_COMMAND.SSH_AGENTC_REQUEST_IDENTITIES.getValue()) {
            List $i$f$trace3;
            Logger logger;
            Logger $this$trace$iv = SshAgentForwarder.logger;
            boolean $i$f$trace3 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Got SSH_AGENTC_REQUEST_IDENTITIES");
            }
            try {
                $i$f$trace3 = this.sshRemoteAgentProxy.requestIdentities(new RequestIdentitiesArg(this.getAgentIpc().getRequesterProcessInfo()));
            }
            catch (Throwable t) {
                SshAgentForwarder.logger.warn("Exception occurred while requesting identities from the remote machine. Empty list will be passed.", t);
                $i$f$trace3 = CollectionsKt.emptyList();
            }
            List sshKeyIdentities = $i$f$trace3;
            Logger $this$trace$iv3 = SshAgentForwarder.logger;
            boolean $i$f$trace42 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("Got ssh key identities from the remote machine");
            }
            outgoingMessageStream.writeByte(SSH_AGENT_COMMAND.SSH_AGENT_IDENTITIES_ANSWER.getValue());
            outgoingMessageStream.writeInt(sshKeyIdentities.size());
            for (SshKeyIdentity $i$f$trace42 : sshKeyIdentities) {
                byte[] keyBlob = $i$f$trace42.component1();
                byte[] comment = $i$f$trace42.component2();
                outgoingMessageStream.writeInt(keyBlob.length);
                outgoingMessageStream.write(keyBlob);
                outgoingMessageStream.writeInt(comment.length);
                outgoingMessageStream.write(comment);
            }
        } else if (by == SSH_AGENT_COMMAND.SSH_AGENTC_SIGN_REQUEST.getValue()) {
            Logger logger;
            Logger $this$trace$iv = SshAgentForwarder.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Got SSH_AGENTC_SIGN_REQUEST");
            }
            int keyBlobSize = incomingMessageStream.readInt();
            byte[] keyBlob = incomingMessageStream.readNBytes(keyBlobSize);
            int dataSize = incomingMessageStream.readInt();
            byte[] data = incomingMessageStream.readNBytes(dataSize);
            int flags = incomingMessageStream.readInt();
            Intrinsics.checkNotNull((Object)keyBlob);
            Intrinsics.checkNotNull((Object)data);
            SignRequestResult signRequestResult = this.sshRemoteAgentProxy.sign(new SignRequestArg(keyBlob, data, UInt.constructor-impl((int)flags), this.getAgentIpc().getRequesterProcessInfo(), null));
            Logger $this$trace$iv4 = SshAgentForwarder.logger;
            boolean $i$f$trace5 = false;
            if ($this$trace$iv4.isTraceEnabled()) {
                logger = $this$trace$iv4;
                boolean bl = false;
                logger.trace("Got sign result from the remote machine");
            }
            SignRequestResult signRequestResult2 = signRequestResult;
            if (signRequestResult2 instanceof SuccessSignRequestResult) {
                Logger $this$trace$iv5 = SshAgentForwarder.logger;
                $i$f$trace = false;
                if ($this$trace$iv5.isTraceEnabled()) {
                    logger = $this$trace$iv5;
                    boolean bl = false;
                    logger.trace("Sign request is successful");
                }
                outgoingMessageStream.writeByte(SSH_AGENT_COMMAND.SSH_AGENT_SIGN_RESPONSE.getValue());
                outgoingMessageStream.writeInt(((SuccessSignRequestResult)signRequestResult).getSignature().length);
                outgoingMessageStream.write(((SuccessSignRequestResult)signRequestResult).getSignature());
            } else if (signRequestResult2 instanceof FailureSignRequestResult) {
                Logger $this$trace$iv6 = SshAgentForwarder.logger;
                $i$f$trace = false;
                if ($this$trace$iv6.isTraceEnabled()) {
                    logger = $this$trace$iv6;
                    boolean bl = false;
                    logger.trace("Sign request was failed or denied on the remote machine");
                }
                outgoingMessageStream.writeByte(SSH_AGENT_COMMAND.SSH_AGENT_FAILURE.getValue());
            }
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Unknown command: " + messageType);
            }
        }
        byte[] resultToWrite = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(resultToWrite.length);
        dataOutputStream.write(resultToWrite);
    }

    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.forwardingThread.isAlive())) {
            boolean bl = false;
            String string = "Only one instance of forwarder may be active at the time.";
            throw new IllegalArgumentException(string.toString());
        }
        this.forwardingThread.start();
        Object object = this.agentStarted.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void waitFor(long timeoutMs) {
        this.forwardingThread.join(timeoutMs);
    }

    public final boolean isAlive() {
        return this.forwardingThread.isAlive();
    }

    public final void close() {
        this.getAgentIpc().close();
    }

    private static final Unit _init_$lambda$0(SshAgentForwarder this$0) {
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            this$0.close();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        return Unit.INSTANCE;
    }

    private static final Unit forwardingThread$lambda$0(SshAgentForwarder this$0) {
        try {
            this$0.startForwarding();
        }
        catch (Throwable e) {
            logger.error("SshAgentForwarder failed unexpectedly", e);
        }
        return Unit.INSTANCE;
    }

    private static final String ipcKey_delegate$lambda$0(SshAgentForwarder this$0) {
        String string;
        block4: {
            block3: {
                string = this$0.ipcKeyToReuse;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                String string2 = ipcFactory.exists(this$0.ipcKeyToReuse) ? null : this$0.ipcKeyToReuse;
                string = string2;
                if (string2 != null) break block4;
            }
            string = ipcFactory.generateKey();
        }
        return string;
    }

    private static final SshAgentIpc agentIpc_delegate$lambda$0(SshAgentForwarder this$0) {
        return ipcFactory.create(this$0.getIpcKey());
    }

    static {
        SshAgentIpcFactory sshAgentIpcFactory;
        Companion = new Companion(null);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshAgentForwarder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SshAgentForwarder.logger = logger;
        if (SystemInfoRt.isUnix) {
            sshAgentIpcFactory = new UnixDomainSocketAgentIpcFactory();
        } else if (SystemInfoRt.isWindows) {
            sshAgentIpcFactory = new WindowsNamedPipeSshAgentIpcFactory();
        } else {
            throw new IllegalStateException("Unknown os family: isUnix=false, isWindows=false".toString());
        }
        ipcFactory = sshAgentIpcFactory;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentForwarder$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "ipcFactory", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpcFactory;", "getIpcFactory", "()Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpcFactory;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SshAgentIpcFactory getIpcFactory() {
            return ipcFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

