/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.DeferredIconListener;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.ide.model.DeferredIconCalculationResult;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.ShellModel_GeneratedKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.ui.BackendDeferredIconConverterKt;
import com.jetbrains.rdserver.ui.BackendDeferredIconStorage;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Ljavax/swing/Icon;", "Lcom/jetbrains/rd/ide/model/IconModel;", "<init>", "()V", "createIcon", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "MyListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDeferredIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,172:1\n67#2,4:173\n42#3,3:177\n*S KotlinDebug\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconConverter\n*L\n48#1:173,4\n51#1:177,3\n*E\n"})
public final class BackendDeferredIconConverter
implements ProtocolIconConverter<Icon, IconModel> {
    @Nullable
    public Icon createIcon(@NotNull IconModel model2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return null;
    }

    @Nullable
    public IconModel createModel(@NotNull Icon icon2, @NotNull ProtocolIconModelRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!(icon2 instanceof DeferredIconImpl)) {
            return null;
        }
        if (((DeferredIconImpl)icon2).isDone()) {
            Logger $this$trace$iv = BackendDeferredIconConverterKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Deferred icon " + ((DeferredIconImpl)icon2).getUniqueId() + " is already evaluated. Return underlying icon");
            }
            return registry.createModel(((DeferredIconImpl)icon2).retrieveIcon());
        }
        boolean $i$f$service = false;
        Class<BackendDeferredIconStorage> serviceClass$iv = BackendDeferredIconStorage.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (IconModel)((BackendDeferredIconStorage)object).getOrCreateModel((DeferredIconImpl)icon2, registry);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/ui/BackendDeferredIconConverter$MyListener;", "Lcom/intellij/ui/DeferredIconListener;", "<init>", "()V", "evaluated", "", "deferred", "Lcom/intellij/ui/DeferredIcon;", "result", "Ljavax/swing/Icon;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendDeferredIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconConverter$MyListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,172:1\n67#2,4:173\n67#2,4:177\n*S KotlinDebug\n*F\n+ 1 BackendDeferredIconConverter.kt\ncom/jetbrains/rdserver/ui/BackendDeferredIconConverter$MyListener\n*L\n63#1:173,4\n65#1:177,4\n*E\n"})
    public static final class MyListener
    implements DeferredIconListener {
        public void evaluated(@NotNull DeferredIcon deferred, @NotNull Icon result) {
            Intrinsics.checkNotNullParameter((Object)deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (!(deferred instanceof DeferredIconImpl)) {
                return;
            }
            List remoteAppSessions = ClientSessionsUtil.sessions((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.REMOTE);
            if (!((Collection)remoteAppSessions).isEmpty()) {
                Logger logger;
                DeferredIconCalculationResult iconCalculationResult = new DeferredIconCalculationResult(((DeferredIconImpl)deferred).getUniqueId(), UtilKt.toModel((Icon)result));
                Logger $this$trace$iv = BackendDeferredIconConverterKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Deferred icon " + ((DeferredIconImpl)deferred).getUniqueId() + " is converted to model. Firing to all clients");
                }
                for (ClientAppSession session : remoteAppSessions) {
                    Logger $this$trace$iv2 = BackendDeferredIconConverterKt.access$getLOG$p();
                    boolean $i$f$trace2 = false;
                    if ($this$trace$iv2.isTraceEnabled()) {
                        logger = $this$trace$iv2;
                        boolean bl = false;
                        logger.trace("Firing calculated deferred icon model (" + ((DeferredIconImpl)deferred).getUniqueId() + ") to client " + session.getClientId());
                    }
                    Protocol protocol = RemoteSessionKt.getProtocol(session);
                    ShellModel_GeneratedKt.getShellModel((IProtocol)((IProtocol)protocol)).getDeferredIconReady().fire((Object)iconCalculationResult);
                }
            }
        }
    }
}

