/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.ui.TabbedPane;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeLabel;
import com.jetbrains.ide.model.uiautomation.BeTab;
import com.jetbrains.ide.model.uiautomation.BeTabbedControl;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslContainerKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslTextPresentationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/ui/converters/BeTabbedPaneWrapperHandler;", "", "tabs", "Lcom/intellij/ui/TabbedPane;", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/ui/TabbedPane;Lcom/jetbrains/rdserver/ui/converters/TrackOptions;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getTrackOptions", "()Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "control", "Lcom/jetbrains/ide/model/uiautomation/BeTabbedControl;", "getControl", "()Lcom/jetbrains/ide/model/uiautomation/BeTabbedControl;", "updateTabs", "", "updateSelection", "createTabModel", "Lcom/jetbrains/ide/model/uiautomation/BeTab;", "index", "", "intellij.platform.backend.split"})
public final class BeTabbedPaneWrapperHandler {
    @NotNull
    private final TrackOptions trackOptions;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final BeTabbedControl control;

    public BeTabbedPaneWrapperHandler(@NotNull TabbedPane tabs, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.trackOptions = trackOptions;
        this.lifetime = lifetime;
        this.control = BeDslContainerKt.tabbedControl$default(null, null, (int)3, null);
        this.updateTabs(tabs);
    }

    @NotNull
    public final TrackOptions getTrackOptions() {
        return this.trackOptions;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final BeTabbedControl getControl() {
        return this.control;
    }

    private final void updateTabs(TabbedPane tabs) {
        this.control.getTabs().clear();
        int n = tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            BeTab tabControl = this.createTabModel(tabs, i);
            this.control.getTabs().add((Object)tabControl);
        }
        this.updateSelection(tabs);
    }

    private final void updateSelection(TabbedPane tabs) {
        this.control.getSelectedIndex().set((Object)RangesKt.coerceAtLeast((int)tabs.getSelectedIndex(), (int)0));
    }

    private final BeTab createTabModel(TabbedPane tabs, int index) {
        String title = tabs.getTitleAt(index);
        Intrinsics.checkNotNull((Object)title);
        return BeDslContainerKt.tab$default((BeLabel)BeDslTextPresentationKt.label$default((String)title, null, (boolean)false, (int)6, null), (boolean)false, () -> BeTabbedPaneWrapperHandler.createTabModel$lambda$0(tabs, index, this), (int)2, null);
    }

    private static final BeControl createTabModel$lambda$0(TabbedPane $tabs, int $index, BeTabbedPaneWrapperHandler this$0) {
        Component component = $tabs.getComponentAt($index);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponentAt(...)");
        return ConverterRegistryKt.toBeModel(component, this$0.trackOptions, this$0.lifetime);
    }
}

