/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorInlaySynchronizer;", "Lcom/intellij/openapi/editor/InlayModel$Listener;", "from", "Lcom/intellij/openapi/editor/ex/EditorEx;", "to", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getTo", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "map", "", "Lcom/intellij/openapi/editor/Inlay;", "onAdded", "", "inlay", "onUpdated", "changeFlags", "", "onRemoved", "copy", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEditorComponentImplConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorInlaySynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n1915#2,2:400\n*S KotlinDebug\n*F\n+ 1 EditorComponentImplConverter.kt\ncom/jetbrains/rdserver/ui/converters/EditorInlaySynchronizer\n*L\n253#1:400,2\n*E\n"})
final class EditorInlaySynchronizer
implements InlayModel.Listener {
    @NotNull
    private final EditorEx to;
    @NotNull
    private final Map<Inlay<?>, Inlay<?>> map;

    public EditorInlaySynchronizer(@NotNull EditorEx from, @NotNull EditorEx to, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.to = to;
        this.map = new LinkedHashMap();
        from.getInlayModel().addListener((InlayModel.Listener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        List list = from.getInlayModel().getBlockElementsInRange(0, from.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.copy(it);
        }
    }

    @NotNull
    public final EditorEx getTo() {
        return this.to;
    }

    public void onAdded(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.copy(inlay);
    }

    public void onUpdated(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.onRemoved(inlay);
        this.onAdded(inlay);
    }

    public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.onUpdated(inlay);
    }

    public void onRemoved(@NotNull Inlay<?> inlay) {
        block0: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Inlay<?> inlay2 = this.map.remove(inlay);
            if (inlay2 == null) break block0;
            inlay2.dispose();
        }
    }

    private final void copy(Inlay<?> inlay) {
        if (!inlay.isValid()) {
            return;
        }
        InlayProperties inlayProperties = inlay.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)inlayProperties, (String)"getProperties(...)");
        InlayProperties inlayProperties2 = inlayProperties;
        Inlay inlayCopy = switch (WhenMappings.$EnumSwitchMapping$0[inlay.getPlacement().ordinal()]) {
            case 1, 2 -> this.to.getInlayModel().addBlockElement(inlay.getOffset(), inlayProperties2, inlay.getRenderer());
            case 3 -> this.to.getInlayModel().addInlineElement(inlay.getOffset(), inlayProperties2, inlay.getRenderer());
            case 4 -> this.to.getInlayModel().addAfterLineEndElement(inlay.getOffset(), inlayProperties2, inlay.getRenderer());
            default -> throw new NoWhenBranchMatchedException();
        };
        this.map.put(inlay, inlayCopy);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Inlay.Placement.values().length];
            try {
                nArray[Inlay.Placement.ABOVE_LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inlay.Placement.BELOW_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inlay.Placement.INLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inlay.Placement.AFTER_LINE_END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

