/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.TerminalExecutionConsole;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jetbrains.codeWithMe.model.BeTerminalScreenState;
import com.jetbrains.codeWithMe.model.BeTerminalWidget;
import com.jetbrains.codeWithMe.model.BeTerminalWidgetOutput;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TerminalWidgetConverter;
import com.jetbrains.rdserver.ui.converters.TerminalWidgetConverterKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/ui/converters/TerminalWidgetConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Lcom/intellij/terminal/JBTerminalWidget;", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "adviseOnRemoteInput", "", "widgetModel", "Lcom/jetbrains/codeWithMe/model/BeTerminalWidget;", "adviseOnTextChange", "outputFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/jetbrains/codeWithMe/model/BeTerminalWidgetOutput;", "createOutputFlow", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nTerminalWidgetConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalWidgetConverter.kt\ncom/jetbrains/rdserver/ui/converters/TerminalWidgetConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n13#2:211\n*S KotlinDebug\n*F\n+ 1 TerminalWidgetConverter.kt\ncom/jetbrains/rdserver/ui/converters/TerminalWidgetConverter\n*L\n97#1:211\n*E\n"})
public final class TerminalWidgetConverter
implements RdConverter<JBTerminalWidget> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public BeControl convert(@NotNull JBTerminalWidget component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Project project = component.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BeTerminalWidget widgetModel = new BeTerminalWidget(ProjectUtilKt.getRdProjectId((Project)project));
        MutableSharedFlow<BeTerminalWidgetOutput> outputFlow = this.createOutputFlow(widgetModel, lifetime);
        this.adviseOnTextChange(widgetModel, component, outputFlow, lifetime);
        this.adviseOnRemoteInput(widgetModel, component, lifetime);
        return (BeControl)widgetModel;
    }

    private final void adviseOnRemoteInput(BeTerminalWidget widgetModel, JBTerminalWidget component, Lifetime lifetime) {
        widgetModel.getInput().advise(lifetime, arg_0 -> TerminalWidgetConverter.adviseOnRemoteInput$lambda$0(component, arg_0));
    }

    private final void adviseOnTextChange(BeTerminalWidget widgetModel, JBTerminalWidget component, MutableSharedFlow<BeTerminalWidgetOutput> outputFlow, Lifetime lifetime) {
        widgetModel.getInitialState().set((Object)TerminalWidgetConverterKt.createScreenStateModel((JediTermWidget)component));
        Object object = component.getData(LangDataKeys.CONSOLE_VIEW.getName());
        TerminalExecutionConsole terminalExecutionConsole = object instanceof TerminalExecutionConsole ? (TerminalExecutionConsole)object : null;
        if (terminalExecutionConsole == null) {
            TerminalWidgetConverter $this$adviseOnTextChange_u24lambda_u240 = this;
            boolean bl = false;
            logger.error("Failed to get TerminalExecutionConsole from JBTerminalWidget, title = " + component.getTerminalTitle());
            return;
        }
        TerminalExecutionConsole console = terminalExecutionConsole;
        console.flushImmediately();
        console.addChangeListener(new ObservableConsoleView.ChangeListener(outputFlow){
            final /* synthetic */ MutableSharedFlow<BeTerminalWidgetOutput> $outputFlow;
            {
                this.$outputFlow = $outputFlow;
            }

            public void textAdded(String text, ConsoleViewContentType type) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                String string = type.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.$outputFlow.tryEmit((Object)new BeTerminalWidgetOutput(text, string));
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    private final MutableSharedFlow<BeTerminalWidgetOutput> createOutputFlow(BeTerminalWidget widgetModel, Lifetime lifetime) {
        MutableSharedFlow outputFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)Integer.MAX_VALUE, null, (int)5, null);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableSharedFlow<BeTerminalWidgetOutput>)outputFlow, (CompletableDeferred<Unit>)deferred, widgetModel, null){
            int label;
            final /* synthetic */ MutableSharedFlow<BeTerminalWidgetOutput> $outputFlow;
            final /* synthetic */ CompletableDeferred<Unit> $deferred;
            final /* synthetic */ BeTerminalWidget $widgetModel;
            {
                this.$outputFlow = $outputFlow;
                this.$deferred = $deferred;
                this.$widgetModel = $widgetModel;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$outputFlow.collect(new FlowCollector(this.$deferred, this.$widgetModel){
                            final /* synthetic */ CompletableDeferred<Unit> $deferred;
                            final /* synthetic */ BeTerminalWidget $widgetModel;
                            {
                                this.$deferred = $deferred;
                                this.$widgetModel = $widgetModel;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object emit(BeTerminalWidgetOutput it, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof createOutputFlow.emit.1)) ** GOTO lbl-1000
                                var4_3 = $completion;
                                if ((var4_3.label & -2147483648) != 0) {
                                    var4_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ createOutputFlow.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        $continuation.L$0 = it;
                                        $continuation.label = 1;
                                        v0 = this.$deferred.await((Continuation)$continuation);
                                        if (v0 == var5_5) {
                                            return var5_5;
                                        }
                                        ** GOTO lbl22
                                    }
                                    case 1: {
                                        it = (BeTerminalWidgetOutput)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl22:
                                        // 2 sources

                                        this.$widgetModel.getOutput().fire((Object)it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        SourceExKt.adviseUntil((ISource)widgetModel.getInitialState().getChange(), (Lifetime)lifetime, arg_0 -> TerminalWidgetConverter.createOutputFlow$lambda$0(deferred, arg_0));
        return outputFlow;
    }

    private static final Unit adviseOnRemoteInput$lambda$0(JBTerminalWidget $component, List bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        $component.getTtyConnector().write(CollectionsKt.toByteArray((Collection)bytes));
        return Unit.INSTANCE;
    }

    private static final boolean createOutputFlow$lambda$0(CompletableDeferred $deferred, BeTerminalScreenState it) {
        if (it != null) {
            return false;
        }
        $deferred.complete((Object)Unit.INSTANCE);
        return true;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalWidgetConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TerminalWidgetConverter.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/ui/converters/TerminalWidgetConverter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

