/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.BulkProcessingFinished;
import com.intellij.diff.merge.ChangeProcessed;
import com.intellij.diff.merge.ChangeResolved;
import com.intellij.diff.merge.ChangeSideResolved;
import com.intellij.diff.merge.InitChangeData;
import com.intellij.diff.merge.MergeConflictModelKt;
import com.intellij.diff.merge.MergeEvent;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.MergeModelEventListener;
import com.intellij.diff.merge.TextAutoResolver;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictResolutionStrategy;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001OB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0001J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\tJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020\u0014J \u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020(2\u0006\u0010)\u001a\u00020 H\u0007J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0007J \u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\tH\u0007J\u0010\u0010/\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u00100\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0007J\"\u00103\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020(2\u0006\u0010)\u001a\u00020 H\u0007J\u0018\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\n2\u0006\u0010!\u001a\u00020(H\u0003J\u0010\u00104\u001a\u00020\u00142\u0006\u00106\u001a\u00020'H\u0007J\u0016\u00107\u001a\u00020 2\u0006\u00106\u001a\u00020'2\u0006\u0010!\u001a\u00020\"J\u0010\u00108\u001a\u00020 2\u0006\u00105\u001a\u00020\nH\u0002J\b\u00109\u001a\u00020\u0014H\u0016JA\u0010:\u001a\u00020 2\r\u0010;\u001a\t\u0018\u00010.\u00a2\u0006\u0002\b<2\b\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020DJG\u0010:\u001a\u00020 2\r\u0010;\u001a\t\u0018\u00010.\u00a2\u0006\u0002\b<2\b\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010E\u001a\u00020?2\u0006\u0010@\u001a\u00020 2\b\u0010A\u001a\u0004\u0018\u00010B2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00140FJ\u0010\u0010G\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020JH\u0002J\u0018\u0010K\u001a\u00020\u00142\u0006\u00105\u001a\u00020\n2\u0006\u0010!\u001a\u00020(H\u0002J\u0010\u0010L\u001a\u00020\u00142\u0006\u00105\u001a\u00020\nH\u0002J\u0010\u0010M\u001a\u00020\u00142\u0006\u00105\u001a\u00020\nH\u0002J\b\u0010N\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/diff/merge/MergeConflictModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeRequest", "Lcom/intellij/diff/merge/TextMergeRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diff/merge/TextMergeRequest;)V", "mergeChanges", "", "Lcom/intellij/diff/merge/TextMergeChange;", "resultModel", "Lcom/intellij/diff/merge/MergeModelBase;", "Lcom/intellij/diff/merge/TextMergeChange$State;", "textAutoResolver", "Lcom/intellij/diff/merge/TextAutoResolver;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/diff/merge/MergeModelEventListener;", "addListener", "", "listener", "parentDisposable", "initWithData", "changesDatas", "Lcom/intellij/diff/merge/InitChangeData;", "getAllChanges", "getUnresolvedChanges", "getAutoResolvableChanges", "getImportChanges", "getSemanticallyResolvableChanges", "hasNonConflictedChanges", "", "side", "Lcom/intellij/diff/util/ThreeSide;", "hasAutoResolvableConflictedChanges", "clear", "ignoreChange", "index", "", "Lcom/intellij/diff/util/Side;", "resolveChange", "resolveChangeAutomatically", "Lcom/intellij/diff/util/LineRange;", "replaceChangeWithAi", "newContentLines", "", "resetResolvedChange", "replaceWithNewContent", "newContent", "", "replaceChange", "markChangeResolved", "change", "changeIndex", "canResolveChangeAutomatically", "isChangeRangeModified", "dispose", "executeMergeCommand", "commandName", "Lcom/intellij/openapi/util/NlsContexts$Command;", "string", "undoPolicy", "Lcom/intellij/openapi/command/UndoConfirmationPolicy;", "bulkUpdate", "affectedIndexes", "Lit/unimi/dsi/fastutil/ints/IntList;", "task", "Ljava/lang/Runnable;", "undoConfirmationPolicy", "Lkotlin/Function0;", "getByIndex", "fireEvent", "event", "Lcom/intellij/diff/merge/MergeEvent;", "fireChangeSideResolved", "fireChangeResolved", "fireChangeProcessed", "fireBulkProcessingFinished", "MergeModelImpl", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMergeConflictModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictModel.kt\ncom/intellij/diff/merge/MergeConflictModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n832#2:368\n862#2,2:369\n777#2:371\n873#2,2:372\n777#2:374\n873#2,2:375\n777#2:377\n873#2,2:378\n1807#2,3:380\n1807#2,3:383\n*S KotlinDebug\n*F\n+ 1 MergeConflictModel.kt\ncom/intellij/diff/merge/MergeConflictModel\n*L\n58#1:368\n58#1:369,2\n59#1:371\n59#1:372,2\n60#1:374\n60#1:375,2\n62#1:377\n62#1:378,2\n64#1:380,3\n68#1:383,3\n*E\n"})
public final class MergeConflictModel
implements Disposable {
    @NotNull
    private final TextMergeRequest mergeRequest;
    @NotNull
    private List<TextMergeChange> mergeChanges;
    @NotNull
    private final MergeModelBase<TextMergeChange.State> resultModel;
    @NotNull
    private final TextAutoResolver textAutoResolver;
    @NotNull
    private final EventDispatcher<MergeModelEventListener> dispatcher;

    public MergeConflictModel(@Nullable Project project, @NotNull TextMergeRequest mergeRequest) {
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        this.mergeRequest = mergeRequest;
        this.mergeChanges = CollectionsKt.emptyList();
        this.resultModel = new MergeModelImpl(project);
        this.textAutoResolver = new TextAutoResolver(this.mergeRequest);
        EventDispatcher eventDispatcher = EventDispatcher.create(MergeModelEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
    }

    public final void addListener(@NotNull MergeModelEventListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public final void initWithData(@NotNull List<InitChangeData> changesDatas) {
        Intrinsics.checkNotNullParameter(changesDatas, (String)"changesDatas");
        this.clear();
        List lineRanges = MergeConflictModelKt.access$buildResultLineRanges(changesDatas);
        this.resultModel.setChanges(lineRanges);
        this.mergeChanges = MergeConflictModelKt.access$buildMergeChanges(changesDatas, this.resultModel);
    }

    @NotNull
    public final List<TextMergeChange> getAllChanges() {
        return CollectionsKt.toList((Iterable)this.mergeChanges);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextMergeChange> getUnresolvedChanges() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.mergeChanges;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            TextMergeChange it = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (it.isResolved()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextMergeChange> getAutoResolvableChanges() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mergeChanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextMergeChange it = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (!this.canResolveChangeAutomatically(it.getIndex(), ThreeSide.BASE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextMergeChange> getImportChanges() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mergeChanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextMergeChange it = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (!it.isImportChange()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextMergeChange> getSemanticallyResolvableChanges() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAutoResolvableChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextMergeChange it = (TextMergeChange)element$iv$iv;
            boolean bl = false;
            if (!(it.getConflictType().getResolutionStrategy() == MergeConflictResolutionStrategy.SEMANTIC)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasNonConflictedChanges(@NotNull ThreeSide side) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Iterable $this$any$iv = this.mergeChanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextMergeChange change = (TextMergeChange)element$iv;
                    boolean bl2 = false;
                    if (!(!change.isConflict() && this.canResolveChangeAutomatically(change.getIndex(), side))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasAutoResolvableConflictedChanges() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.mergeChanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextMergeChange change = (TextMergeChange)element$iv;
                    boolean bl2 = false;
                    if (!this.canResolveChangeAutomatically(change.getIndex(), ThreeSide.BASE)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void clear() {
        this.mergeChanges = CollectionsKt.emptyList();
        this.resultModel.setChanges(CollectionsKt.emptyList());
    }

    @RequiresEdt
    public final void ignoreChange(int index, @NotNull Side side, boolean resolveChange) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        TextMergeChange change = this.getByIndex(index);
        if (!change.isConflict() || resolveChange) {
            this.markChangeResolved(change.getIndex());
        } else {
            this.markChangeResolved(change, side);
        }
    }

    @RequiresWriteLock
    @Nullable
    public final LineRange resolveChangeAutomatically(int index, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        TextMergeChange change = this.getByIndex(index);
        if (!this.canResolveChangeAutomatically(change.getIndex(), side)) {
            return null;
        }
        if (change.isConflict()) {
            MergeConflictResolutionStrategy mergeConflictResolutionStrategy = change.getConflictType().getResolutionStrategy();
            if (mergeConflictResolutionStrategy == null) {
                return null;
            }
            MergeConflictResolutionStrategy resolutionStrategy = mergeConflictResolutionStrategy;
            if (WhenMappings.$EnumSwitchMapping$0[resolutionStrategy.ordinal()] == 1) {
                CharSequence charSequence = this.textAutoResolver.resolve(change);
                if (charSequence == null) {
                    return null;
                }
                CharSequence newContent = charSequence;
                return this.replaceWithNewContent(change.getIndex(), newContent);
            }
            return null;
        }
        Side masterSide = (Side)side.select((Object)Side.LEFT, (Object)(change.isChange(Side.LEFT) ? Side.LEFT : Side.RIGHT), (Object)Side.RIGHT);
        return this.replaceChange(change.getIndex(), masterSide, false);
    }

    @RequiresWriteLock
    @Nullable
    public final LineRange replaceChangeWithAi(int index, @NotNull List<String> newContentLines) {
        Intrinsics.checkNotNullParameter(newContentLines, (String)"newContentLines");
        TextMergeChange change = this.getByIndex(index);
        if (change.isResolved()) {
            return null;
        }
        this.resultModel.replaceChange(change.getIndex(), newContentLines);
        change.markChangeResolvedWithAI();
        this.markChangeResolved(change.getIndex());
        return new LineRange(this.resultModel.getLineStart(change.getIndex()), this.resultModel.getLineEnd(change.getIndex()));
    }

    @RequiresWriteLock
    public final void resetResolvedChange(int index) {
        TextMergeChange change = this.getByIndex(index);
        if (!change.isResolved()) {
            return;
        }
        MergeLineFragment changeFragment = change.getFragment();
        int startLine = changeFragment.getStartLine(ThreeSide.BASE);
        int endLine = changeFragment.getEndLine(ThreeSide.BASE);
        Document content = MergeConflictModelKt.access$getDocument(this.mergeRequest, ThreeSide.BASE);
        List<String> list = DiffUtil.getLines(content, startLine, endLine);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLines(...)");
        List<String> baseContent = list;
        this.resultModel.replaceChange(change.getIndex(), baseContent);
        change.resetState();
        this.markChangeResolved(change.getIndex());
        this.resultModel.invalidateChange(change.getIndex());
    }

    @RequiresWriteLock
    @NotNull
    public final LineRange replaceWithNewContent(int index, @NotNull CharSequence newContent) {
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        TextMergeChange change = this.getByIndex(index);
        String[] newContentLines = LineTokenizer.Companion.tokenize$default((LineTokenizer.Companion)LineTokenizer.Companion, (CharSequence)newContent, (boolean)false, (boolean)false, (int)4, null);
        this.resultModel.replaceChange(change.getIndex(), CollectionsKt.listOf((Object[])Arrays.copyOf(newContentLines, newContentLines.length)));
        this.markChangeResolved(change.getIndex());
        return new LineRange(this.resultModel.getLineStart(change.getIndex()), this.resultModel.getLineEnd(change.getIndex()));
    }

    @RequiresWriteLock
    @Nullable
    public final LineRange replaceChange(int index, @NotNull Side side, boolean resolveChange) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        TextMergeChange change = this.getByIndex(index);
        if (change.isResolved(side)) {
            return null;
        }
        if (!change.isChange(side)) {
            this.markChangeResolved(change.getIndex());
            return null;
        }
        ThreeSide sourceSide = (ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        ThreeSide oppositeSide = (ThreeSide)side.select((Object)ThreeSide.RIGHT, (Object)ThreeSide.LEFT);
        Document sourceDocument = MergeConflictModelKt.access$getDocument(this.mergeRequest, sourceSide);
        int sourceStartLine = change.getStartLine(sourceSide);
        int sourceEndLine = change.getEndLine(sourceSide);
        List<String> list = DiffUtil.getLines(sourceDocument, sourceStartLine, sourceEndLine);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLines(...)");
        List<String> newContent = list;
        int newLineStart = 0;
        if (change.isConflict()) {
            boolean append = change.isOnesideAppliedConflict();
            if (append) {
                newLineStart = this.resultModel.getLineEnd(change.getIndex());
                this.resultModel.appendChange(change.getIndex(), newContent);
            } else {
                this.resultModel.replaceChange(change.getIndex(), newContent);
                newLineStart = this.resultModel.getLineStart(change.getIndex());
            }
            if (resolveChange || change.getStartLine(oppositeSide) == change.getEndLine(oppositeSide)) {
                this.markChangeResolved(change.getIndex());
            } else {
                change.markOnesideAppliedConflict();
                this.markChangeResolved(change, side);
            }
        } else {
            this.resultModel.replaceChange(change.getIndex(), newContent);
            newLineStart = this.resultModel.getLineStart(change.getIndex());
            this.markChangeResolved(change.getIndex());
        }
        int newLineEnd = this.resultModel.getLineEnd(change.getIndex());
        return new LineRange(newLineStart, newLineEnd);
    }

    @RequiresEdt
    private final void markChangeResolved(TextMergeChange change, Side side) {
        if (change.isResolved()) {
            return;
        }
        change.setResolved(side, true);
        this.fireChangeSideResolved(change, side);
        if (change.isResolved()) {
            this.fireChangeResolved(change);
        }
        this.resultModel.invalidateChange(change.getIndex());
    }

    @RequiresEdt
    public final void markChangeResolved(int changeIndex) {
        TextMergeChange change = this.getByIndex(changeIndex);
        if (change.isResolved()) {
            return;
        }
        change.setResolved(Side.LEFT, true);
        change.setResolved(Side.RIGHT, true);
        this.fireChangeResolved(change);
        this.resultModel.invalidateChange(change.getIndex());
    }

    public final boolean canResolveChangeAutomatically(int changeIndex, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        TextMergeChange change = this.getByIndex(changeIndex);
        if (change.isConflict()) {
            return side == ThreeSide.BASE && change.getConflictType().canBeResolved() && !change.isResolved(Side.LEFT) && !change.isResolved(Side.RIGHT) && (change.getConflictType().getResolutionStrategy() != MergeConflictResolutionStrategy.TEXT || !this.isChangeRangeModified(change));
        }
        return !change.isResolved() && change.isChange(side) && !this.isChangeRangeModified(change);
    }

    private final boolean isChangeRangeModified(TextMergeChange change) {
        MergeLineFragment changeFragment = change.getFragment();
        int baseStartLine = changeFragment.getStartLine(ThreeSide.BASE);
        int baseEndLine = changeFragment.getEndLine(ThreeSide.BASE);
        List list = this.mergeRequest.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        DocumentContent baseDiffContent = (DocumentContent)ThreeSide.BASE.select(list);
        Document document = baseDiffContent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document baseDocument = document;
        int resultStartLine = change.getResultStartLine();
        int resultEndLine = change.getResultEndLine();
        CharSequence charSequence = DiffUtil.getLinesContent(baseDocument, baseStartLine, baseEndLine);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLinesContent(...)");
        CharSequence baseContent = charSequence;
        CharSequence charSequence2 = DiffUtil.getLinesContent(this.mergeRequest.getOutputContent().getDocument(), resultStartLine, resultEndLine);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getLinesContent(...)");
        CharSequence resultContent = charSequence2;
        return !StringUtil.equals((CharSequence)baseContent, (CharSequence)resultContent);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.resultModel);
    }

    public final boolean executeMergeCommand(@Nullable String commandName, @Nullable String string, @NotNull UndoConfirmationPolicy undoPolicy, boolean bulkUpdate, @Nullable IntList affectedIndexes, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)undoPolicy, (String)"undoPolicy");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.executeMergeCommand(commandName, string, undoPolicy, bulkUpdate, affectedIndexes, (Function0<Unit>)((Function0)new Function0<Unit>((Object)task){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }));
    }

    public final boolean executeMergeCommand(@Nullable String commandName, @Nullable String string, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean bulkUpdate, @Nullable IntList affectedIndexes, @NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter((Object)undoConfirmationPolicy, (String)"undoConfirmationPolicy");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return this.resultModel.executeMergeCommand(commandName, string, undoConfirmationPolicy, bulkUpdate, affectedIndexes, () -> MergeConflictModel.executeMergeCommand$lambda$0(task));
    }

    private final TextMergeChange getByIndex(int index) {
        return this.mergeChanges.get(index);
    }

    private final void fireEvent(MergeEvent event) {
        ((MergeModelEventListener)this.dispatcher.getMulticaster()).onMergeEvent(event);
    }

    private final void fireChangeSideResolved(TextMergeChange change, Side side) {
        this.fireEvent(new ChangeSideResolved(change, side));
    }

    private final void fireChangeResolved(TextMergeChange change) {
        this.fireEvent(new ChangeResolved(change));
    }

    private final void fireChangeProcessed(TextMergeChange change) {
        this.fireEvent(new ChangeProcessed(change));
    }

    private final void fireBulkProcessingFinished() {
        this.fireEvent(BulkProcessingFinished.INSTANCE);
    }

    private static final void executeMergeCommand$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J*\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/merge/MergeConflictModel$MergeModelImpl;", "Lcom/intellij/diff/merge/MergeModelBase;", "Lcom/intellij/diff/merge/TextMergeChange$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/diff/merge/MergeConflictModel;Lcom/intellij/openapi/project/Project;)V", "onChangeUpdated", "", "index", "", "onBulkUpdateFinished", "storeChangeState", "restoreChangeState", "state", "processDocumentChange", "oldLine1", "oldLine2", "shift", "intellij.platform.diff.impl"})
    private final class MergeModelImpl
    extends MergeModelBase<TextMergeChange.State> {
        public MergeModelImpl(Project project) {
            Document document = MergeConflictModel.this.mergeRequest.getOutputContent().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            super(project, document);
        }

        @Override
        protected void onChangeUpdated(int index) {
            MergeConflictModel.this.fireChangeProcessed(MergeConflictModel.this.getByIndex(index));
        }

        @Override
        protected void onBulkUpdateFinished() {
            MergeConflictModel.this.fireBulkProcessingFinished();
        }

        @Override
        @NotNull
        protected TextMergeChange.State storeChangeState(int index) {
            return MergeConflictModel.this.getByIndex(index).storeState();
        }

        @Override
        protected void restoreChangeState(@NotNull TextMergeChange.State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super.restoreChangeState((MergeModelBase.State)state);
            TextMergeChange change = MergeConflictModel.this.getByIndex(state.getIndex());
            boolean wasResolved = change.isResolved();
            change.restoreState(state);
            if (wasResolved != change.isResolved()) {
                MergeConflictModel.this.fireChangeResolved(change);
            }
        }

        @Override
        @Nullable
        protected TextMergeChange.State processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
            TextMergeChange.State state = (TextMergeChange.State)super.processDocumentChange(index, oldLine1, oldLine2, shift);
            TextMergeChange change = MergeConflictModel.this.getByIndex(index);
            if (change.getResultStartLine() == change.getResultEndLine() && change.getConflictType().getType() == MergeConflictType.Type.DELETED && !change.isResolved()) {
                MergeConflictModel.this.markChangeResolved(change.getIndex());
            }
            return state;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MergeConflictResolutionStrategy.values().length];
            try {
                nArray[MergeConflictResolutionStrategy.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

