/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.ApplySelectedChangesActionBase;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.merge.TextMergeChange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\nH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\nH\u0014J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/merge/ResolveSelectedChangesAction;", "Lcom/intellij/diff/merge/ApplySelectedChangesActionBase;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Lcom/intellij/diff/merge/MergeThreesideViewer;Lcom/intellij/diff/util/Side;)V", "apply", "", "Lcom/intellij/diff/util/ThreeSide;", "changes", "", "Lcom/intellij/diff/merge/TextMergeChange;", "getText", "", "isVisible", "", "isEnabled", "change", "intellij.platform.diff.impl"})
public final class ResolveSelectedChangesAction
extends ApplySelectedChangesActionBase {
    @NotNull
    private final Side side;

    public ResolveSelectedChangesAction(@NotNull MergeThreesideViewer viewer, @NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        super(viewer);
        this.side = side;
    }

    @Override
    protected void apply(@NotNull ThreeSide side, @NotNull List<TextMergeChange> changes) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.getViewer().replaceChanges(changes, this.side, true);
    }

    @Override
    @NotNull
    protected String getText(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Object[] objectArray = new Object[]{side.getIndex()};
        String string = DiffBundle.message((String)"action.presentation.merge.resolve.using.side.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected boolean isVisible(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == ThreeSide.BASE) {
            return true;
        }
        return side == this.side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
    }

    @Override
    protected boolean isEnabled(@NotNull TextMergeChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return !change.isResolved(this.side);
    }
}

