/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffPanel
extends DiffPanelBase {
    @NonNls
    private static final String GOOD_CONTENT = "GoodContent";
    @NonNls
    private static final String LOADING_CONTENT = "LoadingContent";
    @NonNls
    private static final String TOO_BIG_CONTENT = "TooBigContent";
    @NonNls
    private static final String OPERATION_CANCELED_CONTENT = "OperationCanceledContent";
    @NonNls
    private static final String ERROR_CONTENT = "ErrorContent";
    @NotNull
    private final AsyncProcessIcon.Big myBusyIcon;

    public UnifiedDiffPanel(@Nullable Project project, @NotNull JComponent content, @NotNull DiffContext context) {
        if (content == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(1);
        }
        super(project, context);
        this.myBusyIcon = new AsyncProcessIcon.Big("UnifiedDiff");
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel((Component)content).addToTop((Component)this.myNotificationsPanel);
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.myContentPanel.add((Component)this.myBusyIcon, LOADING_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(DiffBundle.message((String)"error.can.not.calculate.diff.file.too.big", (Object[])new Object[0])), TOO_BIG_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(DiffBundle.message((String)"error.can.not.calculate.diff.operation.canceled", (Object[])new Object[0])), OPERATION_CANCELED_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(CommonBundle.message((String)"title.error", (Object[])new Object[0])), ERROR_CONTENT);
        this.setCurrentCard(LOADING_CONTENT, false);
    }

    public void setLoadingContent() {
        this.setCurrentCard(LOADING_CONTENT);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setTooBigContent() {
        this.setCurrentCard(TOO_BIG_CONTENT);
    }

    public void setOperationCanceledContent() {
        this.setCurrentCard(OPERATION_CANCELED_CONTENT);
    }

    public void setErrorContent() {
        this.setCurrentCard(ERROR_CONTENT);
    }

    @Override
    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            UnifiedDiffPanel.$$$reportNull$$$0(2);
        }
        if (card.equals(LOADING_CONTENT)) {
            this.myBusyIcon.resume();
        } else {
            this.myBusyIcon.suspend();
        }
        super.setCurrentCard(card);
    }

    public boolean isGoodContent() {
        return this.myCurrentCard.equals(GOOD_CONTENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "card";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentCard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

