/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopupController;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u0017\u0018\u0019\u001a\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J,\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions;", "", "<init>", "()V", "showDiff", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "createDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "expand", "uDocument", "copyVcsContent", "RangeMarkerAction", "ShowNextChangeMarkerAction", "ShowPrevChangeMarkerAction", "CopyLineStatusRangeAction", "ShowLineStatusRangeDiffAction", "ToggleByWordDiffAction", "intellij.platform.diff.impl"})
public final class LineStatusMarkerPopupActions {
    @NotNull
    public static final LineStatusMarkerPopupActions INSTANCE = new LineStatusMarkerPopupActions();

    private LineStatusMarkerPopupActions() {
    }

    @JvmStatic
    public static final void showDiff(@NotNull LineStatusTrackerI<?> tracker, @NotNull Range range) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Project project = tracker.getProject();
        Range ourRange = INSTANCE.expand(range, tracker.getDocument(), tracker.getVcsDocument());
        Document document = tracker.getVcsDocument();
        VirtualFile virtualFile = tracker.getVirtualFile();
        TextRange textRange = DiffUtil.getLinesRange(tracker.getVcsDocument(), ourRange.getVcsLine1(), ourRange.getVcsLine2());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLinesRange(...)");
        DiffContent vcsContent = INSTANCE.createDiffContent(project, document, virtualFile, textRange);
        Document document2 = tracker.getDocument();
        VirtualFile virtualFile2 = tracker.getVirtualFile();
        TextRange textRange2 = DiffUtil.getLinesRange(tracker.getDocument(), ourRange.getLine1(), ourRange.getLine2());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getLinesRange(...)");
        DiffContent currentContent = INSTANCE.createDiffContent(project, document2, virtualFile2, textRange2);
        SimpleDiffRequest request = new SimpleDiffRequest(DiffBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, DiffBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), DiffBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
        DiffManager.getInstance().showDiff(project, (DiffRequest)request);
    }

    private final DiffContent createDiffContent(Project project, Document document, VirtualFile highlightFile, TextRange textRange) {
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, document, highlightFile);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        DocumentContent content = documentContent;
        DocumentContent documentContent2 = DiffContentFactory.getInstance().createFragment(project, content, textRange);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"createFragment(...)");
        return (DiffContent)documentContent2;
    }

    private final Range expand(Range range, Document document, Document uDocument) {
        boolean canExpandBefore = range.getLine1() != 0 && range.getVcsLine1() != 0;
        boolean canExpandAfter = range.getLine2() < DiffUtil.getLineCount(document) && range.getVcsLine2() < DiffUtil.getLineCount(uDocument);
        int offset1 = range.getLine1() - (canExpandBefore ? 1 : 0);
        int uOffset1 = range.getVcsLine1() - (canExpandBefore ? 1 : 0);
        int offset2 = range.getLine2() + (canExpandAfter ? 1 : 0);
        int uOffset2 = range.getVcsLine2() + (canExpandAfter ? 1 : 0);
        return new Range(offset1, offset2, uOffset1, uOffset2);
    }

    public final void copyVcsContent(@NotNull LineStatusTrackerI<?> tracker, @NotNull Range range) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String content = DiffUtil.getLinesContent(tracker.getVcsDocument(), range.getVcsLine1(), range.getVcsLine2()) + "\n";
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$CopyLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;Lcom/intellij/openapi/vcs/ex/Range;)V", "isEnabled", "", "actionPerformed", "", "intellij.platform.diff.impl"})
    @ApiStatus.NonExtendable
    public static class CopyLineStatusRangeAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        @NotNull
        private final LineStatusTrackerI<?> tracker;

        public CopyLineStatusRangeAction(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(editor, (LineStatusMarkerRangesSource)tracker, range, "$Copy");
            this.tracker = tracker;
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return range.hasVcsLines();
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            INSTANCE.copyVcsContent(this.tracker, range);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\r\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rangesSource", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "actionId", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;Lcom/intellij/openapi/vcs/ex/Range;Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "isEnabled", "", "intellij.platform.diff.impl"})
    public static abstract class RangeMarkerAction
    extends DumbAwareAction {
        @NotNull
        private final Editor editor;
        @NotNull
        private final LineStatusMarkerRangesSource<?> rangesSource;
        @NotNull
        private final Range range;

        public RangeMarkerAction(@NotNull Editor editor, @NotNull LineStatusMarkerRangesSource<?> rangesSource, @NotNull Range range, @Nullable String actionId) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(rangesSource, (String)"rangesSource");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.editor = editor;
            this.rangesSource = rangesSource;
            this.range = range;
            if (actionId != null) {
                ActionUtil.copyFrom((AnAction)((AnAction)this), (String)actionId);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object newRange = this.rangesSource.findRange(this.range);
            e.getPresentation().setEnabled(newRange != null && !this.editor.isDisposed() && this.isEnabled(this.editor, (Range)newRange));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object newRange = this.rangesSource.findRange(this.range);
            if (newRange != null) {
                this.actionPerformed(this.editor, (Range)newRange);
            }
        }

        protected abstract boolean isEnabled(@NotNull Editor var1, @NotNull Range var2);

        protected abstract void actionPerformed(@NotNull Editor var1, @NotNull Range var2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$ShowLineStatusRangeDiffAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;Lcom/intellij/openapi/vcs/ex/Range;)V", "isEnabled", "", "actionPerformed", "", "intellij.platform.diff.impl"})
    public static class ShowLineStatusRangeDiffAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        @NotNull
        private final LineStatusTrackerI<?> tracker;

        public ShowLineStatusRangeDiffAction(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            super(editor, (LineStatusMarkerRangesSource)tracker, range, "Vcs.ShowDiffChangedLines");
            this.tracker = tracker;
            ShortcutSet[] shortcutSetArray = new ShortcutSet[]{KeymapUtil.getActiveKeymapShortcuts((String)"Vcs.ShowDiffChangedLines"), KeymapUtil.getActiveKeymapShortcuts((String)"Diff.ShowDiff")};
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet(shortcutSetArray));
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return true;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            LineStatusMarkerPopupActions.showDiff(this.tracker, range);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$ShowNextChangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "controller", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;Lcom/intellij/openapi/vcs/ex/Range;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;)V", "isEnabled", "", "actionPerformed", "", "intellij.platform.diff.impl"})
    @ApiStatus.NonExtendable
    public static class ShowNextChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        @NotNull
        private final LineStatusTrackerI<?> tracker;
        @NotNull
        private final LineStatusMarkerRendererWithPopupController controller;

        public ShowNextChangeMarkerAction(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker, @NotNull Range range, @NotNull LineStatusMarkerRendererWithPopupController controller) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            super(editor, (LineStatusMarkerRangesSource)tracker, range, "VcsShowNextChangeMarker");
            this.tracker = tracker;
            this.controller = controller;
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return this.tracker.getNextRange(range.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Object targetRange = this.tracker.getNextRange(range.getLine1());
            if (targetRange != null) {
                this.controller.scrollAndShow(editor, (Range)targetRange);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$ShowPrevChangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$RangeMarkerAction;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "controller", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;Lcom/intellij/openapi/vcs/ex/Range;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;)V", "isEnabled", "", "actionPerformed", "", "intellij.platform.diff.impl"})
    @ApiStatus.NonExtendable
    public static class ShowPrevChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        @NotNull
        private final LineStatusTrackerI<?> tracker;
        @NotNull
        private final LineStatusMarkerRendererWithPopupController controller;

        public ShowPrevChangeMarkerAction(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker, @NotNull Range range, @NotNull LineStatusMarkerRendererWithPopupController controller) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            super(editor, (LineStatusMarkerRangesSource)tracker, range, "VcsShowPrevChangeMarker");
            this.tracker = tracker;
            this.controller = controller;
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return this.tracker.getPrevRange(range.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Object targetRange = this.tracker.getPrevRange(range.getLine1());
            if (targetRange != null) {
                this.controller.scrollAndShow(editor, (Range)targetRange);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupActions$ToggleByWordDiffAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "controller", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;Lcom/intellij/openapi/vcs/ex/Range;Ljava/awt/Point;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.diff.impl"})
    @ApiStatus.NonExtendable
    public static class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware,
    LightEditCompatible {
        @NotNull
        private final Editor editor;
        @NotNull
        private final LineStatusMarkerRangesSource<?> tracker;
        @NotNull
        private final Range range;
        @Nullable
        private final Point mousePosition;
        @NotNull
        private final LineStatusMarkerRendererWithPopupController controller;

        public ToggleByWordDiffAction(@NotNull Editor editor, @NotNull LineStatusMarkerRangesSource<?> tracker, @NotNull Range range, @Nullable Point mousePosition, @NotNull LineStatusMarkerRendererWithPopupController controller) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            super(DiffBundle.message((String)"highlight.words", (Object[])new Object[0]), null, AllIcons.Actions.Highlighting);
            this.editor = editor;
            this.tracker = tracker;
            this.range = range;
            this.mousePosition = mousePosition;
            this.controller = controller;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.tracker.isValid()) {
                return;
            }
            DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            this.controller.reopenRange(this.editor, this.range, this.mousePosition);
        }
    }
}

