/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00020\r2\u001c\u0010\u000e\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\r0\u000fJ.\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u001c\u0010\u000e\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/SqlValuesToColumnMapper;", "", "target", "Lcom/intellij/psi/PsiElement;", "indexRange", "Lkotlin/ranges/IntRange;", "<init>", "(Lcom/intellij/psi/PsiElement;Lkotlin/ranges/IntRange;)V", "getTarget", "()Lcom/intellij/psi/PsiElement;", "getIndexRange", "()Lkotlin/ranges/IntRange;", "processColumnElements", "", "consumer", "Lkotlin/Function2;", "", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "Companion", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlValuesToColumnMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlValuesToColumnMapper.kt\ncom/intellij/sql/SqlValuesToColumnMapper\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,64:1\n66#2,2:65\n66#2,2:67\n66#2,2:69\n66#2,2:71\n*S KotlinDebug\n*F\n+ 1 SqlValuesToColumnMapper.kt\ncom/intellij/sql/SqlValuesToColumnMapper\n*L\n31#1:65,2\n43#1:67,2\n44#1:69,2\n49#1:71,2\n*E\n"})
public final class SqlValuesToColumnMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement target;
    @NotNull
    private final IntRange indexRange;

    private SqlValuesToColumnMapper(PsiElement target, IntRange indexRange) {
        this.target = target;
        this.indexRange = indexRange;
    }

    @NotNull
    public final PsiElement getTarget() {
        return this.target;
    }

    @NotNull
    public final IntRange getIndexRange() {
        return this.indexRange;
    }

    public final void processColumnElements(@NotNull Function2<? super PsiElement, ? super String, Unit> consumer) {
        SqlDmlInstruction instruction;
        SqlQueryExpression sqlQueryExpression;
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement $this$parentOfType_u24default$iv = this.target;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        SqlResultSetExpression query = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlResultSetExpression.class, (boolean)true);
        if (query != null) {
            PsiElement parent = query.getParent();
            while (parent instanceof SqlParenthesizedExpression) {
                parent = ((SqlParenthesizedExpression)parent).getParent();
            }
            if (parent instanceof SqlAsExpression) {
                DasType sqlType;
                PsiElement alias = parent;
                DasType dasType = sqlType = PsiTreeUtil.getChildOfType((PsiElement)alias, SqlColumnAliasListImpl.class) != null ? ((SqlAsExpression)alias).getDasType() : null;
                if (sqlType instanceof SqlTableType) {
                    this.processColumnElements((SqlTableType)sqlType, consumer);
                    return;
                }
            }
        }
        SqlResultSetExpression sqlResultSetExpression = query;
        if (sqlResultSetExpression != null) {
            $this$parentOfType_u24default$iv = (PsiElement)sqlResultSetExpression;
            withSelf$iv = false;
            $i$f$parentOfType = false;
            sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true);
        } else {
            sqlQueryExpression = null;
        }
        if (sqlQueryExpression != null) {
            return;
        }
        SqlResultSetExpression sqlResultSetExpression2 = query;
        if (sqlResultSetExpression2 != null) {
            PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)sqlResultSetExpression2;
            boolean withSelf$iv2 = false;
            boolean $i$f$parentOfType2 = false;
            v4 = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, SqlDmlInstruction.class, (boolean)true);
        } else {
            v4 = instruction = null;
        }
        if (instruction != null) {
            SqlTableType sqlTableType = instruction.getTargetType();
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"getTargetType(...)");
            this.processColumnElements(sqlTableType, consumer);
            return;
        }
        PsiElement $this$parentOfType_u24default$iv3 = this.target;
        boolean withSelf$iv3 = false;
        boolean $i$f$parentOfType3 = false;
        SqlCreateViewStatement createView = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv3, SqlCreateViewStatement.class, (boolean)true);
        if (createView != null) {
            int n;
            SqlDefinition[] aliases = createView.getColumnAliases();
            int i = this.indexRange.getFirst();
            if (i <= (n = Math.min(this.indexRange.getLast(), aliases.length - 1))) {
                while (true) {
                    consumer.invoke((Object)aliases[i], (Object)aliases[i].getName());
                    if (i == n) break;
                    ++i;
                }
            }
        }
    }

    private final void processColumnElements(SqlTableType sqlType, Function2<? super PsiElement, ? super String, Unit> consumer) {
        int n;
        int id = this.indexRange.getFirst();
        if (id <= (n = Math.min(this.indexRange.getLast(), sqlType.getColumnCount() - 1))) {
            while (true) {
                consumer.invoke((Object)sqlType.getColumnElement(id), (Object)sqlType.getColumnName(id));
                if (id == n) break;
                ++id;
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element, boolean strict) {
        return Companion.getInstance(element, strict);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element) {
        return Companion.getInstance(element);
    }

    public /* synthetic */ SqlValuesToColumnMapper(PsiElement target, IntRange indexRange, DefaultConstructorMarker $constructor_marker) {
        this(target, indexRange);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/SqlValuesToColumnMapper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/sql/SqlValuesToColumnMapper;", "element", "Lcom/intellij/psi/PsiElement;", "strict", "", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IntRange intRange = SqlImplUtil.getImmediateColumnSourceIndices((PsiElement)element, null, (boolean)strict);
            if (intRange == null) {
                return null;
            }
            IntRange indexRange = intRange;
            return new SqlValuesToColumnMapper(element, indexRange, null);
        }

        public static /* synthetic */ SqlValuesToColumnMapper getInstance$default(Companion companion, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getInstance(psiElement, bl);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return com.intellij.sql.SqlValuesToColumnMapper$Companion.getInstance$default(this, element, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

