/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlCaseVsIfInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0005\u0015\u0016\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "preferCase", "", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "problems", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "FunctionKind", "BranchingInfo", "ConvertToIfFix", "ConvertToCaseFix", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class SqlCaseVsIfInspection
extends SqlInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public boolean preferCase;

    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Map map = SqlCaseVsIfInspection.Companion.getIfCaps(dialect, file);
        if (map.isEmpty()) {
            boolean bl = false;
            return null;
        }
        Map caps = map;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, problems, caps, this, onTheFly){
            final /* synthetic */ Map<FunctionKind, String> $caps;
            final /* synthetic */ SqlCaseVsIfInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$caps = $caps;
                this.this$0 = $receiver;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$problems);
            }

            public void visitSqlCaseExpression(SqlCaseExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                BranchingInfo branchingInfo = com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o, this.$caps);
                if (branchingInfo != null) {
                    BranchingInfo branchingInfo2 = branchingInfo;
                    Map<FunctionKind, String> map = this.$caps;
                    SqlCaseVsIfInspection sqlCaseVsIfInspection = this.this$0;
                    BranchingInfo info = branchingInfo2;
                    boolean bl = false;
                    PsiElement psiElement = PsiTreeUtil.findSiblingForward((PsiElement)o.getFirstChild(), (IElementType)((IElementType)SqlCommonKeywords.SQL_CASE), (boolean)false, null);
                    if (psiElement == null) {
                        psiElement = (PsiElement)o;
                    }
                    PsiElement anchor = psiElement;
                    for (Map.Entry<FunctionKind, String> entry : map.entrySet()) {
                        boolean isApplicable;
                        FunctionKind kind = entry.getKey();
                        String name = entry.getValue();
                        if (!(isApplicable = (switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                            case 1 -> {
                                if (info.getConditionalBranches().size() == 1) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> true;
                            case 3 -> {
                                if (info.getSubject() != null) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        }))) continue;
                        Object[] objectArray = new Object[]{name};
                        String string = SqlBundle.message((String)"inspection.message.case.can.be.replaced.with.call", (Object[])objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.report(anchor, string, !sqlCaseVsIfInspection.preferCase, (LocalQuickFix)new ConvertToIfFix(kind, name, o));
                    }
                }
                super.visitSqlCaseExpression(o);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (com.intellij.sql.inspections.SqlCaseVsIfInspection$Companion.access$getBranchingInfo(SqlCaseVsIfInspection.Companion, o, this.$caps) != null) {
                    SqlReferenceExpression sqlReferenceExpression = o.getNameElement();
                    SqlExpression anchor = sqlReferenceExpression != null ? (SqlExpression)sqlReferenceExpression : (SqlExpression)o;
                    PsiElement psiElement = (PsiElement)anchor;
                    Object[] objectArray = new Object[]{anchor.getName()};
                    String string = SqlBundle.message((String)"inspection.message.call.can.be.replaced.with.case.expression", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.report(psiElement, string, this.this$0.preferCase, (LocalQuickFix)new ConvertToCaseFix(o));
                }
                super.visitSqlFunctionCallExpression(o);
            }

            private final void report(PsiElement elementToHighlight, @InspectionMessage String message, boolean isWarning, LocalQuickFix fix) {
                if (!isWarning && !this.$onTheFly) {
                    return;
                }
                PsiElement psiElement = elementToHighlight;
                if (psiElement == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                ProblemDescriptor problemDescriptor = this.myManager.createProblemDescriptor(psiElement, message, true, isWarning ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION, false, localQuickFixArray);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                ProblemDescriptor problem = problemDescriptor;
                this.addDescriptor(problem);
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"preferCase", (String)SqlBundle.message((String)"checkbox.prefer.case.expressions.over.if.functions", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "", "subject", "Lcom/intellij/sql/psi/SqlExpression;", "conditionalBranches", "", "Lkotlin/Pair;", "elseExpression", "<init>", "(Lcom/intellij/sql/psi/SqlExpression;Ljava/util/List;Lcom/intellij/sql/psi/SqlExpression;)V", "getSubject", "()Lcom/intellij/sql/psi/SqlExpression;", "getConditionalBranches", "()Ljava/util/List;", "getElseExpression", "intellij.database.sql.impl"})
    private static final class BranchingInfo {
        @Nullable
        private final SqlExpression subject;
        @NotNull
        private final List<Pair<SqlExpression, SqlExpression>> conditionalBranches;
        @NotNull
        private final SqlExpression elseExpression;

        public BranchingInfo(@Nullable SqlExpression subject, @NotNull List<? extends Pair<? extends SqlExpression, ? extends SqlExpression>> conditionalBranches, @NotNull SqlExpression elseExpression) {
            Intrinsics.checkNotNullParameter(conditionalBranches, (String)"conditionalBranches");
            Intrinsics.checkNotNullParameter((Object)elseExpression, (String)"elseExpression");
            this.subject = subject;
            this.conditionalBranches = conditionalBranches;
            this.elseExpression = elseExpression;
        }

        @Nullable
        public final SqlExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final List<Pair<SqlExpression, SqlExpression>> getConditionalBranches() {
            return this.conditionalBranches;
        }

        @NotNull
        public final SqlExpression getElseExpression() {
            return this.elseExpression;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion;", "", "<init>", "()V", "getIfCaps", "", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "file", "Lcom/intellij/sql/psi/SqlFile;", "getBranchingInfo", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$BranchingInfo;", "Lcom/intellij/sql/psi/SqlCaseExpression;", "caps", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n296#2,2:253\n*S KotlinDebug\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$Companion\n*L\n82#1:253,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<FunctionKind, String> getIfCaps(SqlLanguageDialectEx $this$getIfCaps, SqlFile file) {
            Map map;
            Dbms dbms = $this$getIfCaps.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if (dbms2.isMicrosoft()) {
                int[] nArray;
                Version version = SqlImplUtil.getMinDbmsVersion((PsiElement)((PsiElement)file));
                if (version != null && version.compareTo(nArray = new int[]{11}) < 0) {
                    return MapsKt.emptyMap();
                }
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IIF"));
            } else if (dbms2.isMysql()) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IF"));
            } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.SNOWFLAKE)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"IFF"), TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE")};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else if (dbms2.isHive()) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"));
            } else if (dbms2.isClickHouse()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)FunctionKind.IF), (Object)"if"), TuplesKt.to((Object)((Object)FunctionKind.MULTI_IF), (Object)"multiIf")};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else if (dbms2.isRedshift()) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"decode"));
            } else if (dbms2.isDb2() || dbms2.isExasol() || dbms2.isHsqldb() || dbms2.isOracle() || dbms2.isVertica()) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)FunctionKind.DECODE), (Object)"DECODE"));
            } else {
                return MapsKt.emptyMap();
            }
            return map;
        }

        private final BranchingInfo getBranchingInfo(SqlCaseExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            SqlExpression subject = $this$getBranchingInfo.getExpression();
            boolean isSimpleSubject = subject == null || subject instanceof SqlLiteralExpression || subject instanceof SqlReferenceExpression;
            boolean supportsMulti = caps.get((Object)FunctionKind.MULTI_IF) != null && isSimpleSubject || caps.get((Object)FunctionKind.DECODE) != null;
            List list = $this$getBranchingInfo.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBranches(...)");
            List branches = list;
            ArrayList conditionalBranches = new ArrayList(branches.size());
            SqlExpression elseExpression = null;
            for (SqlClause branch : branches) {
                SqlClause sqlClause = branch;
                if (sqlClause instanceof SqlWhenThenClause) {
                    SqlExpression expression;
                    SqlElement sqlElement;
                    if (!supportsMulti && !((Collection)conditionalBranches).isEmpty()) {
                        return null;
                    }
                    SqlWhenClause sqlWhenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (sqlWhenClause == null || (sqlWhenClause = sqlWhenClause.getExpression()) == null) {
                        return null;
                    }
                    SqlWhenClause condition = sqlWhenClause;
                    SqlThenClause sqlThenClause = ((SqlWhenThenClause)branch).getThenClause();
                    SqlElement sqlElement2 = sqlElement = sqlThenClause != null && (sqlThenClause = sqlThenClause.getBody()) != null ? (SqlElement)CollectionsKt.singleOrNull((Iterable)((Iterable)sqlThenClause)) : null;
                    if ((sqlElement instanceof SqlExpression ? (SqlExpression)sqlElement : null) == null) {
                        return null;
                    }
                    expression = expression;
                    ((Collection)conditionalBranches).add(TuplesKt.to((Object)condition, (Object)expression));
                    continue;
                }
                if (!(sqlClause instanceof SqlElseClause)) continue;
                if (elseExpression != null) {
                    return null;
                }
                JBIterable jBIterable = ((SqlElseClause)branch).getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
                Object object = CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
                if ((object instanceof SqlExpression ? (SqlExpression)object : null) == null) {
                    return null;
                }
                elseExpression = elseExpression;
            }
            SqlExpression sqlExpression = elseExpression;
            if (sqlExpression == null) {
                return null;
            }
            return new BranchingInfo(subject, conditionalBranches, sqlExpression);
        }

        private final BranchingInfo getBranchingInfo(SqlFunctionCallExpression $this$getBranchingInfo, Map<FunctionKind, String> caps) {
            BranchingInfo branchingInfo;
            Object v1;
            block14: {
                Object object = $this$getBranchingInfo.getFunctionDefinition();
                if (object == null || (object = object.getName()) == null) {
                    return null;
                }
                Object functionName = object;
                Iterable $this$firstOrNull$iv = caps.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FunctionKind it = (FunctionKind)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)caps.get((Object)it), (Object)functionName)) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            FunctionKind functionKind = v1;
            if (functionKind == null) {
                return null;
            }
            FunctionKind kind = functionKind;
            Object object = $this$getBranchingInfo.getParameterList();
            if (object == null || (object = object.getExpressionList()) == null) {
                return null;
            }
            Object arguments = object;
            int n = arguments.size();
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: 
                case 2: {
                    if (n < 3 || n % 2 != 1) {
                        return null;
                    }
                    int conditionCount = n / 2;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(n - 1))), (int)2);
                    int i = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n3 = intProgression.getStep();
                    if (n3 > 0 && i <= n2 || n3 < 0 && n2 <= i) {
                        while (true) {
                            ((Collection)conditionalBranches).add(TuplesKt.to(arguments.get(i), arguments.get(i + 1)));
                            if (i == n2) break;
                            i += n3;
                        }
                    }
                    List list = conditionalBranches;
                    Object object2 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"last(...)");
                    branchingInfo = new BranchingInfo(null, list, (SqlExpression)object2);
                    break;
                }
                case 3: {
                    if (n < 4 || n % 2 != 0) {
                        return null;
                    }
                    int conditionCount = n / 2 - 1;
                    ArrayList conditionalBranches = new ArrayList(conditionCount);
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)1, (int)(n - 1))), (int)2);
                    int i = intProgression.getFirst();
                    int n4 = intProgression.getLast();
                    int n5 = intProgression.getStep();
                    if (n5 > 0 && i <= n4 || n5 < 0 && n4 <= i) {
                        while (true) {
                            ((Collection)conditionalBranches).add(TuplesKt.to(arguments.get(i), arguments.get(i + 1)));
                            if (i == n4) break;
                            i += n5;
                        }
                    }
                    SqlExpression sqlExpression = (SqlExpression)CollectionsKt.first((List)arguments);
                    List list = conditionalBranches;
                    Object object3 = CollectionsKt.last((List)arguments);
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"last(...)");
                    branchingInfo = new BranchingInfo(sqlExpression, list, (SqlExpression)object3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return branchingInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FunctionKind.values().length];
                try {
                    nArray[FunctionKind.IF.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FunctionKind.MULTI_IF.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FunctionKind.DECODE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\u000b\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToCaseFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "<init>", "(Lcom/intellij/sql/psi/SqlFunctionCallExpression;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlCaseVsIfInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCaseVsIfInspection.kt\ncom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToCaseFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
    private static final class ConvertToCaseFix
    extends LocalQuickFixOnPsiElement
    implements DumbAware {
        public ConvertToCaseFix(@NotNull SqlFunctionCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            super((PsiElement)callExpression);
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.replace.with.case.expression", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlFunctionCallExpression sqlFunctionCallExpression = startElement instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)startElement : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)psiFile));
            BranchingInfo branchingInfo = Companion.getBranchingInfo(callExpression, (Map<FunctionKind, String>)Companion.getIfCaps(dialect, (SqlFile)psiFile));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info = branchingInfo;
            DdlBuilder $this$invoke_u24lambda_u240 = new DdlBuilder();
            boolean bl = false;
            $this$invoke_u24lambda_u240.applyCodeStyle(project, (SqlLanguageDialect)dialect);
            $this$invoke_u24lambda_u240.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u240.keyword("CASE");
            SqlExpression sqlExpression = info.getSubject();
            if (sqlExpression != null) {
                SqlExpression it = sqlExpression;
                boolean bl2 = false;
                $this$invoke_u24lambda_u240.space().plain(it.getText());
            }
            $this$invoke_u24lambda_u240.newLine();
            for (Pair<SqlExpression, SqlExpression> pair : info.getConditionalBranches()) {
                SqlExpression condition = (SqlExpression)pair.component1();
                SqlExpression expression = (SqlExpression)pair.component2();
                $this$invoke_u24lambda_u240.keyword("WHEN ").plain(condition.getText()).space().keyword("THEN ").plain(expression.getText());
                $this$invoke_u24lambda_u240.newLine();
            }
            $this$invoke_u24lambda_u240.keyword("ELSE ").plain(info.getElseExpression().getText());
            $this$invoke_u24lambda_u240.newLine();
            $this$invoke_u24lambda_u240.keyword("END");
            String string = $this$invoke_u24lambda_u240.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String caseText = string;
            SqlExpression sqlExpression2 = SqlPsiElementFactory.createExpressionFromText((String)caseText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (PsiElement)((PsiElement)callExpression));
            if (sqlExpression2 == null) {
                return;
            }
            SqlExpression caseExpression = sqlExpression2;
            PsiElement newElement = callExpression.replace((PsiElement)caseExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\u0012\u0010\u000e\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$ConvertToIfFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "functionKind", "Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "functionName", "", "caseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "<init>", "(Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;Ljava/lang/String;Lcom/intellij/sql/psi/SqlCaseExpression;)V", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.database.sql.impl"})
    private static final class ConvertToIfFix
    extends LocalQuickFixOnPsiElement
    implements DumbAware {
        @NotNull
        private final FunctionKind functionKind;
        @NotNull
        private final String functionName;

        public ConvertToIfFix(@NotNull FunctionKind functionKind, @NotNull String functionName, @NotNull SqlCaseExpression caseExpression) {
            Intrinsics.checkNotNullParameter((Object)((Object)functionKind), (String)"functionKind");
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)caseExpression, (String)"caseExpression");
            super((PsiElement)caseExpression);
            this.functionKind = functionKind;
            this.functionName = functionName;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.functionName};
            String string = SqlBundle.message((String)"intention.family.name.replace.with.call", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SqlCaseExpression sqlCaseExpression = startElement instanceof SqlCaseExpression ? (SqlCaseExpression)startElement : null;
            if (sqlCaseExpression == null) {
                return;
            }
            SqlCaseExpression caseExpression = sqlCaseExpression;
            BranchingInfo branchingInfo = Companion.getBranchingInfo(caseExpression, (Map<FunctionKind, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)this.functionKind), (Object)this.functionName)));
            if (branchingInfo == null) {
                return;
            }
            BranchingInfo info = branchingInfo;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)psiFile));
            BuiltinFunction builtinFunction = dialect.getSupportedFunctions().get(this.functionName);
            if (builtinFunction == null) {
                return;
            }
            BuiltinFunction ifFunction = builtinFunction;
            DdlBuilder $this$invoke_u24lambda_u240 = new DdlBuilder();
            boolean bl = false;
            SqlExpression sqlExpression = info.getSubject();
            String subjectText = sqlExpression != null ? sqlExpression.getText() : null;
            $this$invoke_u24lambda_u240.applyCodeStyle(project, (SqlLanguageDialect)dialect);
            $this$invoke_u24lambda_u240.withDialect(dialect.getDatabaseDialect());
            $this$invoke_u24lambda_u240.quoteIdentifiers(false);
            $this$invoke_u24lambda_u240.ref((DasObject)ifFunction, ifFunction.getName());
            $this$invoke_u24lambda_u240.plain("(");
            if (this.functionKind == FunctionKind.DECODE) {
                String string = subjectText;
                if (string == null) {
                    return;
                }
                $this$invoke_u24lambda_u240.plain(string).plain(", ");
            }
            for (Pair<SqlExpression, SqlExpression> pair : info.getConditionalBranches()) {
                SqlExpression condition = (SqlExpression)pair.component1();
                SqlExpression expression = (SqlExpression)pair.component2();
                DdlBuilder ddlBuilder = this.functionKind != FunctionKind.DECODE && subjectText != null ? $this$invoke_u24lambda_u240.plain(subjectText + " = " + condition.getText()) : $this$invoke_u24lambda_u240.plain(condition.getText());
                $this$invoke_u24lambda_u240.plain(", ");
                $this$invoke_u24lambda_u240.plain(expression.getText());
                $this$invoke_u24lambda_u240.plain(", ");
            }
            $this$invoke_u24lambda_u240.plain(info.getElseExpression().getText());
            $this$invoke_u24lambda_u240.plain(")");
            String string = $this$invoke_u24lambda_u240.getStatement();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(...)");
            String callText = string;
            SqlExpression sqlExpression2 = SqlPsiElementFactory.createExpressionFromText((String)callText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (PsiElement)((PsiElement)caseExpression));
            SqlFunctionCallExpression sqlFunctionCallExpression = sqlExpression2 instanceof SqlFunctionCallExpression ? (SqlFunctionCallExpression)sqlExpression2 : null;
            if (sqlFunctionCallExpression == null) {
                return;
            }
            SqlFunctionCallExpression callExpression = sqlFunctionCallExpression;
            PsiElement newElement = caseExpression.replace((PsiElement)callExpression);
            CodeStyleManager.getInstance((Project)project).reformat(newElement);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/inspections/SqlCaseVsIfInspection$FunctionKind;", "", "<init>", "(Ljava/lang/String;I)V", "IF", "MULTI_IF", "DECODE", "intellij.database.sql.impl"})
    private static final class FunctionKind
    extends Enum<FunctionKind> {
        public static final /* enum */ FunctionKind IF = new FunctionKind();
        public static final /* enum */ FunctionKind MULTI_IF = new FunctionKind();
        public static final /* enum */ FunctionKind DECODE = new FunctionKind();
        private static final /* synthetic */ FunctionKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FunctionKind[] values() {
            return (FunctionKind[])$VALUES.clone();
        }

        public static FunctionKind valueOf(String value) {
            return Enum.valueOf(FunctionKind.class, value);
        }

        @NotNull
        public static EnumEntries<FunctionKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = functionKindArray = new FunctionKind[]{FunctionKind.IF, FunctionKind.MULTI_IF, FunctionKind.DECODE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

