/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlDuplicateColumnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlDuplicateColumnInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!dialect.getDbms().isSybase()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, onTheFly){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSqlSelectClause(SqlSelectClause o) {
                void $this$groupByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                Iterable $this$groupBy$iv = o.getExpressions();
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv$iv;
                    String string;
                    SqlExpression it = (SqlExpression)element$iv$iv;
                    boolean bl = false;
                    Object object3 = it instanceof SqlAsExpression ? (SqlAsExpression)it : null;
                    if (object3 != null && (object3 = object3.getName()) != null) {
                        Object it2 = object3;
                        boolean bl2 = false;
                        string = StringUtil.toLowerCase((String)it2);
                    } else {
                        string = null;
                    }
                    String key$iv$iv = string;
                    Map map = destination$iv$iv;
                    String key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    String name = (String)entry.getKey();
                    List columns = (List)entry.getValue();
                    if (name == null || !this.hasUnmatchedReferences(columns)) continue;
                    this.reportError(name, columns);
                }
            }

            private final boolean hasUnmatchedReferences(List<? extends SqlExpression> columns) {
                if (columns.size() <= 1) {
                    return false;
                }
                PsiElement lastTarget = null;
                PsiElement lastQualifier = null;
                for (SqlExpression sqlExpression : columns) {
                    SqlResolveResult resolveResult;
                    SqlReferenceExpression ref;
                    ResolveResult resolveResult2;
                    SqlAsExpression sqlAsExpression = sqlExpression instanceof SqlAsExpression ? (SqlAsExpression)sqlExpression : null;
                    SqlExpression sqlExpression2 = sqlAsExpression != null ? sqlAsExpression.getExpression() : null;
                    SqlReferenceExpression sqlReferenceExpression = sqlExpression2 instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression2 : null;
                    if (sqlReferenceExpression == null || ((resolveResult2 = (ref = sqlReferenceExpression).getReference().resolveSingle()) instanceof SqlResolveResult ? (SqlResolveResult)resolveResult2 : null) == null) continue;
                    resolveResult = resolveResult;
                    PsiElement currentTarget = resolveResult.getElement();
                    PsiElement currentQualifier = resolveResult.getQualifier();
                    if (lastTarget != null && !Intrinsics.areEqual((Object)currentTarget, lastTarget) || lastQualifier != null && !Intrinsics.areEqual((Object)currentQualifier, lastQualifier)) {
                        return true;
                    }
                    lastTarget = currentTarget;
                    lastQualifier = currentQualifier;
                }
                return false;
            }

            private final void reportError(String name, List<? extends SqlExpression> columns) {
                Object[] objectArray = new Object[]{name};
                String string = SqlBundle.message((String)"inspection.message.column.name.specified.more.than.once", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                for (SqlExpression sqlExpression : columns) {
                    this.addDescriptor(this.$manager.createProblemDescriptor((PsiElement)sqlExpression, message, true, ProblemHighlightType.GENERIC_ERROR, this.$onTheFly, new LocalQuickFix[0]));
                }
            }
        };
    }
}

