/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForest;
import com.intellij.database.explorer.forest.DvForestRootFolder;
import com.intellij.database.explorer.forest.DvForestService;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.explorer.forest.ShiftDirection;
import com.intellij.database.explorer.structure.DvForestActionService;
import com.intellij.database.explorer.structure.DvForestActionServiceImpl;
import com.intellij.database.explorer.structure.DvForestActionServiceImpl$adjustDataSourcePaths$;
import com.intellij.database.explorer.structure.DvForestActionServiceImpl$deleteFolders$;
import com.intellij.database.explorer.structure.DvForestActionServiceImpl$moveForestNodes$;
import com.intellij.database.explorer.structure.DvForestActionServiceImpl$shiftNodes$;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseViewService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J2\u0010$\u001a\u00020\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0 2\u0006\u0010'\u001a\u00020\u00182\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)H\u0016J \u0010,\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020+H\u0002J \u0010/\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00122\u0006\u0010.\u001a\u00020+H\u0002J&\u00101\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00182\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0012032\u0006\u0010.\u001a\u00020+H\u0002J\u001e\u00104\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00182\f\u00105\u001a\b\u0012\u0004\u0012\u00020*06H\u0002J\u001e\u00107\u001a\u00020\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010;\u001a\u00020\u001c2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120 2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010=\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020&0 2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010?\u001a\u00020\u001e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00160 2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u00162\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00160BH\u0002J\u001e\u0010C\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u00182\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00160BH\u0002J\u001e\u0010D\u001a\u00020\u001e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120 2\u0006\u00109\u001a\u00020:H\u0016J$\u0010E\u001a\u00020\u001e2\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0012030 2\u0006\u00109\u001a\u00020:H\u0016J$\u0010G\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u00162\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0012030BH\u0002J$\u0010H\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u00182\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0012030BH\u0002J\u0016\u0010I\u001a\u00020\u001c2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020*0BH\u0002J \u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010N\u001a\u00020\u0018H\u0002J\u0016\u0010O\u001a\u00020\u001e2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001203H\u0002J\u001e\u0010Q\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020&0 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006S"}, d2={"Lcom/intellij/database/explorer/structure/DvForestActionServiceImpl;", "Lcom/intellij/database/explorer/structure/DvForestActionService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "forestService", "Lcom/intellij/database/explorer/forest/DvForestService;", "getForestService", "()Lcom/intellij/database/explorer/forest/DvForestService;", "structureService", "Lcom/intellij/database/explorer/structure/DvTreeStructureService;", "getStructureService", "()Lcom/intellij/database/explorer/structure/DvTreeStructureService;", "forest", "Lcom/intellij/database/explorer/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "getForest", "()Lcom/intellij/database/explorer/forest/DvForest;", "createNewFolder", "Lcom/intellij/database/explorer/forest/DvNiceFolder;", "parent", "Lcom/intellij/database/explorer/forest/DvFolder;", "name", "", "focus", "", "deleteFolders", "", "foldersToDelete", "", "withAllSubfoldersAndDataSources", "resurrectFolders", "foldersToResurrect", "moveForestNodes", "nodesToMove", "Lcom/intellij/database/model/basic/BasicNode;", "targetFolder", "desiredPositions", "", "Lcom/intellij/database/explorer/forest/DvArm;", "", "moveFolder", "folderToMove", "desiredPosition", "moveDataSource", "dataSourceToMove", "moveBushRef", "bushRefToMove", "Lcom/intellij/database/explorer/forest/DvBushRef;", "checkForLoops", "movingFolders", "", "canShiftFolders", "foldersToShift", "direction", "Lcom/intellij/database/explorer/forest/ShiftDirection;", "canShiftDataSources", "dsToShift", "shiftNodes", "nodes", "shiftFolders", "shiftFoldersLevelUp", "currentParent", "", "shiftFoldersLevelDown", "shiftDataSources", "shiftBushes", "bushesToShift", "shiftBushesLevelUp", "shiftBushesLevelDown", "positionsAreHuggerMugger", "renameFolder", "folder", "newName", "adjustDataSourcePaths", "startWithFolder", "adjustBushPath", "br", "notifyThatTheTreeWasChanged", "nodesToSelect", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestActionServiceImpl.kt\ncom/intellij/database/explorer/structure/DvForestActionServiceImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,393:1\n30#2,2:394\n30#2,2:396\n30#2,2:483\n1#3:398\n1#3:418\n1#3:463\n1068#4:399\n1068#4:403\n1021#4,2:405\n1642#4,10:407\n1915#4:417\n1916#4:419\n1652#4:420\n1786#4,3:421\n812#4,12:424\n1786#4,3:436\n1786#4,3:440\n1786#4,3:443\n1786#4,3:446\n1786#4,3:449\n1642#4,10:452\n1915#4:462\n1916#4:464\n1652#4:465\n1586#4:466\n1661#4,3:467\n1786#4,3:470\n1786#4,3:473\n1786#4,3:476\n1786#4,3:479\n1807#4,3:485\n1021#4,2:488\n1807#4,3:490\n1021#4,2:493\n479#5:400\n1342#5,2:401\n479#5:404\n479#5:439\n479#5:482\n*S KotlinDebug\n*F\n+ 1 DvForestActionServiceImpl.kt\ncom/intellij/database/explorer/structure/DvForestActionServiceImpl\n*L\n28#1:394,2\n31#1:396,2\n390#1:483,2\n179#1:418\n280#1:463\n54#1:399\n81#1:403\n168#1:405,2\n179#1:407,10\n179#1:417\n179#1:419\n179#1:420\n196#1:421,3\n197#1:424,12\n200#1:436,3\n253#1:440,3\n254#1:443,3\n272#1:446,3\n273#1:449,3\n280#1:452,10\n280#1:462\n280#1:464\n280#1:465\n313#1:466\n313#1:467,3\n329#1:470,3\n330#1:473,3\n346#1:476,3\n347#1:479,3\n219#1:485,3\n220#1:488,2\n294#1:490,3\n295#1:493,2\n60#1:400\n62#1:401,2\n94#1:404\n203#1:439\n373#1:482\n*E\n"})
public final class DvForestActionServiceImpl
implements DvForestActionService {
    @NotNull
    private final Project project;

    public DvForestActionServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DvForestService getForestService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvForestService)object;
    }

    private final DvTreeStructureService getStructureService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DvTreeStructureService)object;
    }

    private final DvForest<DataSourceNode> getForest() {
        return this.getForestService().getForest();
    }

    @NotNull
    public DvNiceFolder createNewFolder(@Nullable DvFolder parent2, @NotNull String name, boolean focus) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DvFolder dvFolder = parent2;
        if (dvFolder == null) {
            dvFolder = (DvFolder)this.getForest().getRoot();
        }
        DvFolder parentFolder = dvFolder;
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)name, (char)'/', (char)' ', (boolean)false, (int)4, null))).toString();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "New Folder";
        } else {
            charSequence = charSequence2;
        }
        String newFolderName = (String)charSequence;
        DvNiceFolder newFolder = (DvNiceFolder)DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.createNewFolder$lambda$1(parentFolder, newFolderName), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.setOf((Object)newFolder));
        return newFolder;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteFolders(@NotNull Collection<DvNiceFolder> foldersToDelete, boolean withAllSubfoldersAndDataSources, boolean focus) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(foldersToDelete, (String)"foldersToDelete");
        Iterable iterable = foldersToDelete;
        boolean $i$f$sortedBy = false;
        List sortedFolders = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DvNiceFolder it = (DvNiceFolder)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf((it.getLevel() << 24) + it.getOrderId());
                it = (DvNiceFolder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf((it.getLevel() << 24) + it.getOrderId()));
            }
        }));
        ArrayList<DataSourceNode> nestedDataSources = new ArrayList<DataSourceNode>();
        for (DvNiceFolder f : sortedFolders) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            Sequence sequence = SequencesKt.asSequence((Iterator)this.getForest().getInternalTree().traverseBreadthFirst((Object)f));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)deleteFolders$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.mapNotNull((Sequence)sequence2, DvForestActionServiceImpl::deleteFolders$lambda$1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataSourceNode d = (DataSourceNode)element$iv;
                boolean bl = false;
                nestedDataSources.add(d);
            }
        }
        if (!((Collection)nestedDataSources).isEmpty()) {
            throw new UnsupportedOperationException("Deleting nested data sources is not supported yet. Found nested data sources: " + CollectionsKt.joinToString$default((Iterable)nestedDataSources, null, null, null, (int)0, null, DvForestActionServiceImpl::deleteFolders$lambda$3, (int)31, null));
        }
        DvForest forest = this.getForestService().getForest();
        DvForest.modifyTree$default((DvForest)forest, (boolean)false, () -> DvForestActionServiceImpl.deleteFolders$lambda$4(sortedFolders, withAllSubfoldersAndDataSources), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public void resurrectFolders(@NotNull Collection<DvNiceFolder> foldersToResurrect, boolean focus) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(foldersToResurrect, (String)"foldersToResurrect");
        Iterable iterable = foldersToResurrect;
        boolean $i$f$sortedBy = false;
        List sortedFolders = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DvNiceFolder it = (DvNiceFolder)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrderId());
                it = (DvNiceFolder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrderId()));
            }
        }));
        DvForest forest = this.getForestService().getForest();
        DvForest.modifyTree$default((DvForest)forest, (boolean)false, () -> DvForestActionServiceImpl.resurrectFolders$lambda$1(sortedFolders), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, sortedFolders);
    }

    public void moveForestNodes(@NotNull Collection<? extends BasicNode> nodesToMove, @NotNull DvFolder targetFolder, @NotNull Map<DvArm, Integer> desiredPositions) {
        boolean hasLoops;
        Intrinsics.checkNotNullParameter(nodesToMove, (String)"nodesToMove");
        Intrinsics.checkNotNullParameter((Object)targetFolder, (String)"targetFolder");
        Intrinsics.checkNotNullParameter(desiredPositions, (String)"desiredPositions");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)nodesToMove);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)moveForestNodes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Set movingFolders = SequencesKt.toSet((Sequence)sequence);
        if (!((Collection)movingFolders).isEmpty() && (hasLoops = this.checkForLoops(targetFolder, movingFolders))) {
            return;
        }
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.moveForestNodes$lambda$0(nodesToMove, desiredPositions, this, targetFolder), (int)1, null);
        this.notifyThatTheTreeWasChanged(true, nodesToMove);
    }

    private final void moveFolder(DvFolder targetFolder, DvNiceFolder folderToMove, int desiredPosition) {
        DvFolder oldParent = folderToMove.getParent();
        if (Intrinsics.areEqual((Object)oldParent, (Object)targetFolder)) {
            return;
        }
        oldParent.excludeFolder(folderToMove, true);
        folderToMove.assignParent(targetFolder);
        targetFolder.resurrectFolder(folderToMove, false, desiredPosition);
        boolean bl = Intrinsics.areEqual((Object)folderToMove.getParent(), (Object)targetFolder);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = targetFolder.getInnerFolders().contains(folderToMove);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.adjustDataSourcePaths((DvFolder)folderToMove);
    }

    private final void moveDataSource(DvFolder targetFolder, DataSourceNode dataSourceToMove, int desiredPosition) {
        DvBushRef dvBushRef = this.getForest().getBushRef((BasicUniqueBush)dataSourceToMove);
        if (dvBushRef == null) {
            return;
        }
        DvBushRef bushRef = dvBushRef;
        this.moveBushRef(targetFolder, (DvBushRef<DataSourceNode>)bushRef, desiredPosition);
    }

    private final void moveBushRef(DvFolder targetFolder, DvBushRef<DataSourceNode> bushRefToMove, int desiredPosition) {
        AbstractDataSource ds;
        boolean bl;
        DvFolder oldParent = bushRefToMove.getParent();
        if (Intrinsics.areEqual((Object)oldParent, (Object)targetFolder)) {
            return;
        }
        oldParent.excludeBushRef(bushRefToMove, false);
        boolean bl2 = bl = !oldParent.getInnerBushRefList().contains(bushRefToMove);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bushRefToMove.assignParent(targetFolder);
        targetFolder.resurrectBushRef(bushRefToMove, false, desiredPosition);
        bl = Intrinsics.areEqual((Object)bushRefToMove.getParent(), (Object)targetFolder);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = targetFolder.getInnerBushRefList().contains(bushRefToMove);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DataSourceNode dataSourceNode = (DataSourceNode)bushRefToMove.getBush();
        RawDataSource rawDataSource = dataSourceNode != null ? dataSourceNode.dataSource : null;
        AbstractDataSource abstractDataSource = ds = rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null;
        if (ds != null) {
            String string;
            DvFolder dvFolder = targetFolder;
            if (dvFolder instanceof DvNiceFolder) {
                string = ((DvNiceFolder)targetFolder).getPath();
            } else if (dvFolder instanceof DvForestRootFolder) {
                string = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String newPath = string;
            ds.modify(() -> DvForestActionServiceImpl.moveBushRef$lambda$0(ds, newPath));
        }
    }

    private final boolean checkForLoops(DvFolder targetFolder, Set<? extends DvArm> movingFolders) {
        List targetPath = this.getForest().getInternalTree().pathToRoot((Object)targetFolder);
        for (DvArm node : targetPath) {
            if (!movingFolders.contains(node)) continue;
            return true;
        }
        return false;
    }

    public boolean canShiftFolders(@NotNull Collection<DvNiceFolder> foldersToShift, @NotNull ShiftDirection direction) {
        Intrinsics.checkNotNullParameter(foldersToShift, (String)"foldersToShift");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        DvFolder dvFolder = (DvFolder)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)foldersToShift), (Function1)((Function1)canShiftFolders.parent.1.INSTANCE))));
        if (dvFolder == null) {
            return false;
        }
        DvFolder parent2 = dvFolder;
        ArrayList<DvNiceFolder> folders = new ArrayList<DvNiceFolder>(foldersToShift);
        List $this$sortBy$iv = folders;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DvNiceFolder it = (DvNiceFolder)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition());
                    it = (DvNiceFolder)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                }
            });
        }
        if (this.positionsAreHuggerMugger((List<? extends DvArm>)folders)) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                if (((DvNiceFolder)CollectionsKt.first((List)folders)).getPosition() >= 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((DvNiceFolder)CollectionsKt.last((List)folders)).getPosition() < parent2.getInnerFolders().size() - 1) {
                    yield true;
                }
                yield false;
            }
            case 3 -> parent2 instanceof DvNiceFolder;
            case 4 -> {
                if (((DvNiceFolder)CollectionsKt.first((List)folders)).getPosition() > 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public boolean canShiftDataSources(@NotNull Collection<DataSourceNode> dsToShift, @NotNull ShiftDirection direction) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(dsToShift, (String)"dsToShift");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Iterable iterable = dsToShift;
        DvForest<DataSourceNode> dvForest = this.getForest();
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DvBushRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataSourceNode p0 = (DataSourceNode)element$iv$iv;
            boolean bl2 = false;
            if (dvForest.getBushRef((BasicUniqueBush)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List bushes = (List)destination$iv$iv;
        if (bushes.size() != dsToShift.size()) {
            return false;
        }
        DvFolder dvFolder = (DvFolder)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)bushes), (Function1)((Function1)canShiftDataSources.parent.1.INSTANCE))));
        if (dvFolder == null) {
            return false;
        }
        DvFolder parent2 = dvFolder;
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                if (((DvBushRef)CollectionsKt.first((List)bushes)).getPosition() >= 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((DvBushRef)CollectionsKt.last((List)bushes)).getPosition() < parent2.getInnerBushRefList().size() - 1) {
                    yield true;
                }
                yield false;
            }
            case 3 -> parent2 instanceof DvNiceFolder;
            case 4 -> parent2.getHasInnerFolders();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public void shiftNodes(@NotNull Collection<? extends BasicNode> nodes, @NotNull ShiftDirection direction) {
        boolean bl;
        block11: {
            BasicNode it;
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block10: {
                Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
                Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
                if (nodes.isEmpty()) {
                    return;
                }
                $this$all$iv = nodes;
                $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (BasicNode)element$iv;
                        boolean bl3 = false;
                        if (it instanceof DvNiceFolder) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                void $this$filterIsInstanceTo$iv$iv;
                Object element$iv;
                Iterable $this$filterIsInstance$iv = nodes;
                boolean $i$f$filterIsInstance = false;
                element$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof DvNiceFolder)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List folders = (List)destination$iv$iv;
                this.shiftFolders(folders, direction);
            }
            $this$all$iv = nodes;
            $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (BasicNode)element$iv;
                    boolean bl4 = false;
                    if (it instanceof DataSourceNode) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            void $this$filterIsInstance$iv;
            Sequence $i$f$all = CollectionsKt.asSequence((Iterable)nodes);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)shiftNodes$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List bushes = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence, arg_0 -> DvForestActionServiceImpl.shiftNodes$lambda$2(this, arg_0)));
            this.shiftBushes(bushes, direction);
        }
    }

    public void shiftFolders(@NotNull Collection<DvNiceFolder> foldersToShift, @NotNull ShiftDirection direction) {
        Intrinsics.checkNotNullParameter(foldersToShift, (String)"foldersToShift");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ArrayList<DvNiceFolder> folders = new ArrayList<DvNiceFolder>(foldersToShift);
        int n = folders.size();
        if (n == 0) {
            return;
        }
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.shiftFolders$lambda$0(folders, n, this, direction), (int)1, null);
        this.notifyThatTheTreeWasChanged(true, (Collection<? extends BasicNode>)folders);
    }

    private final void shiftFoldersLevelUp(DvNiceFolder currentParent, List<DvNiceFolder> foldersToShift) {
        boolean bl;
        DvFolder granny;
        block11: {
            boolean $this$all$iv2;
            DvNiceFolder it;
            boolean $i$f$all2;
            block10: {
                granny = currentParent.getParent();
                granny.fixFoldersPositions();
                int newPosition = currentParent.getPosition() + 1;
                for (DvNiceFolder f : CollectionsKt.asReversed(foldersToShift)) {
                    currentParent.excludeFolder(f, true);
                }
                Iterator<Object> iterator = ((Iterable)foldersToShift).iterator();
                int f = 0;
                while (iterator.hasNext()) {
                    int index = f++;
                    DvNiceFolder f2 = (DvNiceFolder)iterator.next();
                    f2.assignParent(granny);
                    granny.resurrectFolder(f2, false, newPosition + index);
                }
                Iterable $this$all$iv2 = foldersToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvNiceFolder)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)granny)) continue;
                        v0 = false;
                        break block10;
                    }
                    v0 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = foldersToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvNiceFolder)element$iv;
                    boolean bl3 = false;
                    if (granny.getInnerFolders().contains(it)) continue;
                    v1 = false;
                    break block11;
                }
                v1 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.adjustDataSourcePaths(granny);
    }

    private final void shiftFoldersLevelDown(DvFolder currentParent, List<DvNiceFolder> foldersToShift) {
        boolean bl;
        DvNiceFolder newParent;
        block13: {
            boolean $this$all$iv2;
            DvNiceFolder it;
            boolean $i$f$all2;
            block12: {
                boolean bl2;
                if (foldersToShift.isEmpty()) {
                    return;
                }
                int newParentPosition = ((DvNiceFolder)CollectionsKt.first(foldersToShift)).getPosition() - 1;
                boolean bl3 = bl2 = newParentPosition >= 0;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                newParent = (DvNiceFolder)currentParent.getInnerFolders().get(newParentPosition);
                for (DvNiceFolder f : CollectionsKt.asReversed(foldersToShift)) {
                    currentParent.excludeFolder(f, true);
                }
                for (DvNiceFolder f : foldersToShift) {
                    f.assignParent((DvFolder)newParent);
                    DvFolder.resurrectFolder$default((DvFolder)((DvFolder)newParent), (DvNiceFolder)f, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv2 = foldersToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvNiceFolder)element$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)newParent)) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = foldersToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v2 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvNiceFolder)element$iv;
                    boolean bl5 = false;
                    if (newParent.getInnerFolders().contains(it)) continue;
                    v2 = false;
                    break block13;
                }
                v2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.adjustDataSourcePaths((DvFolder)newParent);
    }

    /*
     * WARNING - void declaration
     */
    public void shiftDataSources(@NotNull Collection<DataSourceNode> dsToShift, @NotNull ShiftDirection direction) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(dsToShift, (String)"dsToShift");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Iterable iterable = dsToShift;
        DvForest<DataSourceNode> dvForest = this.getForest();
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DvBushRef it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataSourceNode p0 = (DataSourceNode)element$iv$iv;
            boolean bl2 = false;
            if (dvForest.getBushRef((BasicUniqueBush)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List bushesToShift = (List)destination$iv$iv;
        if (bushesToShift.size() != dsToShift.size()) {
            return;
        }
        this.shiftBushes(bushesToShift, direction);
    }

    /*
     * WARNING - void declaration
     */
    public void shiftBushes(@NotNull Collection<DvBushRef<DataSourceNode>> bushesToShift, @NotNull ShiftDirection direction) {
        Collection<DataSourceNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(bushesToShift, (String)"bushesToShift");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        ArrayList<DvBushRef<DataSourceNode>> bushes = new ArrayList<DvBushRef<DataSourceNode>>(bushesToShift);
        int n = bushes.size();
        if (n == 0) {
            return;
        }
        DvFolder parent2 = ((DvBushRef)CollectionsKt.first((List)bushes)).getParent();
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.shiftBushes$lambda$0(parent2, n, bushes, this, direction), (int)1, null);
        Iterable iterable = bushes;
        boolean bl = true;
        DvForestActionServiceImpl dvForestActionServiceImpl = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DvBushRef dvBushRef = (DvBushRef)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            BasicUniqueBush basicUniqueBush = it.getBush();
            Intrinsics.checkNotNull((Object)basicUniqueBush, (String)"null cannot be cast to non-null type com.intellij.database.view.DataSourceNode");
            collection.add((DataSourceNode)basicUniqueBush);
        }
        collection = (List)destination$iv$iv;
        dvForestActionServiceImpl.notifyThatTheTreeWasChanged(bl, (Collection<? extends BasicNode>)collection);
    }

    private final void shiftBushesLevelUp(DvNiceFolder currentParent, List<DvBushRef<DataSourceNode>> bushesToShift) {
        boolean bl;
        block13: {
            boolean $this$all$iv2;
            DvBushRef it;
            boolean $i$f$all2;
            DvFolder granny;
            block12: {
                granny = currentParent.getParent();
                granny.fixBushesPositions();
                boolean insert = granny.getHasInnerBushRefs();
                for (DvBushRef b : CollectionsKt.asReversed(bushesToShift)) {
                    currentParent.excludeBushRef(b, false);
                }
                Iterator<Object> iterator = ((Iterable)bushesToShift).iterator();
                int b = 0;
                while (iterator.hasNext()) {
                    int index = b++;
                    DvBushRef b2 = (DvBushRef)iterator.next();
                    b2.assignParent(granny);
                    if (insert) {
                        granny.resurrectBushRef(b2, false, index);
                        continue;
                    }
                    DvFolder.resurrectBushRef$default((DvFolder)granny, (DvBushRef)b2, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv2 = bushesToShift;
                $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)granny)) continue;
                        v0 = false;
                        break block12;
                    }
                    v0 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$all2);
            }
            Iterable $this$all$iv3 = bushesToShift;
            $i$f$all2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvBushRef)element$iv;
                    boolean bl3 = false;
                    if (granny.getInnerBushRefList().contains(it)) continue;
                    v1 = false;
                    break block13;
                }
                v1 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String $i$f$all = "Assertion failed";
            throw new AssertionError((Object)$i$f$all);
        }
        for (DvBushRef<DataSourceNode> b : bushesToShift) {
            this.adjustBushPath(b);
        }
    }

    private final void shiftBushesLevelDown(DvFolder currentParent, List<DvBushRef<DataSourceNode>> bushesToShift) {
        boolean bl;
        block13: {
            boolean $this$all$iv22;
            DvBushRef it;
            DvNiceFolder newParent;
            block12: {
                if (bushesToShift.isEmpty()) {
                    return;
                }
                DvNiceFolder dvNiceFolder = (DvNiceFolder)CollectionsKt.lastOrNull((List)currentParent.getInnerFolders());
                if (dvNiceFolder == null) {
                    return;
                }
                newParent = dvNiceFolder;
                for (DvBushRef dvBushRef : CollectionsKt.asReversed(bushesToShift)) {
                    currentParent.excludeBushRef(dvBushRef, false);
                }
                for (DvBushRef dvBushRef : bushesToShift) {
                    dvBushRef.assignParent((DvFolder)newParent);
                    DvFolder.resurrectBushRef$default((DvFolder)((DvFolder)newParent), (DvBushRef)dvBushRef, (boolean)false, (int)0, (int)4, null);
                }
                Iterable $this$all$iv22 = bushesToShift;
                boolean string = false;
                if ($this$all$iv22 instanceof Collection && ((Collection)$this$all$iv22).isEmpty()) {
                    v1 = true;
                } else {
                    for (Object element$iv : $this$all$iv22) {
                        it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getParent(), (Object)newParent)) continue;
                        v1 = false;
                        break block12;
                    }
                    v1 = $this$all$iv22 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv22) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterable $this$all$iv3 = bushesToShift;
            boolean bl2 = false;
            if ($this$all$iv3 instanceof Collection && ((Collection)$this$all$iv3).isEmpty()) {
                v2 = true;
            } else {
                for (Object element$iv : $this$all$iv3) {
                    it = (DvBushRef)element$iv;
                    boolean bl3 = false;
                    if (newParent.getInnerBushRefList().contains(it)) continue;
                    v2 = false;
                    break block13;
                }
                v2 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private final boolean positionsAreHuggerMugger(List<? extends DvArm> nodes) {
        int n = nodes.size();
        if (n < 2) {
            return false;
        }
        Iterator iterator = ((Iterable)nodes).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        DvArm it = (DvArm)iterator.next();
        boolean bl = false;
        int n2 = it.getPosition();
        while (iterator.hasNext()) {
            DvArm it22 = (DvArm)iterator.next();
            $i$a$-minOf-DvForestActionServiceImpl$positionsAreHuggerMugger$min$1 = false;
            int it22 = it22.getPosition();
            if (n2 <= it22) continue;
            n2 = it22;
        }
        int min = n2;
        Iterator iterator2 = ((Iterable)nodes).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DvArm it2 = (DvArm)iterator2.next();
        boolean bl2 = false;
        int n3 = it2.getPosition();
        while (iterator2.hasNext()) {
            DvArm it3 = (DvArm)iterator2.next();
            $i$a$-maxOf-DvForestActionServiceImpl$positionsAreHuggerMugger$max$1 = false;
            int n4 = it3.getPosition();
            if (n3 >= n4) continue;
            n3 = n4;
        }
        int max = n3;
        return max - min + 1 != n;
    }

    public void renameFolder(@NotNull DvNiceFolder folder, @NotNull String newName, boolean focus) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String theNewName = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)newName, (char)'/', (char)' ', (boolean)false, (int)4, null))).toString();
        if (((CharSequence)theNewName).length() == 0) {
            return;
        }
        DvForest.modifyTree$default(this.getForest(), (boolean)false, () -> DvForestActionServiceImpl.renameFolder$lambda$0(folder, theNewName, this), (int)1, null);
        this.notifyThatTheTreeWasChanged(focus, SetsKt.setOf((Object)folder));
    }

    private final void adjustDataSourcePaths(DvFolder startWithFolder) {
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)this.getForest().getInternalTree().traverseBreadthFirst((Object)startWithFolder));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)adjustDataSourcePaths$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence bushRefs = sequence;
        for (DvBushRef br : bushRefs) {
            this.adjustBushPath((DvBushRef<DataSourceNode>)br);
        }
    }

    private final void adjustBushPath(DvBushRef<DataSourceNode> br) {
        block0: {
            AbstractDataSource ds;
            DataSourceNode dsn;
            String path = br.getParent().getPath();
            DataSourceNode dataSourceNode = dsn = (DataSourceNode)br.getBush();
            RawDataSource rawDataSource = dataSourceNode != null ? dataSourceNode.dataSource : null;
            AbstractDataSource abstractDataSource = ds = rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null;
            if (abstractDataSource == null) break block0;
            abstractDataSource.modify(() -> DvForestActionServiceImpl.adjustBushPath$lambda$0(ds, path));
        }
    }

    public void notifyThatTheTreeWasChanged(boolean focus, @NotNull Collection<? extends BasicNode> nodesToSelect) {
        Intrinsics.checkNotNullParameter(nodesToSelect, (String)"nodesToSelect");
        this.getStructureService().onFoldersChanged();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DatabaseViewService> serviceClass$iv = DatabaseViewService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((DatabaseViewService)object).refreshTree(focus, nodesToSelect);
    }

    private static final DvNiceFolder createNewFolder$lambda$1(DvFolder $parentFolder, String $newFolderName) {
        return $parentFolder.createNewInnerFolder($newFolderName);
    }

    private static final DataSourceNode deleteFolders$lambda$1(DvBushRef it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (DataSourceNode)it.getBush();
    }

    private static final CharSequence deleteFolders$lambda$3(DataSourceNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final Unit deleteFolders$lambda$4(List $sortedFolders, boolean $withAllSubfoldersAndDataSources) {
        for (DvNiceFolder f : CollectionsKt.asReversed((List)$sortedFolders)) {
            DvFolder p = f.getParent();
            p.excludeFolder(f, $withAllSubfoldersAndDataSources);
        }
        return Unit.INSTANCE;
    }

    private static final Unit resurrectFolders$lambda$1(List $sortedFolders) {
        for (DvNiceFolder f : $sortedFolders) {
            DvFolder p = f.getParent();
            DvFolder.resurrectFolder$default((DvFolder)p, (DvNiceFolder)f, (boolean)true, (int)0, (int)4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveForestNodes$lambda$0(Collection $nodesToMove, Map $desiredPositions, DvForestActionServiceImpl this$0, DvFolder $targetFolder) {
        for (BasicNode node : $nodesToMove) {
            Integer n = (Integer)$desiredPositions.get(node);
            int desiredPosition = n != null ? n : -1;
            BasicNode basicNode = node;
            if (basicNode instanceof DvNiceFolder) {
                this$0.moveFolder($targetFolder, (DvNiceFolder)node, desiredPosition);
                continue;
            }
            if (basicNode instanceof DvBushRef) {
                BasicNode basicNode2 = node;
                Intrinsics.checkNotNull((Object)basicNode2, (String)"null cannot be cast to non-null type com.intellij.database.explorer.forest.DvBushRef<com.intellij.database.view.DataSourceNode>");
                this$0.moveBushRef($targetFolder, (DvBushRef<DataSourceNode>)((DvBushRef)basicNode2), desiredPosition);
                continue;
            }
            if (!(basicNode instanceof DataSourceNode)) continue;
            this$0.moveDataSource($targetFolder, (DataSourceNode)node, desiredPosition);
        }
        return Unit.INSTANCE;
    }

    private static final void moveBushRef$lambda$0(AbstractDataSource $ds, String $newPath) {
        $ds.setGroupName($newPath);
    }

    private static final DvBushRef shiftNodes$lambda$2(DvForestActionServiceImpl this$0, DataSourceNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getForest().getBushRef((BasicUniqueBush)it);
    }

    private static final Unit shiftFolders$lambda$0(ArrayList $folders, int $n, DvForestActionServiceImpl this$0, ShiftDirection $direction) {
        DvFolder parent2 = ((DvNiceFolder)CollectionsKt.first((List)$folders)).getParent();
        parent2.fixFoldersPositions();
        if ($n >= 2) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = $folders;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DvNiceFolder it = (DvNiceFolder)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getParent(), (Object)parent2))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Unit.INSTANCE;
            }
            List $this$sortBy$iv = $folders;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvNiceFolder it = (DvNiceFolder)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPosition());
                        it = (DvNiceFolder)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                    }
                });
            }
            if (this$0.positionsAreHuggerMugger($folders)) {
                return Unit.INSTANCE;
            }
        }
        int familySize = parent2.getInnerFolders().size();
        int firstPosition = ((DvNiceFolder)CollectionsKt.first((List)$folders)).getPosition();
        int lastPosition = ((DvNiceFolder)CollectionsKt.last((List)$folders)).getPosition();
        int n = WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()];
        if (n == 1 && firstPosition >= 1) {
            parent2.shiftInnerFolders(firstPosition, $n, $direction);
        } else if (n == 2 && lastPosition < familySize - 1) {
            parent2.shiftInnerFolders(firstPosition, $n, $direction);
        } else if (n == 3 && parent2 instanceof DvNiceFolder) {
            this$0.shiftFoldersLevelUp((DvNiceFolder)parent2, $folders);
        } else if (n == 4 && firstPosition > 0) {
            this$0.shiftFoldersLevelDown(parent2, $folders);
        }
        return Unit.INSTANCE;
    }

    private static final Unit shiftBushes$lambda$0(DvFolder $parent, int $n, ArrayList $bushes, DvForestActionServiceImpl this$0, ShiftDirection $direction) {
        $parent.fixBushesPositions();
        if ($n >= 2) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = $bushes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DvBushRef it = (DvBushRef)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getParent(), (Object)$parent))) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Unit.INSTANCE;
            }
            List $this$sortBy$iv = $bushes;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvBushRef it = (DvBushRef)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPosition());
                        it = (DvBushRef)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                    }
                });
            }
            if (this$0.positionsAreHuggerMugger($bushes)) {
                return Unit.INSTANCE;
            }
        }
        int familySize = $parent.getInnerBushRefList().size();
        int firstPosition = ((DvBushRef)CollectionsKt.first((List)$bushes)).getPosition();
        int lastPosition = ((DvBushRef)CollectionsKt.last((List)$bushes)).getPosition();
        int n = WhenMappings.$EnumSwitchMapping$0[$direction.ordinal()];
        if (n == 1 && firstPosition >= 1) {
            $parent.shiftInnerBushes(firstPosition, $n, $direction);
        } else if (n == 2 && lastPosition < familySize - 1) {
            $parent.shiftInnerBushes(firstPosition, $n, $direction);
        } else if (n == 3 && $parent instanceof DvNiceFolder) {
            this$0.shiftBushesLevelUp((DvNiceFolder)$parent, $bushes);
        } else if (n == 4 && $parent.getHasInnerFolders()) {
            this$0.shiftBushesLevelDown($parent, $bushes);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renameFolder$lambda$0(DvNiceFolder $folder, String $theNewName, DvForestActionServiceImpl this$0) {
        $folder.rename($theNewName);
        this$0.adjustDataSourcePaths((DvFolder)$folder);
        return Unit.INSTANCE;
    }

    private static final void adjustBushPath$lambda$0(AbstractDataSource $ds, String $path) {
        $ds.setGroupName($path);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShiftDirection.values().length];
            try {
                nArray[ShiftDirection.shiftSiblingsUp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftSiblingsDown.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftLevelUp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShiftDirection.shiftLevelDown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

